/*
 * Decompiled with CFR 0.152.
 */
package ij.macro;

import ij.IJ;
import ij.macro.Interpreter;
import ij.macro.MacroConstants;
import ij.macro.Symbol;
import ij.macro.Variable;

public class Program
implements MacroConstants {
    private int maxSymbols = 800;
    private int maxProgramSize = 2000;
    private int pc = -1;
    int stLoc = -1;
    int symTabLoc;
    Symbol[] table = new Symbol[this.maxSymbols];
    int[] code = new int[this.maxProgramSize];
    Variable[] globals;
    boolean hasVars;

    public Program() {
        this.addKeywords();
        this.addFunctions();
        this.addNumericFunctions();
        this.addStringFunctions();
        this.addArrayFunctions();
    }

    public int[] getCode() {
        return this.code;
    }

    public Symbol[] getSymbolTable() {
        return this.table;
    }

    void addKeywords() {
        int n = 0;
        while (n < MacroConstants.keywords.length) {
            this.addSymbol(new Symbol(MacroConstants.keywordIDs[n], MacroConstants.keywords[n]));
            ++n;
        }
    }

    void addFunctions() {
        int n = 0;
        while (n < MacroConstants.functions.length) {
            this.addSymbol(new Symbol(MacroConstants.functionIDs[n], MacroConstants.functions[n]));
            ++n;
        }
    }

    void addNumericFunctions() {
        int n = 0;
        while (n < MacroConstants.numericFunctions.length) {
            this.addSymbol(new Symbol(MacroConstants.numericFunctionIDs[n], MacroConstants.numericFunctions[n]));
            ++n;
        }
    }

    void addStringFunctions() {
        int n = 0;
        while (n < MacroConstants.stringFunctions.length) {
            this.addSymbol(new Symbol(MacroConstants.stringFunctionIDs[n], MacroConstants.stringFunctions[n]));
            ++n;
        }
    }

    void addArrayFunctions() {
        int n = 0;
        while (n < MacroConstants.arrayFunctions.length) {
            this.addSymbol(new Symbol(MacroConstants.arrayFunctionIDs[n], MacroConstants.arrayFunctions[n]));
            ++n;
        }
    }

    void addSymbol(Symbol symbol) {
        ++this.stLoc;
        if (this.stLoc == this.table.length) {
            Symbol[] symbolArray = new Symbol[this.maxSymbols * 2];
            System.arraycopy(this.table, 0, symbolArray, 0, this.maxSymbols);
            this.table = symbolArray;
            this.maxSymbols *= 2;
        }
        this.table[this.stLoc] = symbol;
    }

    void addToken(int n) {
        ++this.pc;
        if (this.pc == this.code.length) {
            int[] nArray = new int[this.maxProgramSize * 2];
            System.arraycopy(this.code, 0, nArray, 0, this.maxProgramSize);
            this.code = nArray;
            this.maxProgramSize *= 2;
        }
        this.code[this.pc] = n;
    }

    Symbol lookupWord(String string) {
        Symbol symbol = null;
        int n = 0;
        while (n < this.maxSymbols) {
            symbol = this.table[n];
            if (symbol == null) break;
            String string2 = symbol.str;
            if (string2 != null && symbol.type != 133 && string.equals(string2)) {
                this.symTabLoc = n;
                break;
            }
            ++n;
        }
        return symbol;
    }

    void saveGlobals(Interpreter interpreter) {
        if (interpreter.topOfStack == -1) {
            return;
        }
        int n = interpreter.topOfStack + 1;
        this.globals = new Variable[n];
        int n2 = 0;
        while (n2 < n) {
            this.globals[n2] = interpreter.stack[n2];
            ++n2;
        }
    }

    public void dumpSymbolTable() {
        IJ.log("");
        IJ.log("Symbol Table");
        int n = 0;
        while (n <= this.maxSymbols) {
            Symbol symbol = this.table[n];
            if (symbol == null) break;
            IJ.log(n + " " + symbol);
            ++n;
        }
    }

    public void dumpProgram() {
        IJ.log("");
        IJ.log("Tokenized Program");
        int n = 0;
        while (n <= this.pc) {
            IJ.log(n + "\t" + (this.code[n] & 0xFFFF) + "  " + this.decodeToken(this.code[n]));
            ++n;
        }
    }

    public Variable[] getGlobals() {
        return this.globals;
    }

    public boolean hasVars() {
        return this.hasVars;
    }

    public String decodeToken(int n) {
        return this.decodeToken(n & 0xFFFF, n >> 16);
    }

    String decodeToken(int n, int n2) {
        String string;
        block0 : switch (n) {
            case 129: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: {
                string = this.table[n2].str;
                break;
            }
            case 133: {
                string = "\"" + this.table[n2].str + "\"";
                break;
            }
            case 130: {
                double d = this.table[n2].value;
                if ((double)((int)d) == d) {
                    string = IJ.d2s(d, 0);
                    break;
                }
                string = "" + d;
                break;
            }
            case 132: {
                string = "EOL";
                break;
            }
            case 128: {
                string = "EOF";
                break;
            }
            default: {
                if (n < 32) {
                    switch (n) {
                        case 1: {
                            string = "++";
                            break block0;
                        }
                        case 2: {
                            string = "--";
                            break block0;
                        }
                        case 13: {
                            string = "&&";
                            break block0;
                        }
                        case 14: {
                            string = "||";
                            break block0;
                        }
                        case 3: {
                            string = "==";
                            break block0;
                        }
                        case 4: {
                            string = "!=";
                            break block0;
                        }
                        case 5: {
                            string = ">";
                            break block0;
                        }
                        case 6: {
                            string = ">=";
                            break block0;
                        }
                        case 7: {
                            string = "<";
                            break block0;
                        }
                        case 8: {
                            string = "<=";
                            break block0;
                        }
                    }
                    string = "";
                    break;
                }
                if (n >= 200) {
                    string = this.table[n2].str;
                    break;
                }
                char[] cArray = new char[]{(char)n};
                string = new String(cArray);
            }
        }
        return string;
    }
}

