/*
 * Decompiled with CFR 0.152.
 */
package ij.macro;

import ij.IJ;
import ij.macro.Functions;
import ij.macro.MacroConstants;
import ij.macro.Program;
import ij.macro.ReturnException;
import ij.macro.Symbol;
import ij.macro.Tokenizer;
import ij.macro.Variable;

public class Interpreter
implements MacroConstants {
    static final int STACK_SIZE = 1000;
    static final int MAX_ARGS = 20;
    Tokenizer tok;
    int pc;
    int token;
    int tokenAddress;
    double tokenValue;
    String tokenString;
    boolean looseSyntax = true;
    double darg1;
    double darg2;
    double darg3;
    double darg4;
    int lineNumber;
    boolean ignoreEOL = true;
    boolean statusUpdated;
    boolean showingProgress;
    Variable[] stack;
    int topOfStack = -1;
    int topOfGlobals = -1;
    int startOfLocals = 0;
    static Interpreter instance;
    boolean done;
    Program pgm;
    Functions func;
    boolean inFunction;
    String macroName;

    public void run(String string) {
        Tokenizer tokenizer = new Tokenizer();
        Program program = tokenizer.tokenize(string);
        if (program.hasVars) {
            this.saveGlobals2(program);
        }
        this.run(program);
    }

    public void run(Program program) {
        this.pgm = program;
        this.pc = -1;
        instance = this;
        this.pushGlobals();
        if (this.func == null) {
            this.func = new Functions(this, program);
        }
        IJ.showStatus("interpreting");
        if ((program.code[this.pc + 1] & 0xFF) == 200 && (program.code[this.pc + 2] & 0xFF) == 133) {
            this.getToken();
            this.getToken();
        }
        this.doStatements();
        this.func.updateDisplay();
        instance = null;
        if (!this.statusUpdated) {
            IJ.showStatus("");
        }
        if (this.showingProgress) {
            IJ.showProgress(0, 0);
        }
    }

    public void runMacro(Program program, int n, String string) {
        this.pgm = program;
        this.macroName = string;
        this.pc = n - 1;
        instance = this;
        IJ.showStatus("interpreting");
        this.pushGlobals();
        if (this.func == null) {
            this.func = new Functions(this, program);
        }
        if (n == 0) {
            this.doStatements();
        } else {
            this.doBlock();
        }
        this.func.updateDisplay();
        instance = null;
        if (!this.statusUpdated) {
            IJ.showStatus("");
        }
        if (this.showingProgress) {
            IJ.showProgress(0, 0);
        }
    }

    public void saveGlobals(Program program) {
        this.saveGlobals2(program);
    }

    void saveGlobals2(Program program) {
        this.pgm = program;
        this.pc = -1;
        instance = this;
        this.func = new Functions(this, program);
        while (!this.done) {
            this.getToken();
            switch (this.token) {
                case 201: {
                    this.doVar();
                    break;
                }
                case 200: {
                    this.done = true;
                    break;
                }
                case 207: {
                    this.done = true;
                    break;
                }
            }
        }
        instance = null;
        program.saveGlobals(this);
        this.pc = -1;
        this.topOfStack = -1;
        this.done = false;
    }

    /*
     * Unable to fully structure code
     */
    final void getToken() {
        if (this.done) {
            return;
        }
        this.token = this.pgm.code[++this.pc];
        if (this.token > 127) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            this.token = this.pgm.code[++this.pc];
lbl7:
            // 2 sources

            ** while (this.token == 132 && this.ignoreEOL)
        }
lbl8:
        // 1 sources

        this.tokenAddress = this.token >> 16;
        this.token &= 65535;
        var1_1 = this.pgm.table[this.tokenAddress];
        this.tokenString = var1_1.str;
        this.tokenValue = var1_1.value;
        this.done = this.token == 128;
    }

    final int nextToken() {
        return this.pgm.code[this.pc + 1] & 0xFFFF;
    }

    final int nextNonEolToken() {
        int n;
        int n2 = 1;
        do {
            n = this.pgm.code[this.pc + n2];
            ++n2;
        } while (n == 132);
        return n & 0xFFFF;
    }

    final int nextNextNonEolToken() {
        int n;
        int n2 = 1;
        while ((n = this.pgm.code[this.pc + n2++]) == 132) {
        }
        while ((n = this.pgm.code[this.pc + n2++]) == 132) {
        }
        return n & 0xFFFF;
    }

    final void putTokenBack() {
        --this.pc;
        if (this.pc < 0) {
            this.pc = -1;
        }
    }

    void doStatements() {
        while (!this.done) {
            this.doStatement();
        }
    }

    final void doStatement() {
        this.getToken();
        switch (this.token) {
            case 201: {
                this.doVar();
                break;
            }
            case 134: {
                this.func.doFunction(this.pgm.table[this.tokenAddress].type);
                break;
            }
            case 138: {
                this.runUserFunction();
                break;
            }
            case 208: {
                this.doReturn();
                break;
            }
            case 129: {
                this.doAssignment();
                break;
            }
            case 1: 
            case 40: {
                this.putTokenBack();
                this.getAssignmentExpression();
                break;
            }
            case 202: {
                this.doIf();
                return;
            }
            case 203: {
                this.error("Else without if");
                return;
            }
            case 206: {
                this.doFor();
                return;
            }
            case 204: {
                this.doWhile();
                return;
            }
            case 205: {
                this.doDo();
                return;
            }
            case 200: {
                this.skipMacro();
                return;
            }
            case 207: {
                this.skipFunction();
                return;
            }
            case 59: {
                return;
            }
            case 123: {
                this.putTokenBack();
                this.doBlock();
                return;
            }
            case 130: 
            case 133: 
            case 135: 
            case 136: {
                this.putTokenBack();
                IJ.log(this.getString());
                return;
            }
            case 128: {
                break;
            }
            default: {
                this.error("Statement cannot begin with '" + this.pgm.decodeToken(this.token, this.tokenAddress) + "'");
            }
        }
        if (!this.looseSyntax) {
            this.getToken();
            if (this.token != 59) {
                this.error("';' expected");
            }
        }
    }

    Variable runUserFunction() {
        int n = (int)this.tokenValue;
        int n2 = this.startOfLocals;
        this.startOfLocals = this.topOfStack + 1;
        int n3 = this.topOfStack;
        int n4 = this.pushArgs();
        int n5 = this.pc;
        Variable variable = null;
        this.pc = n;
        this.setupArgs(n4);
        boolean bl = this.inFunction;
        this.inFunction = true;
        try {
            this.doBlock();
        }
        catch (ReturnException returnException) {
            variable = new Variable(0, returnException.value, returnException.str, returnException.array);
        }
        this.inFunction = bl;
        this.pc = n5;
        this.trimStack(n3, n2);
        return variable;
    }

    int pushArgs() {
        int n;
        this.getLeftParen();
        int n2 = 0;
        Variable[] variableArray = new Variable[20];
        if (this.nextToken() != 41) {
            do {
                Variable variable;
                if (n2 == 20) {
                    this.error("Too many arguments");
                }
                if ((n = this.nextToken()) == 133 || n == 136) {
                    variableArray[n2] = new Variable(0, 0.0, this.getString());
                } else if (n == 138) {
                    int n3 = this.pc;
                    this.getToken();
                    boolean bl = this.isSimpleFunctionCall(false);
                    this.pc = n3;
                    if (bl) {
                        this.getToken();
                        variable = this.runUserFunction();
                        if (variable == null) {
                            this.error("No return value");
                        }
                        variableArray[n2] = variable;
                    } else {
                        variableArray[n2] = new Variable(0, this.getExpression(), null);
                    }
                } else if (n == 129 && ((this.pgm.code[this.pc + 2] & 0xFF) == 44 || (this.pgm.code[this.pc + 2] & 0xFF) == 41)) {
                    double d = 0.0;
                    Variable[] variableArray2 = null;
                    String string = null;
                    this.getToken();
                    variable = this.lookupNumericVariable();
                    if (variable != null) {
                        int n4 = variable.getType();
                        if (n4 == 0) {
                            d = variable.getValue();
                        } else if (n4 == 1) {
                            variableArray2 = variable.getArray();
                        } else {
                            string = variable.getString();
                        }
                    }
                    variableArray[n2] = new Variable(0, d, string, variableArray2);
                } else {
                    variableArray[n2] = new Variable(0, this.getExpression(), null);
                }
                ++n2;
                this.getToken();
            } while (this.token == 44);
            this.putTokenBack();
        }
        n = n2;
        while (n2 > 0) {
            this.push(variableArray[--n2], this);
        }
        this.getRightParen();
        return n;
    }

    void setupArgs(int n) {
        this.getLeftParen();
        int n2 = this.topOfStack;
        int n3 = n;
        if (this.nextToken() != 41) {
            do {
                this.getToken();
                if (n2 >= 0) {
                    this.stack[n2].symTabIndex = this.tokenAddress;
                }
                --n2;
                --n3;
                this.getToken();
            } while (this.token == 44);
            this.putTokenBack();
        }
        if (n3 != 0) {
            this.error(n + " argument" + (n == 1 ? "" : "s") + " expected");
        }
        this.getRightParen();
    }

    void doReturn() {
        if (this.inFunction) {
            double d = 0.0;
            String string = null;
            Variable[] variableArray = null;
            this.getToken();
            if (this.token != 59) {
                Variable variable;
                boolean bl;
                boolean bl2 = this.token == 133 || this.token == 136;
                boolean bl3 = bl = this.token == 137;
                if (this.token == 129 && (variable = this.lookupVariable(this.tokenAddress)) != null && this.nextToken() == 59) {
                    variableArray = variable.getArray();
                    bl2 = variable.getString() != null;
                }
                this.putTokenBack();
                if (bl2) {
                    string = this.getString();
                } else if (bl) {
                    this.getToken();
                    variableArray = this.func.getArrayFunction(this.pgm.table[this.tokenAddress].type);
                } else if (variableArray == null) {
                    d = this.getExpression();
                }
            }
            throw new ReturnException(d, string, variableArray);
        }
        this.error("Return outside of function");
    }

    /*
     * Unable to fully structure code
     */
    void doFor() {
        var1_1 = this.looseSyntax;
        this.looseSyntax = false;
        this.getToken();
        if (this.token != 40) {
            this.error("'(' expected");
        }
        this.getToken();
        if (this.token != 201) {
            this.putTokenBack();
        }
        do {
            if (this.nextToken() != 59) {
                this.getAssignmentExpression();
            }
            this.getToken();
        } while (this.token == 44);
        if (this.token != 59) {
            this.error("';' expected");
        }
        var2_2 = this.pc;
        var4_3 = 0;
        var5_4 = 1.0;
        while (true) {
            block12: {
                if (this.pgm.code[this.pc + 1] != 59) {
                    var5_4 = this.getLogicalExpression();
                }
                if (var4_3 == 0) {
                    this.checkBoolean(var5_4);
                }
                this.getToken();
                if (this.token != 59) {
                    this.error("';' expected");
                }
                var7_5 = this.pc;
                if (var4_3 == 0) ** GOTO lbl35
                this.pc = var4_3;
                break block12;
lbl-1000:
                // 1 sources

                {
                    this.getToken();
                    if (this.token != 123 && this.token != 59 && this.token != 40 && !this.done) continue;
                    this.error("')' expected");
lbl35:
                    // 3 sources

                    ** while (this.token != 41)
                }
            }
            var4_3 = this.pc;
            if (var5_4 != 1.0) break;
            this.doStatement();
            this.pc = var7_5;
            do {
                if (this.nextToken() != 41) {
                    this.getAssignmentExpression();
                }
                this.getToken();
            } while (this.token == 44);
            this.pc = var2_2;
        }
        this.skipStatement();
        this.looseSyntax = var1_1;
    }

    void doWhile() {
        boolean bl;
        this.looseSyntax = false;
        int n = this.pc;
        do {
            this.pc = n;
            bl = this.getBoolean();
            if (bl) {
                this.doStatement();
                continue;
            }
            this.skipStatement();
        } while (bl && !this.done);
    }

    void doDo() {
        boolean bl;
        this.looseSyntax = false;
        int n = this.pc;
        do {
            this.doStatement();
            this.getToken();
            if (this.token != 204) {
                this.error("'while' expected");
            }
            if (!(bl = this.getBoolean())) continue;
            this.pc = n;
        } while (bl && !this.done);
    }

    final void doBlock() {
        this.getToken();
        if (this.token != 123) {
            this.error("'{' expected");
        }
        while (!this.done) {
            this.getToken();
            if (this.token == 125) break;
            this.putTokenBack();
            this.doStatement();
        }
        if (this.token != 125) {
            this.error("'}' expected");
        }
    }

    final void skipStatement() {
        this.getToken();
        switch (this.token) {
            case 1: 
            case 40: 
            case 129: 
            case 134: 
            case 138: 
            case 201: 
            case 208: {
                this.skipSimpleStatement();
                break;
            }
            case 202: {
                this.skipParens();
                this.skipStatement();
                this.getToken();
                if (this.token == 203) {
                    this.skipStatement();
                    break;
                }
                this.putTokenBack();
                break;
            }
            case 206: {
                this.skipParens();
                this.skipStatement();
                break;
            }
            case 204: {
                this.skipParens();
                this.skipStatement();
                break;
            }
            case 205: {
                this.skipStatement();
                this.getToken();
                this.skipParens();
                break;
            }
            case 59: {
                break;
            }
            case 123: {
                this.putTokenBack();
                this.skipBlock();
                break;
            }
            default: {
                this.error("Skipped statement cannot begin with '" + this.pgm.decodeToken(this.token, this.tokenAddress) + "'");
            }
        }
    }

    final void skipBlock() {
        int n = 0;
        do {
            this.getToken();
            if (this.token == 123) {
                ++n;
                continue;
            }
            if (this.token == 125) {
                --n;
                continue;
            }
            if (!this.done) continue;
            this.error("'}' expected");
            return;
        } while (n > 0);
    }

    final void skipParens() {
        int n = 0;
        do {
            this.getToken();
            if (this.token == 40) {
                ++n;
                continue;
            }
            if (this.token == 41) {
                --n;
                continue;
            }
            if (!this.done) continue;
            this.error("')' expected");
            return;
        } while (n > 0);
    }

    final void skipSimpleStatement() {
        boolean bl = this.done;
        this.getToken();
        while (!bl && !this.done) {
            if (this.token == 59) {
                bl = true;
                continue;
            }
            this.getToken();
        }
    }

    void skipFunction() {
        this.getToken();
        this.skipParens();
        this.skipBlock();
    }

    void skipMacro() {
        this.getToken();
        this.skipBlock();
    }

    final void doAssignment() {
        if ((this.pgm.code[this.pc + 1] & 0xFF) == 91) {
            this.doArrayElementAssignment();
            return;
        }
        int n = this.getExpressionType();
        if (n == 2) {
            this.doStringAssignment();
        } else if (n == 1) {
            this.doArrayAssignment();
        } else if (n == 138) {
            this.doUserFunctionAssignment();
        } else {
            this.putTokenBack();
            this.getAssignmentExpression();
        }
    }

    int getExpressionType() {
        int n = this.pgm.code[this.pc + 2];
        int n2 = n & 0xFF;
        if (n2 == 133 || n2 == 136) {
            return 2;
        }
        if (n2 == 137) {
            return 1;
        }
        if (n2 == 138) {
            return 138;
        }
        if (n2 != 129) {
            return 0;
        }
        Variable variable = this.lookupVariable(n >> 16);
        if (variable == null) {
            return 0;
        }
        int n3 = variable.getType();
        if (n3 != 1) {
            return n3;
        }
        if (this.pgm.code[this.pc + 3] == 46) {
            return 0;
        }
        if (this.pgm.code[this.pc + 3] != 91) {
            return 1;
        }
        int n4 = this.pc;
        this.getToken();
        this.getToken();
        int n5 = this.getIndex();
        this.pc = n4 - 1;
        this.getToken();
        Variable[] variableArray = variable.getArray();
        if (n5 < 0 || n5 >= variableArray.length) {
            return 0;
        }
        return variableArray[n5].getType();
    }

    final void doArrayElementAssignment() {
        Variable variable = this.lookupVariable(this.tokenAddress);
        if (variable == null) {
            this.error("Undefined identifier");
        }
        if (this.pgm.code[this.pc + 5] == 59 && (this.pgm.code[this.pc + 4] == 1 || this.pgm.code[this.pc + 4] == 2)) {
            this.putTokenBack();
            this.getFactor();
            return;
        }
        int n = this.getIndex();
        int n2 = this.getExpressionType();
        this.getToken();
        int n3 = this.token;
        if (n3 != 61 && n3 != 9 && n3 != 10 && n3 != 11 && n3 != 12) {
            this.error("'=', '+=', '-=', '*=' or '/=' expected");
            return;
        }
        if (n3 != 61 && (n2 == 2 || n2 == 1)) {
            this.error("'=' expected");
            return;
        }
        Variable[] variableArray = variable.getArray();
        if (variableArray == null) {
            this.error("Array expected");
        }
        if (n < 0 || n >= variableArray.length) {
            this.error("Index (" + n + ") out of 0-" + (variableArray.length - 1) + " range");
        }
        int n4 = this.nextToken();
        block0 : switch (n2) {
            case 2: {
                variableArray[n].setString(this.getString());
                break;
            }
            case 1: {
                this.getToken();
                if (this.token != 137) break;
                variableArray[n].setArray(this.func.getArrayFunction(this.pgm.table[this.tokenAddress].type));
                break;
            }
            default: {
                switch (n3) {
                    case 61: {
                        variableArray[n].setValue(this.getExpression());
                        break block0;
                    }
                    case 9: {
                        variableArray[n].setValue(variableArray[n].getValue() + this.getExpression());
                        break block0;
                    }
                    case 10: {
                        variableArray[n].setValue(variableArray[n].getValue() - this.getExpression());
                        break block0;
                    }
                    case 11: {
                        variableArray[n].setValue(variableArray[n].getValue() * this.getExpression());
                        break block0;
                    }
                    case 12: {
                        variableArray[n].setValue(variableArray[n].getValue() / this.getExpression());
                    }
                }
            }
        }
    }

    final void doUserFunctionAssignment() {
        this.putTokenBack();
        int n = this.pc;
        this.getToken();
        this.getToken();
        this.getToken();
        boolean bl = this.isSimpleFunctionCall(true);
        this.pc = n;
        this.getToken();
        if (!bl) {
            this.getAssignmentExpression();
        } else {
            int n2;
            Variable variable = this.lookupVariable(this.tokenAddress);
            if (variable == null) {
                variable = this.push(this.tokenAddress, 0.0, null, this);
            }
            this.getToken();
            if (this.token != 61) {
                this.error("'=' expected");
            }
            this.getToken();
            Variable variable2 = this.runUserFunction();
            if (variable2 == null) {
                this.error("No return value");
            }
            if ((n2 = variable2.getType()) == 0) {
                variable.setValue(variable2.getValue());
            } else if (n2 == 1) {
                variable.setArray(variable2.getArray());
            } else {
                variable.setString(variable2.getString());
            }
        }
    }

    boolean isSimpleFunctionCall(boolean bl) {
        int n = 0;
        do {
            this.getToken();
            if (this.token == 40) {
                ++n;
                continue;
            }
            if (this.token == 41) {
                --n;
                continue;
            }
            if (!this.done) continue;
            this.error("')' expected");
        } while (n > 0);
        this.getToken();
        if (bl) {
            return this.token == 59;
        }
        return this.token == 44 || this.token == 41;
    }

    final void doStringAssignment() {
        Variable variable = this.lookupVariable(this.tokenAddress);
        if (variable == null) {
            if (this.nextToken() == 61) {
                variable = this.push(this.tokenAddress, 0.0, null, this);
            } else {
                this.error("Undefined identifier");
            }
        }
        this.getToken();
        if (this.token != 61) {
            this.error("'=' expected");
            return;
        }
        variable.setString(this.getString());
    }

    final void doArrayAssignment() {
        Variable variable = this.lookupVariable(this.tokenAddress);
        if (variable == null) {
            if (this.nextToken() == 61) {
                variable = this.push(this.tokenAddress, 0.0, null, this);
            } else {
                this.error("Undefined identifier");
            }
        }
        this.getToken();
        if (this.token != 61) {
            this.error("'=' expected");
            return;
        }
        this.getToken();
        if (this.token == 137) {
            variable.setArray(this.func.getArrayFunction(this.pgm.table[this.tokenAddress].type));
        } else if (this.token == 129) {
            Variable variable2 = this.lookupVariable(this.tokenAddress);
            variable.setArray(variable2.getArray());
        } else {
            this.error("Array expected");
        }
    }

    final void doIf() {
        this.looseSyntax = false;
        boolean bl = this.getBoolean();
        if (bl) {
            this.doStatement();
        } else {
            this.skipStatement();
        }
        this.getToken();
        if (this.token == 203) {
            if (bl) {
                this.skipStatement();
            } else {
                this.doStatement();
            }
        } else {
            this.putTokenBack();
        }
    }

    final boolean getBoolean() {
        this.getLeftParen();
        Variable.doHash = true;
        double d = this.getLogicalExpression();
        Variable.doHash = false;
        this.checkBoolean(d);
        this.getRightParen();
        return d != 0.0;
    }

    final double getLogicalExpression() {
        double d = this.getBooleanExpression();
        int n = this.nextToken();
        if (n != 13 && n != 14) {
            return d;
        }
        this.checkBoolean(d);
        this.getToken();
        int n2 = this.token;
        double d2 = this.getLogicalExpression();
        this.checkBoolean(d2);
        if (n2 == 13) {
            return (int)d & (int)d2;
        }
        if (n2 == 14) {
            return (int)d | (int)d2;
        }
        return d;
    }

    final double getBooleanExpression() {
        int n = this.nextToken();
        double d = n == 133 || n == 136 ? new Variable(0, 0.0, this.getString()).getHashCode() : this.getExpression();
        n = this.nextToken();
        if (n >= 3 && n <= 8) {
            this.getToken();
            int n2 = this.token;
            n = this.nextToken();
            double d2 = n == 133 || n == 136 ? new Variable(0, 0.0, this.getString()).getHashCode() : this.getExpression();
            switch (n2) {
                case 3: {
                    d = d == d2 ? 1.0 : 0.0;
                    break;
                }
                case 4: {
                    d = d != d2 ? 1.0 : 0.0;
                    break;
                }
                case 5: {
                    d = d > d2 ? 1.0 : 0.0;
                    break;
                }
                case 6: {
                    d = d >= d2 ? 1.0 : 0.0;
                    break;
                }
                case 7: {
                    d = d < d2 ? 1.0 : 0.0;
                    break;
                }
                case 8: {
                    d = d <= d2 ? 1.0 : 0.0;
                }
            }
        }
        return d;
    }

    final double getAssignmentExpression() {
        int n = this.pgm.code[this.pc + 2];
        if ((this.pgm.code[this.pc + 1] & 0xFF) == 129 && (n == 61 || n == 9 || n == 10 || n == 11 || n == 12)) {
            this.getToken();
            Variable variable = this.lookupVariable(this.tokenAddress);
            if (variable == null) {
                variable = this.push(this.tokenAddress, 0.0, null, this);
            }
            this.getToken();
            double d = 0.0;
            if (this.token == 61) {
                d = this.getAssignmentExpression();
            } else {
                d = variable.getValue();
                switch (this.token) {
                    case 9: {
                        d += this.getAssignmentExpression();
                        break;
                    }
                    case 10: {
                        d -= this.getAssignmentExpression();
                        break;
                    }
                    case 11: {
                        d *= this.getAssignmentExpression();
                        break;
                    }
                    case 12: {
                        d /= this.getAssignmentExpression();
                    }
                }
            }
            variable.setValue(d);
            return d;
        }
        return this.getLogicalExpression();
    }

    final void checkBoolean(double d) {
        if (d != 0.0 && d != 1.0) {
            this.error("Boolean expression expected");
        }
    }

    void doVar() {
        this.getToken();
        while (this.token == 129) {
            if (this.nextToken() == 61) {
                this.doAssignment();
            } else {
                Variable variable = this.lookupVariable(this.tokenAddress);
                if (variable == null) {
                    this.push(this.tokenAddress, 0.0, null, this);
                }
            }
            this.getToken();
            if (this.token == 44) {
                this.getToken();
                continue;
            }
            this.putTokenBack();
            break;
        }
    }

    final void getLeftParen() {
        this.getToken();
        if (this.token != 40) {
            this.error("'(' expected");
        }
    }

    final void getRightParen() {
        this.getToken();
        if (this.token != 41) {
            this.error("')' expected");
        }
    }

    final void getParens() {
        if (this.nextToken() == 40) {
            this.getLeftParen();
            this.getRightParen();
        }
    }

    final void getComma() {
        this.getToken();
        if (this.token != 44) {
            if (this.looseSyntax) {
                this.putTokenBack();
            } else {
                this.error("',' expected");
            }
        }
    }

    void error(String string) {
        boolean bl = !this.done;
        this.token = 128;
        this.tokenString = "";
        IJ.showStatus("");
        if (this.showingProgress) {
            IJ.showProgress(0, 0);
        }
        Variable.doHash = false;
        if (bl) {
            String string2 = this.getErrorLine();
            IJ.showMessage("Macro Error", string + " in line " + this.lineNumber + ".\n \n" + string2);
            throw new RuntimeException("Macro canceled");
        }
        this.done = true;
    }

    String getErrorLine() {
        int n = this.pc;
        this.lineNumber = 1;
        this.ignoreEOL = false;
        this.pc = -1;
        int n2 = -1;
        while (this.pc < n) {
            this.getToken();
            if (this.token != 132) continue;
            ++this.lineNumber;
            n2 = this.pc;
        }
        String string = "";
        this.pc = n2;
        this.getToken();
        while (this.token != 132 && !this.done) {
            String string2 = this.pgm.decodeToken(this.token, this.tokenAddress);
            if (this.pc == n) {
                string2 = "<" + string2 + ">";
            }
            string = string + string2 + " ";
            this.getToken();
        }
        return string;
    }

    final String getString() {
        String string = this.getStringTerm();
        while (true) {
            this.getToken();
            if (this.token != 43) break;
            string = string + this.getStringTerm();
        }
        this.putTokenBack();
        return string;
    }

    final String getStringTerm() {
        String string;
        this.getToken();
        switch (this.token) {
            case 133: {
                string = this.tokenString;
                break;
            }
            case 136: {
                string = this.func.getStringFunction(this.pgm.table[this.tokenAddress].type);
                break;
            }
            case 138: {
                Variable variable = this.runUserFunction();
                if (variable == null) {
                    this.error("No return value");
                }
                if ((string = variable.getString()) != null) break;
                double d = variable.getValue();
                if ((double)((int)d) == d) {
                    string = IJ.d2s(d, 0);
                    break;
                }
                string = "" + d;
                break;
            }
            case 129: {
                string = this.lookupStringVariable();
                if (string != null) break;
            }
            default: {
                this.putTokenBack();
                double d = this.getStringExpression();
                if ((double)((int)d) == d) {
                    string = IJ.d2s(d, 0);
                    break;
                }
                string = "" + d;
                if (d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY || d == Double.NaN || string.length() - string.indexOf(46) <= 6 || string.indexOf(69) != -1) break;
                string = IJ.d2s(d, 4);
            }
        }
        return string;
    }

    final boolean isStringFunction() {
        Symbol symbol = this.pgm.table[this.tokenAddress];
        return symbol.type == 2000;
    }

    final double getExpression() {
        double d = this.getTerm();
        while (true) {
            int n;
            if ((n = this.nextNonEolToken()) == 43) {
                this.getToken();
                d += this.getTerm();
                continue;
            }
            if (n != 45) break;
            this.getToken();
            d -= this.getTerm();
        }
        return d;
    }

    final double getTerm() {
        double d = this.getFactor();
        boolean bl = false;
        while (!bl) {
            int n = this.nextToken();
            switch (n) {
                case 42: {
                    this.getToken();
                    d *= this.getFactor();
                    break;
                }
                case 47: {
                    this.getToken();
                    d /= this.getFactor();
                    break;
                }
                case 37: {
                    this.getToken();
                    d %= this.getFactor();
                    break;
                }
                case 38: {
                    this.getToken();
                    d = (int)d & (int)this.getFactor();
                    break;
                }
                case 124: {
                    this.getToken();
                    d = (int)d | (int)this.getFactor();
                    break;
                }
                case 94: {
                    this.getToken();
                    d = (int)d ^ (int)this.getFactor();
                    break;
                }
                case 15: {
                    this.getToken();
                    d = (int)d >> (int)this.getFactor();
                    break;
                }
                case 16: {
                    this.getToken();
                    d = (int)d << (int)this.getFactor();
                    break;
                }
                default: {
                    bl = true;
                }
            }
        }
        return d;
    }

    final double getFactor() {
        double d = 0.0;
        Variable variable = null;
        this.getToken();
        switch (this.token) {
            case 130: {
                d = this.tokenValue;
                break;
            }
            case 135: {
                d = this.func.getFunctionValue(this.pgm.table[this.tokenAddress].type);
                break;
            }
            case 138: {
                variable = this.runUserFunction();
                if (variable == null) {
                    this.error("No return value");
                }
                if (variable.getString() != null) {
                    this.error("Numeric return value expected");
                    break;
                }
                d = variable.getValue();
                break;
            }
            case 209: {
                d = 1.0;
                break;
            }
            case 210: {
                d = 0.0;
                break;
            }
            case 211: {
                d = Math.PI;
                break;
            }
            case 129: {
                variable = this.lookupNumericVariable();
                if (variable == null) {
                    return 0.0;
                }
                int n = this.nextToken();
                if (n == 91) {
                    variable = this.getArrayElement(variable);
                    d = variable.getValue();
                    n = this.nextToken();
                } else if (n == 46) {
                    d = this.getArrayLength(variable);
                    n = this.nextToken();
                } else {
                    d = variable.getValue();
                }
                if (n != 1 && n != 2) break;
                this.getToken();
                if (this.token == 1) {
                    variable.setValue(variable.getValue() + 1.0);
                    break;
                }
                variable.setValue(variable.getValue() - 1.0);
                break;
            }
            case 40: {
                d = this.getLogicalExpression();
                this.getRightParen();
                break;
            }
            case 1: {
                d = this.getFactor();
                d += 1.0;
                break;
            }
            case 2: {
                d = this.getFactor();
                d -= 1.0;
                break;
            }
            case 33: {
                d = this.getFactor();
                if (d == 0.0 || d == 1.0) {
                    d = d == 0.0 ? 1.0 : 0.0;
                    break;
                }
                this.error("Boolean expected");
                break;
            }
            case 45: {
                d = -this.getFactor();
                break;
            }
            case 126: {
                d = ~((int)this.getFactor());
                break;
            }
            default: {
                this.error("Number or numeric function expected");
            }
        }
        return d;
    }

    final Variable getArrayElement(Variable variable) {
        int n = this.getIndex();
        Variable[] variableArray = variable.getArray();
        if (variableArray == null) {
            this.error("Array expected");
        }
        if (n < 0 || n >= variableArray.length) {
            this.error("Index (" + n + ") out of 0-" + (variableArray.length - 1) + " range");
        }
        return variableArray[n];
    }

    final double getArrayLength(Variable variable) {
        Variable[] variableArray;
        this.getToken();
        this.getToken();
        if (this.token != 129 || !this.tokenString.equals("length")) {
            this.error("'length' expected");
        }
        if ((variableArray = variable.getArray()) == null) {
            this.error("Array expected");
        }
        return variableArray.length;
    }

    final double getStringExpression() {
        double d;
        block3: {
            d = this.getTerm();
            while (true) {
                this.getToken();
                if (this.token == 43) {
                    this.getToken();
                    if (this.token == 133 || this.token == 136) {
                        this.putTokenBack();
                        this.putTokenBack();
                        break block3;
                    }
                    this.putTokenBack();
                    d += this.getTerm();
                    continue;
                }
                if (this.token != 45) break;
                d -= this.getTerm();
            }
            this.putTokenBack();
        }
        return d;
    }

    final Variable lookupVariable(int n) {
        Variable variable = null;
        int n2 = this.topOfStack;
        while (n2 >= this.startOfLocals) {
            if (this.stack[n2].symTabIndex == n) {
                variable = this.stack[n2];
                break;
            }
            --n2;
        }
        if (variable == null) {
            int n3 = this.topOfGlobals;
            while (n3 >= 0) {
                if (this.stack[n3].symTabIndex == n) {
                    variable = this.stack[n3];
                    break;
                }
                --n3;
            }
        }
        return variable;
    }

    Variable push(Variable variable, Interpreter interpreter) {
        if (this.stack == null) {
            this.stack = new Variable[1000];
        }
        if (this.topOfStack >= 998) {
            interpreter.error("Stack overflow");
        } else {
            ++this.topOfStack;
        }
        this.stack[this.topOfStack] = variable;
        return variable;
    }

    void pushGlobals() {
        if (this.pgm.globals == null) {
            return;
        }
        if (this.stack == null) {
            this.stack = new Variable[1000];
        }
        int n = 0;
        while (n < this.pgm.globals.length) {
            ++this.topOfStack;
            this.stack[this.topOfStack] = this.pgm.globals[n];
            ++n;
        }
        this.topOfGlobals = this.topOfStack;
    }

    Variable push(int n, double d, String string, Interpreter interpreter) {
        Variable variable = new Variable(n, d, string);
        if (this.stack == null) {
            this.stack = new Variable[1000];
        }
        if (this.topOfStack >= 998) {
            interpreter.error("Stack overflow");
        } else {
            ++this.topOfStack;
        }
        this.stack[this.topOfStack] = variable;
        return variable;
    }

    void trimStack(int n, int n2) {
        int n3 = n + 1;
        while (n3 <= this.topOfStack) {
            this.stack[n3] = null;
            ++n3;
        }
        this.topOfStack = n;
        this.startOfLocals = n2;
    }

    final Variable lookupNumericVariable() {
        Variable variable = null;
        if (this.stack == null) {
            this.undefined();
            return variable;
        }
        boolean bl = false;
        int n = this.topOfStack;
        while (n >= 0) {
            variable = this.stack[n];
            if (variable.symTabIndex == this.tokenAddress) {
                bl = true;
                break;
            }
            --n;
        }
        if (!bl) {
            this.undefined();
        }
        return variable;
    }

    final String lookupStringVariable() {
        if (this.stack == null) {
            this.undefined();
            return "";
        }
        boolean bl = false;
        String string = null;
        int n = this.topOfStack;
        while (n >= 0) {
            if (this.stack[n].symTabIndex == this.tokenAddress) {
                Variable variable = this.stack[n];
                bl = true;
                int n2 = this.nextToken();
                if (n2 == 91) {
                    int n3 = this.pc;
                    int n4 = this.getIndex();
                    Variable[] variableArray = variable.getArray();
                    if (variableArray == null) {
                        this.error("Array expected");
                    }
                    if (n4 < 0 || n4 >= variableArray.length) {
                        this.error("Index (" + n4 + ") out of 0-" + (variableArray.length - 1) + " range");
                    }
                    if ((string = variableArray[n4].getString()) != null) break;
                    this.pc = n3 - 1;
                    this.getToken();
                    break;
                }
                if (variable.getArray() != null) {
                    this.getToken();
                    this.error("'[' expected");
                }
                string = variable.getString();
                break;
            }
            --n;
        }
        if (!bl) {
            this.undefined();
        }
        return string;
    }

    int getIndex() {
        this.getToken();
        if (this.token != 91) {
            this.error("'['expected");
        }
        int n = (int)this.getExpression();
        this.getToken();
        if (this.token != 93) {
            this.error("']' expected");
        }
        return n;
    }

    void undefined() {
        if (this.nextToken() == 40) {
            this.error("Undefined identifier");
        } else {
            this.error("Undefined variable");
        }
    }

    void dump() {
        this.getParens();
        if (!this.done) {
            this.pgm.dumpSymbolTable();
            this.pgm.dumpProgram();
            this.dumpStack();
        }
    }

    void dumpStack() {
        IJ.log("");
        IJ.log("Stack");
        if (this.stack != null) {
            int n = this.topOfStack;
            while (n >= 0) {
                IJ.log(n + " " + this.pgm.table[this.stack[n].symTabIndex].str + " " + this.stack[n]);
                --n;
            }
        }
    }

    public static void abort() {
        if (instance != null) {
            Interpreter.instance.done = true;
            IJ.showStatus("Macro aborted");
        }
    }

    public static Interpreter getInstance() {
        return instance;
    }
}

