/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GUI;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.measure.SplineFitter;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;

public class PolygonRoi
extends Roi {
    protected int maxPoints = 1000;
    protected int[] xp;
    protected int[] yp;
    protected int[] xp2;
    protected int[] yp2;
    protected int nPoints;
    protected int[] xSpline;
    protected int[] ySpline;
    protected int[] xScreenSpline;
    protected int[] yScreenSpline;
    protected int splinePoints = 200;
    protected Graphics g;
    private int lastX;
    private int lastY;
    private double angle1 = -1.0;
    private double degrees = -1.0;
    private int xClipMin;
    private int yClipMin;
    private int xClipMax;
    private int yClipMax;
    long mouseUpTime = 0L;

    public PolygonRoi(int[] nArray, int[] nArray2, int n, int n2) {
        super(0, 0, null);
        if (n2 == 2) {
            this.type = 2;
        } else if (n2 == 3) {
            this.type = 3;
        } else if (n2 == 4) {
            this.type = 4;
        } else if (n2 == 6) {
            this.type = 6;
        } else if (n2 == 8) {
            this.type = 8;
        } else {
            throw new IllegalArgumentException("Invalid type");
        }
        this.maxPoints = nArray.length;
        this.xp = nArray;
        this.yp = nArray2;
        this.xp2 = new int[this.maxPoints];
        this.yp2 = new int[this.maxPoints];
        this.nPoints = n;
        this.finishPolygon();
    }

    public PolygonRoi(int[] nArray, int[] nArray2, int n, ImagePlus imagePlus, int n2) {
        this(nArray, nArray2, n, n2);
        this.setImage(imagePlus);
    }

    public PolygonRoi(int n, int n2, ImagePlus imagePlus) {
        super(n, n2, imagePlus);
        int n3 = Toolbar.getToolId();
        this.type = n3 == 2 ? 2 : (n3 == 14 ? 8 : 6);
        this.xp = new int[this.maxPoints];
        this.yp = new int[this.maxPoints];
        this.xp2 = new int[this.maxPoints];
        this.yp2 = new int[this.maxPoints];
        this.nPoints = 1;
        this.xp[0] = n;
        this.yp[0] = n2;
        this.x = n;
        this.y = n2;
        this.width = 1;
        this.height = 1;
        this.clipX = n;
        this.clipY = n2;
        this.clipWidth = 1;
        this.clipHeight = 1;
        ImageWindow imageWindow = imagePlus.getWindow();
        if (imageWindow != null) {
            this.g = this.ic.getGraphics();
        }
        if (n3 == 2 || n3 == 5 || n3 == 14) {
            this.g.setColor(Roi.ROIColor);
            this.lastX = this.x;
            this.lastY = this.y;
            this.drawStartBox();
        }
        this.state = 0;
    }

    private void drawStartBox() {
        if (this.type != 8) {
            this.g.drawRect(this.ic.screenX(this.startX) - 4, this.ic.screenY(this.startY) - 4, 8, 8);
        }
    }

    public void draw(Graphics graphics) {
        if (this.state != 0) {
            this.updatePolygon();
            graphics.setColor(Roi.ROIColor);
            if (this.xSpline != null) {
                if (this.type == 6 || this.type == 7) {
                    graphics.drawPolyline(this.xScreenSpline, this.yScreenSpline, this.splinePoints);
                } else {
                    graphics.drawPolygon(this.xScreenSpline, this.yScreenSpline, this.splinePoints);
                }
            } else if (this.type == 6 || this.type == 7 || this.type == 8) {
                graphics.drawPolyline(this.xp2, this.yp2, this.nPoints);
            } else {
                graphics.drawPolygon(this.xp2, this.yp2, this.nPoints);
            }
            if ((this.xSpline != null || this.type == 2 || this.type == 6 || this.type == 8) && this.state != 0 && this.clipboard == null) {
                if (this.ic != null) {
                    this.mag = this.ic.getMagnification();
                }
                int n = 2;
                if (this.activeHandle > 0) {
                    this.drawHandle(graphics, this.xp2[this.activeHandle - 1] - n, this.yp2[this.activeHandle - 1] - n);
                }
                if (this.activeHandle < this.nPoints - 1) {
                    this.drawHandle(graphics, this.xp2[this.activeHandle + 1] - n, this.yp2[this.activeHandle + 1] - n);
                }
                int n2 = 0;
                while (n2 < this.nPoints) {
                    this.drawHandle(graphics, this.xp2[n2] - n, this.yp2[n2] - n);
                    ++n2;
                }
            }
            if (this.state != 4) {
                this.showStatus();
            }
            if (this.updateFullWindow) {
                this.updateFullWindow = false;
                this.imp.draw();
            }
        }
    }

    public void drawPixels() {
        ImageProcessor imageProcessor = this.imp.getProcessor();
        if (this.xSpline != null) {
            imageProcessor.moveTo(this.x + this.xSpline[0], this.y + this.ySpline[0]);
            int n = 1;
            while (n < this.splinePoints) {
                imageProcessor.lineTo(this.x + this.xSpline[n], this.y + this.ySpline[n]);
                ++n;
            }
            if (this.type == 2 || this.type == 3 || this.type == 4) {
                imageProcessor.lineTo(this.x + this.xSpline[0], this.y + this.ySpline[0]);
            }
        } else {
            imageProcessor.moveTo(this.x + this.xp[0], this.y + this.yp[0]);
            int n = 1;
            while (n < this.nPoints) {
                imageProcessor.lineTo(this.x + this.xp[n], this.y + this.yp[n]);
                ++n;
            }
            if (this.type == 2 || this.type == 3 || this.type == 4) {
                imageProcessor.lineTo(this.x + this.xp[0], this.y + this.yp[0]);
            }
        }
        if (this.xSpline != null || Line.getWidth() > 1) {
            this.updateFullWindow = true;
        }
    }

    protected void grow(int n, int n2) {
    }

    protected void updatePolygon() {
        int n;
        Rectangle rectangle = this.ic.getSrcRect();
        if (this.ic.getMagnification() == 1.0 && rectangle.x == 0 && rectangle.y == 0) {
            n = 0;
            while (n < this.nPoints) {
                this.xp2[n] = this.xp[n] + this.x;
                this.yp2[n] = this.yp[n] + this.y;
                ++n;
            }
        } else {
            n = 0;
            while (n < this.nPoints) {
                this.xp2[n] = this.ic.screenX(this.xp[n] + this.x);
                this.yp2[n] = this.ic.screenY(this.yp[n] + this.y);
                ++n;
            }
        }
        if (this.xSpline != null) {
            n = 0;
            while (n < this.splinePoints) {
                this.xScreenSpline[n] = this.ic.screenX(this.xSpline[n] + this.x);
                this.yScreenSpline[n] = this.ic.screenY(this.ySpline[n] + this.y);
                ++n;
            }
        }
    }

    void handleMouseMove(int n, int n2) {
        int n3 = Toolbar.getToolId();
        if (n3 != 2 && n3 != 5 && n3 != 14) {
            this.imp.killRoi();
            this.imp.draw();
            return;
        }
        this.g.setXORMode(Color.black);
        this.g.drawLine(this.ic.screenX(this.xp[this.nPoints - 1]), this.ic.screenY(this.yp[this.nPoints - 1]), this.ic.screenX(this.lastX), this.ic.screenY(this.lastY));
        this.g.drawLine(this.ic.screenX(this.xp[this.nPoints - 1]), this.ic.screenY(this.yp[this.nPoints - 1]), this.ic.screenX(n), this.ic.screenY(n2));
        this.lastX = n;
        this.lastY = n2;
        String string = "";
        if (n3 == 5 || n3 == 14) {
            if (this.nPoints == 1) {
                this.angle1 = this.degrees = this.getAngle(this.xp[0], this.yp[0], n, n2);
            } else if (this.nPoints == 2) {
                double d = this.getAngle(this.xp[1], this.yp[1], n, n2);
                this.degrees = Math.abs(180.0 - Math.abs(this.angle1 - d));
                if (this.degrees > 180.0) {
                    this.degrees = 360.0 - this.degrees;
                }
            } else {
                this.angle1 = -1.0;
            }
            if (this.angle1 > 0.0) {
                string = ", angle=" + IJ.d2s(this.degrees);
            }
        }
        IJ.showStatus(this.imp.getLocationAsString(n, n2) + string);
    }

    void finishPolygon() {
        Polygon polygon = new Polygon(this.xp, this.yp, this.nPoints);
        Rectangle rectangle = polygon.getBounds();
        this.x = rectangle.x;
        this.y = rectangle.y;
        this.width = rectangle.width;
        this.height = rectangle.height;
        if (this.nPoints < 2 || this.type != 7 && this.type != 6 && (this.nPoints < 3 || this.width == 0 || this.height == 0)) {
            this.imp.killRoi();
            return;
        }
        int n = 0;
        while (n < this.nPoints) {
            this.xp[n] = this.xp[n] - this.x;
            this.yp[n] = this.yp[n] - this.y;
            ++n;
        }
        this.state = 3;
        if (this.imp != null && this.type != 4) {
            this.imp.draw(this.x - 5, this.y - 5, this.width + 10, this.height + 10);
        }
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
    }

    void drawLineSegments() {
        Polygon polygon = new Polygon(this.xp, this.yp, this.nPoints);
        Rectangle rectangle = polygon.getBounds();
        this.x = rectangle.x;
        this.y = rectangle.y;
        this.width = rectangle.width;
        this.height = rectangle.height;
        this.g.setPaintMode();
        this.g.setColor(Roi.ROIColor);
        this.drawStartBox();
        int n = 0;
        while (n < this.nPoints - 1) {
            this.g.drawLine(this.ic.screenX(this.xp[n]), this.ic.screenY(this.yp[n]), this.ic.screenX(this.xp[n + 1]), this.ic.screenY(this.yp[n + 1]));
            ++n;
        }
    }

    protected void moveHandle(int n, int n2) {
        if (this.clipboard != null) {
            return;
        }
        this.xp[this.activeHandle] = n - this.x;
        this.yp[this.activeHandle] = n2 - this.y;
        if (this.xSpline != null) {
            this.fitSpline(this.splinePoints);
            this.updateClipRect();
            this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
            this.oldX = this.x;
            this.oldY = this.y;
            this.oldWidth = this.width;
            this.oldHeight = this.height;
        } else {
            this.resetBoundingRect();
            this.updateClipRectAndDraw();
        }
        String string = this.type == 8 ? this.getAngleAsString() : "";
        IJ.showStatus(this.imp.getLocationAsString(n, n2) + string);
    }

    void updateClipRectAndDraw() {
        int n;
        int n2;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MAX_VALUE;
        int n5 = 0;
        int n6 = 0;
        if (this.activeHandle > 0) {
            n2 = this.x + this.xp[this.activeHandle - 1];
            n = this.y + this.yp[this.activeHandle - 1];
        } else {
            n2 = this.x + this.xp[this.nPoints - 1];
            n = this.y + this.yp[this.nPoints - 1];
        }
        if (n2 < n3) {
            n3 = n2;
        }
        if (n < n4) {
            n4 = n;
        }
        if (n2 > n5) {
            n5 = n2;
        }
        if (n > n6) {
            n6 = n;
        }
        n2 = this.x + this.xp[this.activeHandle];
        n = this.y + this.yp[this.activeHandle];
        if (n2 < n3) {
            n3 = n2;
        }
        if (n < n4) {
            n4 = n;
        }
        if (n2 > n5) {
            n5 = n2;
        }
        if (n > n6) {
            n6 = n;
        }
        if (this.activeHandle < this.nPoints - 1) {
            n2 = this.x + this.xp[this.activeHandle + 1];
            n = this.y + this.yp[this.activeHandle + 1];
        } else {
            n2 = this.x + this.xp[0];
            n = this.y + this.yp[0];
        }
        if (n2 < n3) {
            n3 = n2;
        }
        if (n < n4) {
            n4 = n;
        }
        if (n2 > n5) {
            n5 = n2;
        }
        if (n > n6) {
            n6 = n;
        }
        int n7 = n3;
        int n8 = n4;
        int n9 = n5;
        int n10 = n6;
        if (this.xClipMin < n7) {
            n7 = this.xClipMin;
        }
        if (this.yClipMin < n8) {
            n8 = this.yClipMin;
        }
        if (this.xClipMax > n9) {
            n9 = this.xClipMax;
        }
        if (this.yClipMax > n10) {
            n10 = this.yClipMax;
        }
        this.xClipMin = n3;
        this.yClipMin = n4;
        this.xClipMax = n5;
        this.yClipMax = n6;
        double d = this.ic.getMagnification();
        int n11 = d < 1.0 ? (int)(5.0 / d) : 5;
        this.imp.draw(n7 - n11, n8 - n11, n9 - n7 + n11 * 2, n10 - n8 + n11 * 2);
    }

    void resetBoundingRect() {
        int n = Integer.MAX_VALUE;
        int n2 = -n;
        int n3 = n;
        int n4 = n2;
        int n5 = 0;
        while (n5 < this.nPoints) {
            int n6;
            int n7 = this.xp[n5];
            if (n7 < n) {
                n = n7;
            }
            if (n7 > n2) {
                n2 = n7;
            }
            if ((n6 = this.yp[n5]) < n3) {
                n3 = n6;
            }
            if (n6 > n4) {
                n4 = n6;
            }
            ++n5;
        }
        if (n != 0) {
            int n8 = 0;
            while (n8 < this.nPoints) {
                int n9 = n8++;
                this.xp[n9] = this.xp[n9] - n;
            }
        }
        if (n3 != 0) {
            int n10 = 0;
            while (n10 < this.nPoints) {
                int n11 = n10++;
                this.yp[n11] = this.yp[n11] - n3;
            }
        }
        this.x += n;
        this.y += n3;
        this.width = n2 - n;
        this.height = n4 - n3;
    }

    String getAngleAsString() {
        double d = this.getAngle(this.xp[0], this.yp[0], this.xp[1], this.yp[1]);
        double d2 = this.getAngle(this.xp[1], this.yp[1], this.xp[2], this.yp[2]);
        this.degrees = Math.abs(180.0 - Math.abs(d - d2));
        if (this.degrees > 180.0) {
            this.degrees = 360.0 - this.degrees;
        }
        return ", angle=" + IJ.d2s(this.degrees);
    }

    protected void mouseDownInHandle(int n, int n2, int n3) {
        this.state = 4;
        this.activeHandle = n;
        int n4 = this.ic.offScreenX(n2);
        int n5 = this.ic.offScreenY(n3);
        int n6 = (int)(10.0 / this.ic.getMagnification());
        this.xClipMin = n4 - n6;
        this.yClipMin = n5 - n6;
        this.xClipMax = n4 + n6;
        this.yClipMax = n5 + n6;
    }

    public void fitSpline(int n) {
        int n2;
        this.splinePoints = n;
        if (this.xSpline == null || this.splinePoints != n) {
            this.xSpline = new int[this.splinePoints];
            this.ySpline = new int[this.splinePoints];
            this.xScreenSpline = new int[this.splinePoints];
            this.yScreenSpline = new int[this.splinePoints];
        }
        int n3 = this.nPoints;
        if (this.type == 2) {
            if (++n3 >= this.xp.length) {
                this.enlargeArrays();
            }
            this.xp[n3 - 1] = this.xp[0];
            this.yp[n3 - 1] = this.yp[0];
        }
        int[] nArray = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            nArray[n4] = n4;
            ++n4;
        }
        SplineFitter splineFitter = new SplineFitter(nArray, this.xp, n3);
        SplineFitter splineFitter2 = new SplineFitter(nArray, this.yp, n3);
        double d = (double)(n3 - 1) / (double)(this.splinePoints - 1);
        int n5 = 0;
        int n6 = 0;
        int n7 = Integer.MAX_VALUE;
        int n8 = -n7;
        int n9 = n7;
        int n10 = n8;
        int n11 = 0;
        while (n11 < this.splinePoints) {
            double d2 = (double)n11 * d;
            n5 = (int)Math.floor(splineFitter.evalSpline(nArray, this.xp, n3, d2) + 0.5);
            if (n5 < n7) {
                n7 = n5;
            }
            if (n5 > n8) {
                n8 = n5;
            }
            this.xSpline[n11] = n5;
            n6 = (int)Math.floor(splineFitter2.evalSpline(nArray, this.yp, n3, d2) + 0.5);
            if (n6 < n9) {
                n9 = n6;
            }
            if (n6 > n10) {
                n10 = n6;
            }
            this.ySpline[n11] = n6;
            ++n11;
        }
        if (n7 != 0) {
            int n12 = 0;
            while (n12 < this.nPoints) {
                int n13 = n12++;
                this.xp[n13] = this.xp[n13] - n7;
            }
            n2 = 0;
            while (n2 < this.splinePoints) {
                int n14 = n2++;
                this.xSpline[n14] = this.xSpline[n14] - n7;
            }
        }
        if (n9 != 0) {
            int n15 = 0;
            while (n15 < this.nPoints) {
                int n16 = n15++;
                this.yp[n16] = this.yp[n16] - n9;
            }
            n2 = 0;
            while (n2 < this.splinePoints) {
                int n17 = n2++;
                this.ySpline[n17] = this.ySpline[n17] - n9;
            }
        }
        this.x += n7;
        this.y += n9;
        this.width = n8 - n7;
        this.height = n10 - n9;
    }

    protected void handleMouseUp(int n, int n2) {
        if (this.state == 1) {
            this.state = 3;
            return;
        }
        if (this.state == 4) {
            this.imp.getProcessor().setMask(null);
            this.state = 3;
            this.updateClipRect();
            this.oldX = this.x;
            this.oldY = this.y;
            this.oldWidth = this.width;
            this.oldHeight = this.height;
            return;
        }
        if (this.state != 0) {
            return;
        }
        boolean bl = this.xp[this.nPoints - 1] == this.lastX && this.yp[this.nPoints - 1] == this.lastY;
        Rectangle rectangle = new Rectangle(this.ic.screenX(this.startX) - 5, this.ic.screenY(this.startY) - 5, 10, 10);
        if (this.nPoints > 2 && (rectangle.contains(n, n2) || this.ic.offScreenX(n) == this.startX && this.ic.offScreenY(n2) == this.startY || bl && System.currentTimeMillis() - this.mouseUpTime <= 500L)) {
            this.finishPolygon();
            return;
        }
        if (!bl) {
            this.xp[this.nPoints] = this.lastX;
            this.yp[this.nPoints] = this.lastY;
            ++this.nPoints;
            if (this.nPoints == this.xp.length) {
                this.enlargeArrays();
            }
            this.drawLineSegments();
            this.mouseUpTime = System.currentTimeMillis();
            if (this.type == 8 && this.nPoints == 3) {
                this.finishPolygon();
                return;
            }
        }
    }

    public boolean contains(int n, int n2) {
        if (!super.contains(n, n2)) {
            return false;
        }
        if (this.xScreenSpline != null) {
            Polygon polygon = new Polygon(this.xScreenSpline, this.yScreenSpline, this.splinePoints);
            return polygon.contains(this.ic.screenX(n), this.ic.screenY(n2));
        }
        Polygon polygon = new Polygon(this.xp2, this.yp2, this.nPoints);
        return polygon.contains(this.ic.screenX(n), this.ic.screenY(n2));
    }

    int isHandle(int n, int n2) {
        if (this.xSpline == null && this.type != 2 && this.type != 6 && this.type != 8 || this.clipboard != null) {
            return -1;
        }
        int n3 = 10;
        int n4 = n3 / 2;
        int n5 = -1;
        int n6 = 0;
        while (n6 < this.nPoints) {
            int n7 = this.xp2[n6] - n4;
            int n8 = this.yp2[n6] - n4;
            if (n >= n7 && n <= n7 + n3 && n2 >= n8 && n2 <= n8 + n3) {
                n5 = n6;
                break;
            }
            ++n6;
        }
        return n5;
    }

    public int[] getMask() {
        if (this.type == 6 || this.type == 7 || this.type == 8 || this.width == 0 || this.height == 0) {
            return null;
        }
        Image image = GUI.createBlankImage(this.width, this.height);
        Graphics graphics = image.getGraphics();
        graphics.setColor(Color.black);
        if (this.xSpline != null) {
            graphics.fillPolygon(this.xSpline, this.ySpline, this.splinePoints);
        } else {
            graphics.fillPolygon(this.xp, this.yp, this.nPoints);
        }
        ColorProcessor colorProcessor = new ColorProcessor(image);
        image.flush();
        image = null;
        graphics.dispose();
        return (int[])colorProcessor.getPixels();
    }

    double getSmoothedLineLength() {
        double d = 0.0;
        double d2 = 1.0;
        double d3 = 1.0;
        if (this.imp != null) {
            Calibration calibration = this.imp.getCalibration();
            d2 = calibration.pixelWidth * calibration.pixelWidth;
            d3 = calibration.pixelHeight * calibration.pixelHeight;
        }
        double d4 = this.xp[0];
        double d5 = this.xp[0];
        double d6 = this.xp[1];
        double d7 = this.yp[0];
        double d8 = this.yp[0];
        double d9 = this.yp[1];
        int n = 0;
        while (n < this.nPoints - 1) {
            double d10 = d4;
            d4 = d5;
            d5 = d6;
            double d11 = d7;
            d7 = d8;
            d8 = d9;
            if (n + 2 < this.nPoints) {
                d6 = this.xp[n + 2];
                d9 = this.yp[n + 2];
            }
            double d12 = (d6 - d10) / 3.0;
            double d13 = (d9 - d11) / 3.0;
            d += Math.sqrt(d12 * d12 * d2 + d13 * d13 * d3);
            ++n;
        }
        return d;
    }

    double getSmoothedPerimeter() {
        double d;
        double d2;
        double d3;
        double d4 = 0.0;
        double d5 = 1.0;
        double d6 = 1.0;
        if (this.imp != null) {
            Calibration calibration = this.imp.getCalibration();
            d5 = calibration.pixelWidth * calibration.pixelWidth;
            d6 = calibration.pixelHeight * calibration.pixelHeight;
        }
        double d7 = this.xp[this.nPoints - 1];
        double d8 = this.xp[0];
        double d9 = this.xp[1];
        double d10 = this.yp[this.nPoints - 1];
        double d11 = this.yp[0];
        double d12 = this.yp[1];
        int n = 0;
        while (n < this.nPoints - 1) {
            double d13 = d7;
            d7 = d8;
            d8 = d9;
            d3 = d10;
            d10 = d11;
            d11 = d12;
            if (n + 2 < this.nPoints) {
                d9 = this.xp[n + 2];
                d12 = this.yp[n + 2];
            } else {
                d9 = this.xp[0];
                d12 = this.yp[0];
            }
            d2 = (d9 - d13) / 3.0;
            d = (d12 - d3) / 3.0;
            d4 += Math.sqrt(d2 * d2 * d5 + d * d * d6);
            ++n;
        }
        double d14 = d7;
        d7 = d8;
        d8 = d9;
        d9 = this.xp[1];
        d3 = d10;
        d10 = d11;
        d11 = d12;
        d12 = this.yp[1];
        d2 = (d9 - d14) / 3.0;
        d = (d12 - d3) / 3.0;
        return d4 += Math.sqrt(d2 * d2 * d5 + d * d * d6);
    }

    double getTracedPerimeter() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.xp[0] - this.xp[this.nPoints - 1];
        int n5 = this.yp[0] - this.yp[this.nPoints - 1];
        int n6 = Math.abs(n4) + Math.abs(n5);
        boolean bl = false;
        int n7 = 0;
        while (n7 < this.nPoints) {
            int n8 = n7 + 1;
            if (n8 == this.nPoints) {
                n8 = 0;
            }
            int n9 = this.xp[n8] - this.xp[n7];
            int n10 = this.yp[n8] - this.yp[n7];
            n += Math.abs(n4);
            n2 += Math.abs(n5);
            int n11 = Math.abs(n9) + Math.abs(n10);
            if (n6 > 1 || !bl) {
                bl = true;
                ++n3;
            } else {
                bl = false;
            }
            n4 = n9;
            n5 = n10;
            n6 = n11;
            ++n7;
        }
        double d = 1.0;
        double d2 = 1.0;
        if (this.imp != null) {
            Calibration calibration = this.imp.getCalibration();
            d = calibration.pixelWidth;
            d2 = calibration.pixelHeight;
        }
        return (double)n * d + (double)n2 * d2 - (double)n3 * (d + d2 - Math.sqrt(d * d + d2 * d2));
    }

    public double getLength() {
        if (this.type == 4) {
            return this.getTracedPerimeter();
        }
        if (this.nPoints > 2) {
            if (this.type == 3) {
                return this.getSmoothedPerimeter();
            }
            if (this.type == 7 && this.width != 0 && this.height != 0) {
                return this.getSmoothedLineLength();
            }
        }
        double d = 0.0;
        Calibration calibration = this.imp.getCalibration();
        double d2 = calibration.pixelWidth * calibration.pixelWidth;
        double d3 = calibration.pixelHeight * calibration.pixelHeight;
        if (this.xSpline != null) {
            int n;
            int n2;
            int n3 = 0;
            while (n3 < this.splinePoints - 1) {
                n2 = this.xSpline[n3 + 1] - this.xSpline[n3];
                n = this.ySpline[n3 + 1] - this.ySpline[n3];
                d += Math.sqrt((double)(n2 * n2) * d2 + (double)(n * n) * d3);
                ++n3;
            }
            if (this.type == 2) {
                n2 = this.xSpline[0] - this.xSpline[this.splinePoints - 1];
                n = this.ySpline[0] - this.ySpline[this.splinePoints - 1];
                d += Math.sqrt((double)(n2 * n2) * d2 + (double)(n * n) * d3);
            }
        } else {
            int n;
            int n4;
            int n5 = 0;
            while (n5 < this.nPoints - 1) {
                n4 = this.xp[n5 + 1] - this.xp[n5];
                n = this.yp[n5 + 1] - this.yp[n5];
                d += Math.sqrt((double)(n4 * n4) * d2 + (double)(n * n) * d3);
                ++n5;
            }
            if (this.type == 2) {
                n4 = this.xp[0] - this.xp[this.nPoints - 1];
                n = this.yp[0] - this.yp[this.nPoints - 1];
                d += Math.sqrt((double)(n4 * n4) * d2 + (double)(n * n) * d3);
            }
        }
        return d;
    }

    public double getFeretsDiameter() {
        double d = 1.0;
        double d2 = 1.0;
        if (this.imp != null) {
            Calibration calibration = this.imp.getCalibration();
            d = calibration.pixelWidth * calibration.pixelWidth;
            d2 = calibration.pixelHeight * calibration.pixelHeight;
        }
        double d3 = 0.0;
        int n = 0;
        while (n < this.nPoints) {
            int n2 = n;
            while (n2 < this.nPoints) {
                double d4 = this.xp[n] - this.xp[n2];
                double d5 = this.yp[n] - this.yp[n2];
                double d6 = Math.sqrt(d4 * d4 * d + d5 * d5 * d2);
                if (d6 > d3) {
                    d3 = d6;
                }
                ++n2;
            }
            ++n;
        }
        return d3;
    }

    public double getAngle() {
        return this.degrees;
    }

    public int getNCoordinates() {
        if (this.xSpline != null) {
            return this.splinePoints;
        }
        return this.nPoints;
    }

    public int[] getXCoordinates() {
        if (this.xSpline != null) {
            return this.xSpline;
        }
        return this.xp;
    }

    public int[] getYCoordinates() {
        if (this.xSpline != null) {
            return this.ySpline;
        }
        return this.yp;
    }

    void enlargeArrays() {
        int[] nArray = new int[this.maxPoints * 2];
        int[] nArray2 = new int[this.maxPoints * 2];
        int[] nArray3 = new int[this.maxPoints * 2];
        int[] nArray4 = new int[this.maxPoints * 2];
        System.arraycopy(this.xp, 0, nArray, 0, this.maxPoints);
        System.arraycopy(this.yp, 0, nArray2, 0, this.maxPoints);
        System.arraycopy(this.xp2, 0, nArray3, 0, this.maxPoints);
        System.arraycopy(this.yp2, 0, nArray4, 0, this.maxPoints);
        this.xp = nArray;
        this.yp = nArray2;
        this.xp2 = nArray3;
        this.yp2 = nArray4;
        if (IJ.debugMode) {
            IJ.log("PolygonRoi: " + this.maxPoints + " points");
        }
        this.maxPoints *= 2;
    }
}

