/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.ImagePlus;
import ij.gui.GUI;
import ij.gui.Line;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;

public class OvalRoi
extends Roi {
    public OvalRoi(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.type = 1;
    }

    public OvalRoi(int n, int n2, ImagePlus imagePlus) {
        super(n, n2, imagePlus);
        this.type = 1;
    }

    public OvalRoi(int n, int n2, int n3, int n4, ImagePlus imagePlus) {
        this(n, n2, n3, n4);
        this.setImage(imagePlus);
    }

    protected void moveHandle(int n, int n2) {
        if (this.clipboard != null) {
            return;
        }
        int n3 = this.x;
        int n4 = this.y;
        int n5 = n3 + this.width;
        int n6 = this.y + this.height;
        int n7 = (int)(0.14645 * (double)this.width);
        int n8 = (int)(0.14645 * (double)this.height);
        switch (this.activeHandle) {
            case 0: {
                this.x = n - n7;
                this.y = n2 - n8;
                break;
            }
            case 1: {
                this.y = n2;
                break;
            }
            case 2: {
                n5 = n + n7;
                this.y = n2 - n8;
                break;
            }
            case 3: {
                n5 = n;
                break;
            }
            case 4: {
                n5 = n + n7;
                n6 = n2 + n8;
                break;
            }
            case 5: {
                n6 = n2;
                break;
            }
            case 6: {
                this.x = n - n7;
                n6 = n2 + n8;
                break;
            }
            case 7: {
                this.x = n;
            }
        }
        if (this.x < 0) {
            this.x = 0;
        }
        if (this.y < 0) {
            this.y = 0;
        }
        if (this.x < n5) {
            this.width = n5 - this.x;
        } else {
            this.width = 1;
            this.x = n5;
        }
        if (this.y < n6) {
            this.height = n6 - this.y;
        } else {
            this.height = 1;
            this.y = n6;
        }
        if (this.constrain) {
            this.height = this.width;
        }
        if (this.x + this.width > this.xMax) {
            this.width = this.xMax - this.x;
        }
        if (this.y + this.height > this.yMax) {
            this.height = this.yMax - this.y;
        }
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
    }

    public void draw(Graphics graphics) {
        if (this.ic == null) {
            return;
        }
        graphics.setColor(Roi.ROIColor);
        this.mag = this.ic != null ? this.ic.getMagnification() : 1.0;
        int n = (int)((double)this.width * this.mag);
        int n2 = (int)((double)this.height * this.mag);
        int n3 = (int)(0.14645 * (double)this.width * this.mag);
        int n4 = (int)(0.14645 * (double)this.height * this.mag);
        int n5 = this.ic.screenX(this.x);
        int n6 = this.ic.screenY(this.y);
        int n7 = n5 + n / 2;
        int n8 = n6 + n2 / 2;
        int n9 = n5 + n;
        int n10 = n6 + n2;
        graphics.drawOval(n5, n6, n, n2);
        if (this.state != 0 && this.clipboard == null) {
            int n11 = 2;
            this.drawHandle(graphics, n5 + n3 - n11, n6 + n4 - n11);
            this.drawHandle(graphics, n9 - n3 - n11, n6 + n4 - n11);
            this.drawHandle(graphics, n9 - n3 - n11, n10 - n4 - n11);
            this.drawHandle(graphics, n5 + n3 - n11, n10 - n4 - n11);
            this.drawHandle(graphics, n7 - n11, n6 - n11);
            this.drawHandle(graphics, n9 - n11, n8 - n11);
            this.drawHandle(graphics, n7 - n11, n10 - n11);
            this.drawHandle(graphics, n5 - n11, n8 - n11);
        }
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
        this.showStatus();
    }

    public void drawPixels() {
        double d;
        ImageProcessor imageProcessor = this.imp.getProcessor();
        int n = this.width / 2;
        int n2 = this.height / 2;
        double d2 = n * n;
        double d3 = n2 * n2;
        int n3 = this.x + n;
        int n4 = this.y + n2;
        imageProcessor.moveTo(this.x, this.y + n2);
        int n5 = -n + 1;
        while (n5 <= n) {
            d = Math.sqrt(d3 * (1.0 - (double)(n5 * n5) / d2));
            imageProcessor.lineTo(n3 + n5, n4 + (int)(d + 0.5));
            ++n5;
        }
        imageProcessor.moveTo(this.x, this.y + n2);
        int n6 = -n + 1;
        while (n6 <= n) {
            d = Math.sqrt(d3 * (1.0 - (double)(n6 * n6) / d2));
            imageProcessor.lineTo(n3 + n6, n4 - (int)(d + 0.5));
            ++n6;
        }
        if (Line.getWidth() > 1) {
            this.updateFullWindow = true;
        }
    }

    public boolean contains(int n, int n2) {
        double d;
        double d2;
        if (!super.contains(n, n2)) {
            return false;
        }
        return (double)((n = Math.abs(n - (this.x + this.width / 2))) * n) / ((d2 = (double)(this.width / 2)) * d2) + (double)((n2 = Math.abs(n2 - (this.y + this.height / 2))) * n2) / ((d = (double)(this.height / 2)) * d) <= 1.0;
    }

    int isHandle(int n, int n2) {
        if (this.clipboard != null) {
            return -1;
        }
        double d = this.ic.getMagnification();
        int n3 = 8;
        int n4 = n3 / 2;
        int n5 = this.ic.screenX(this.x) - n4;
        int n6 = this.ic.screenY(this.y) - n4;
        int n7 = this.ic.screenX(this.x + this.width) - n4;
        int n8 = this.ic.screenY(this.y + this.height) - n4;
        int n9 = n5 + (n7 - n5) / 2;
        int n10 = n6 + (n8 - n6) / 2;
        int n11 = (int)(0.14645 * (double)(n7 - n5));
        int n12 = (int)(0.14645 * (double)(n8 - n6));
        if (n >= n5 + n11 && n <= n5 + n11 + n3 && n2 >= n6 + n12 && n2 <= n6 + n12 + n3) {
            return 0;
        }
        if (n >= n9 && n <= n9 + n3 && n2 >= n6 && n2 <= n6 + n3) {
            return 1;
        }
        if (n >= n7 - n11 && n <= n7 - n11 + n3 && n2 >= n6 + n12 && n2 <= n6 + n12 + n3) {
            return 2;
        }
        if (n >= n7 && n <= n7 + n3 && n2 >= n10 && n2 <= n10 + n3) {
            return 3;
        }
        if (n >= n7 - n11 && n <= n7 - n11 + n3 && n2 >= n8 - n12 && n2 <= n8 - n12 + n3) {
            return 4;
        }
        if (n >= n9 && n <= n9 + n3 && n2 >= n8 && n2 <= n8 + n3) {
            return 5;
        }
        if (n >= n5 + n11 && n <= n5 + n11 + n3 && n2 >= n8 - n12 && n2 <= n8 - n12 + n3) {
            return 6;
        }
        if (n >= n5 && n <= n5 + n3 && n2 >= n10 && n2 <= n10 + n3) {
            return 7;
        }
        return -1;
    }

    public int[] getMask() {
        Image image = GUI.createBlankImage(this.width, this.height);
        Graphics graphics = image.getGraphics();
        graphics.setColor(Color.black);
        graphics.fillOval(0, 0, this.width, this.height);
        graphics.dispose();
        ColorProcessor colorProcessor = new ColorProcessor(image);
        return (int[])colorProcessor.getPixels();
    }

    public double getLength() {
        double d = 1.0;
        double d2 = 1.0;
        if (this.imp != null) {
            Calibration calibration = this.imp.getCalibration();
            d = calibration.pixelWidth;
            d2 = calibration.pixelHeight;
        }
        return Math.PI * ((double)this.width * d + (double)this.height * d2) / 2.0;
    }

    public double getFeretsDiameter() {
        double d = 1.0;
        double d2 = 1.0;
        if (this.imp != null) {
            Calibration calibration = this.imp.getCalibration();
            d = calibration.pixelWidth;
            d2 = calibration.pixelHeight;
        }
        return (double)this.width * d >= (double)this.height * d2 ? (double)this.width * d : (double)this.height * d2;
    }
}

