/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.process.ImageProcessor;
import java.awt.Cursor;
import java.awt.Graphics;

public class Line
extends Roi {
    public int x1;
    public int y1;
    public int x2;
    public int y2;
    private int x1R = 0;
    private int y1R = 0;
    private int x2R;
    private int y2R;
    private static int lineWidth = 1;

    public Line(int n, int n2, int n3, int n4) {
        this(n, n2, null);
        this.grow(n3, n4);
        this.x1 = this.x + this.x1R;
        this.y1 = this.y + this.y1R;
        this.x2 = this.x + this.x2R;
        this.y2 = this.y + this.y2R;
        this.state = 3;
    }

    public Line(int n, int n2, ImagePlus imagePlus) {
        super(n, n2, imagePlus);
        this.type = 5;
    }

    public Line(int n, int n2, int n3, int n4, ImagePlus imagePlus) {
        this(n, n2, n3, n4);
        this.setImage(imagePlus);
    }

    protected void grow(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n > this.xMax) {
            n = this.xMax;
        }
        if (n2 > this.yMax) {
            n2 = this.yMax;
        }
        int n3 = this.x + this.x1R;
        int n4 = this.y + this.y1R;
        if (this.constrain) {
            int n5;
            int n6 = Math.abs(n - n3);
            if (n6 >= (n5 = Math.abs(n2 - n4))) {
                n2 = n4;
            } else {
                n = n3;
            }
        }
        this.x = Math.min(this.x + this.x1R, n);
        this.y = Math.min(this.y + this.y1R, n2);
        this.x1R = n3 - this.x;
        this.y1R = n4 - this.y;
        this.x2R = n - this.x;
        this.y2R = n2 - this.y;
        this.width = Math.abs(this.x2R - this.x1R);
        this.height = Math.abs(this.y2R - this.y1R);
        if (this.width < 1) {
            this.width = 1;
        }
        if (this.height < 1) {
            this.height = 1;
        }
        this.updateClipRect();
        if (this.imp != null) {
            this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        }
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
    }

    protected void moveHandle(int n, int n2) {
        this.x1 = this.x + this.x1R;
        this.y1 = this.y + this.y1R;
        this.x2 = this.x + this.x2R;
        this.y2 = this.y + this.y2R;
        switch (this.activeHandle) {
            case 0: {
                this.x1 = n;
                this.y1 = n2;
                break;
            }
            case 1: {
                this.x2 = n;
                this.y2 = n2;
                break;
            }
            case 2: {
                int n3 = n - (this.x1 + (this.x2 - this.x1) / 2);
                int n4 = n2 - (this.y1 + (this.y2 - this.y1) / 2);
                this.x1 += n3;
                this.y1 += n4;
                this.x2 += n3;
                this.y2 += n4;
            }
        }
        if (this.constrain) {
            int n5 = Math.abs(this.x1 - this.x2);
            int n6 = Math.abs(this.y1 - this.y2);
            if (this.activeHandle == 0) {
                if (n5 >= n6) {
                    this.y1 = this.y2;
                } else {
                    this.x1 = this.x2;
                }
            } else if (this.activeHandle == 1) {
                if (n5 >= n6) {
                    this.y2 = this.y1;
                } else {
                    this.x2 = this.x1;
                }
            }
        }
        this.x = Math.min(this.x1, this.x2);
        this.y = Math.min(this.y1, this.y2);
        this.x1R = this.x1 - this.x;
        this.y1R = this.y1 - this.y;
        this.x2R = this.x2 - this.x;
        this.y2R = this.y2 - this.y;
        this.width = Math.abs(this.x2R - this.x1R);
        this.height = Math.abs(this.y2R - this.y1R);
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
    }

    protected void mouseDownInHandle(int n, int n2, int n3) {
        this.state = 4;
        this.activeHandle = n;
        this.ic.setCursor(new Cursor(1));
    }

    public void draw(Graphics graphics) {
        graphics.setColor(Roi.ROIColor);
        this.x1 = this.x + this.x1R;
        this.y1 = this.y + this.y1R;
        this.x2 = this.x + this.x2R;
        this.y2 = this.y + this.y2R;
        int n = this.ic.screenX(this.x1);
        int n2 = this.ic.screenY(this.y1);
        int n3 = this.ic.screenX(this.x2);
        int n4 = this.ic.screenY(this.y2);
        int n5 = n + (n3 - n) / 2;
        int n6 = n2 + (n4 - n2) / 2;
        graphics.drawLine(n, n2, n3, n4);
        if (this.state != 0) {
            int n7 = 2;
            if (this.ic != null) {
                this.mag = this.ic.getMagnification();
            }
            this.drawHandle(graphics, n - n7, n2 - n7);
            this.drawHandle(graphics, n3 - n7, n4 - n7);
            this.drawHandle(graphics, n5 - n7, n6 - n7);
        }
        IJ.showStatus(this.imp.getLocationAsString(this.x2, this.y2) + ", angle=" + IJ.d2s(this.getAngle(this.x1, this.y1, this.x2, this.y2)) + ", length=" + IJ.d2s(this.getLength()));
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
    }

    public double getLength() {
        Calibration calibration = this.imp.getCalibration();
        return Math.sqrt((double)(this.x2 - this.x1) * calibration.pixelWidth * (double)(this.x2 - this.x1) * calibration.pixelWidth + (double)(this.y2 - this.y1) * calibration.pixelHeight * (double)(this.y2 - this.y1) * calibration.pixelHeight);
    }

    public double getRawLength() {
        return Math.sqrt((this.x2 - this.x1) * (this.x2 - this.x1) + (this.y2 - this.y1) * (this.y2 - this.y1));
    }

    public double[] getPixels() {
        ImageProcessor imageProcessor = this.imp.getProcessor();
        double[] dArray = imageProcessor.getLine(this.x1, this.y1, this.x2, this.y2);
        return dArray;
    }

    public void drawPixels() {
        ImageProcessor imageProcessor = this.imp.getProcessor();
        imageProcessor.moveTo(this.x1, this.y1);
        imageProcessor.lineTo(this.x2, this.y2);
        if (Line.getWidth() > 1) {
            this.updateFullWindow = true;
        }
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    int isHandle(int n, int n2) {
        int n3 = 10;
        int n4 = n3 / 2;
        int n5 = this.ic.screenX(this.x + this.x1R) - n4;
        int n6 = this.ic.screenY(this.y + this.y1R) - n4;
        int n7 = this.ic.screenX(this.x + this.x2R) - n4;
        int n8 = this.ic.screenY(this.y + this.y2R) - n4;
        int n9 = n5 + (n7 - n5) / 2 - 1;
        int n10 = n6 + (n8 - n6) / 2 - 1;
        if (n >= n5 && n <= n5 + n3 && n2 >= n6 && n2 <= n6 + n3) {
            return 0;
        }
        if (n >= n7 && n <= n7 + n3 && n2 >= n8 && n2 <= n8 + n3) {
            return 1;
        }
        if (n >= n9 && n <= n9 + n3 + 2 && n2 >= n10 && n2 <= n10 + n3 + 2) {
            return 2;
        }
        return -1;
    }

    public static int getWidth() {
        return lineWidth;
    }

    public static void setWidth(int n) {
        if (n < 1) {
            n = 1;
        }
        if (n > 99) {
            n = 99;
        }
        lineWidth = n;
    }

    public void nudgeCorner(int n) {
        switch (n) {
            case 38: {
                --this.y2R;
                break;
            }
            case 40: {
                ++this.y2R;
                break;
            }
            case 37: {
                --this.x2R;
                break;
            }
            case 39: {
                ++this.x2R;
            }
        }
        this.grow(this.x + this.x2R, this.y + this.y2R);
    }
}

