/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Undo;
import ij.WindowManager;
import ij.gui.HistogramWindow;
import ij.gui.ImageWindow;
import ij.gui.NewImage;
import ij.io.FileSaver;
import ij.io.Opener;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import ij.text.TextWindow;
import ij.util.Tools;
import java.awt.Frame;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.Hashtable;

public class Executer
implements Runnable {
    private static String previousCommand;
    private String command;
    private ImagePlus iplus;
    private ImageJ ij;
    private Thread thread;

    public Executer(String string) {
        this.command = string;
        this.iplus = WindowManager.getCurrentImage();
        this.ij = IJ.getInstance();
    }

    public Executer(String string, ImagePlus imagePlus) {
        this.iplus = imagePlus;
        if (string.startsWith("Repeat")) {
            this.command = previousCommand;
        } else {
            this.command = string;
            if (!string.equals("Undo") && !string.equals("Close")) {
                previousCommand = string;
            }
        }
        this.ij = IJ.getInstance();
        this.thread = new Thread((Runnable)this, string);
        this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
        this.thread.start();
    }

    public void run() {
        block9: {
            if (this.command == null) {
                return;
            }
            ImagePlus imagePlus = this.iplus;
            this.iplus = null;
            try {
                if (Recorder.record) {
                    Recorder.setCommand(this.command);
                    this.runCommand(this.command, imagePlus);
                    Recorder.saveCommand();
                } else {
                    this.runCommand(this.command, imagePlus);
                }
            }
            catch (Throwable throwable) {
                IJ.showStatus("");
                IJ.showProgress(1.0);
                if (imagePlus != null) {
                    imagePlus.unlock();
                }
                String string = throwable.getMessage();
                if (throwable instanceof OutOfMemoryError) {
                    IJ.outOfMemory(this.command);
                }
                if (throwable instanceof RuntimeException && string != null && string.equals("Macro canceled")) break block9;
                CharArrayWriter charArrayWriter = new CharArrayWriter();
                PrintWriter printWriter = new PrintWriter(charArrayWriter);
                throwable.printStackTrace(printWriter);
                String string2 = charArrayWriter.toString();
                if (IJ.isMacintosh()) {
                    if (string2.indexOf("ThreadDeath") > 0) {
                        return;
                    }
                    string2 = Tools.fixNewLines(string2);
                }
                new TextWindow("Exception", string2, 350, 250);
            }
        }
    }

    public void runCommand(String string, ImagePlus imagePlus) {
        if (string.equals("New...")) {
            new NewImage();
        } else if (string.equals("Open...")) {
            new Opener().open();
        } else if (string.equals("Close")) {
            this.close(imagePlus);
        } else if (string.equals("Cut")) {
            this.copy(imagePlus, true);
        } else if (string.equals("Copy")) {
            this.copy(imagePlus, false);
        } else if (string.equals("ImageJ [enter]")) {
            this.ij.toFront();
        } else if (string.equals("Put Behind [tab]")) {
            WindowManager.putBehind();
        } else if (string.equals("Quit")) {
            IJ.getInstance().quit();
        } else {
            Hashtable hashtable = Menus.getCommands();
            String string2 = (String)hashtable.get(string);
            if (string2 != null) {
                this.runPlugIn(string, string2);
            } else {
                this.runImageCommand(string, imagePlus);
            }
        }
    }

    public void runImageCommand(String string, ImagePlus imagePlus) {
        ImageWindow imageWindow = null;
        if (imagePlus != null) {
            if (!imagePlus.lock()) {
                return;
            }
            imageWindow = imagePlus.getWindow();
        }
        if (string.equals("Revert")) {
            if (imageWindow != null) {
                imagePlus.revert();
            } else {
                IJ.noImage();
            }
        } else if (string.equals("Save")) {
            if (imageWindow != null) {
                new FileSaver(imagePlus).save();
            } else {
                IJ.noImage();
            }
        } else if (string.equals("Paste")) {
            if (imageWindow != null) {
                imageWindow.paste();
            } else {
                IJ.noImage();
            }
        } else if (string.equals("Histogram")) {
            if (imageWindow != null) {
                new HistogramWindow(imagePlus);
            } else {
                IJ.noImage();
            }
        } else if (string.equals("Undo")) {
            if (imageWindow != null) {
                Undo.undo();
            } else {
                IJ.noImage();
            }
        } else {
            IJ.error("Unrecognized command: " + string);
        }
        if (imagePlus != null) {
            imagePlus.unlock();
        }
    }

    void runPlugIn(String string, String string2) {
        int n;
        String string3 = "";
        if (string2.endsWith("\")") && (n = string2.lastIndexOf("(\"")) > 0) {
            string3 = string2.substring(n + 2, string2.length() - 2);
            string2 = string2.substring(0, n);
        }
        IJ.runPlugIn(string, string2, string3);
    }

    void roiRequired() {
        IJ.error("Selection required");
    }

    void copy(ImagePlus imagePlus, boolean bl) {
        if (imagePlus == null) {
            IJ.noImage();
            return;
        }
        imagePlus.getWindow().copy(bl);
    }

    void close(ImagePlus imagePlus) {
        Frame frame = WindowManager.getFrontWindow();
        if (frame != null && frame instanceof PlugInFrame) {
            ((PlugInFrame)frame).close();
        } else if (frame != null && frame instanceof TextWindow) {
            ((TextWindow)frame).close();
        } else if (imagePlus == null) {
            IJ.noImage();
        } else {
            ImageWindow imageWindow = imagePlus.getWindow();
            if (imageWindow != null) {
                imageWindow.close();
            } else if (IJ.macroRunning()) {
                WindowManager.setTempCurrentImage(null);
            }
        }
    }

    public static String getCommand() {
        return previousCommand;
    }
}

