/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Scrollbar;

class ImgPanel
extends Panel {
    Container applet;
    ImgPanel DataPanel = null;
    My3DData data3d;
    ImageCanvas c1;
    ImageCanvas c2;
    ImageCanvas c3;
    PositionLabel label;
    boolean ROIstarted = false;
    APoint DraggedMarker = null;
    APoint SavedMarker = null;
    MenuBar MyMenu;

    public void InitScaling() {
        this.c2.InitScaling();
        this.c3.InitScaling();
        this.c1.InitScaling();
        this.c3.CalcPrev();
        this.c3.UpdateAllNoCoord();
    }

    public void OwnerPanel(ImgPanel imgPanel) {
        this.DataPanel = imgPanel;
    }

    public void CheckScrollBar() {
        if (this.data3d.Times > 1) {
            Scrollbar scrollbar = new Scrollbar(1, 0, 1, 0, this.data3d.Times);
            scrollbar.setBlockIncrement(this.data3d.Times / 10 + 1);
            scrollbar.addAdjustmentListener(this.c1);
            this.label.TimeScrollbar = scrollbar;
            this.add("East", scrollbar);
            this.data3d.ShowAllTimes = false;
            this.data3d.ShowAllSlices = true;
            this.data3d.TrackDirection = 4;
            if (this.data3d.SizeZ > 1) {
                this.data3d.SearchZ = 1;
                this.data3d.COMZ = 1;
            }
        }
    }

    public void setPositions(APoint aPoint) {
        if (aPoint != null) {
            APoint aPoint2 = this.data3d.LimitPoint(aPoint);
            this.c1.PositionValue = (int)(aPoint2.coord[2] + 0.5);
            this.c2.PositionValue = (int)(aPoint2.coord[0] + 0.5);
            this.c3.PositionValue = (int)(aPoint2.coord[1] + 0.5);
            this.data3d.setTime((int)(aPoint2.coord[4] + 0.5));
            this.data3d.setElement((int)(aPoint2.coord[3] + 0.5));
        }
    }

    void AddPopupMenu(Menu menu, boolean bl) {
        if (bl) {
            this.c1.MyPopupMenu.add(menu);
        } else {
            this.MyMenu.add(menu);
        }
    }

    public ImgPanel(Container container, My3DData my3DData) {
        this.applet = container;
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(2, 2));
        this.add("Center", panel);
        this.data3d = my3DData;
        try {
            this.c1 = new ImageCanvas(this.applet, this, this.data3d, 2, "XY");
            this.c1.AspectLocked.setState(true);
            this.c2 = new ImageCanvas(this.applet, this, this.data3d, 0, "ZY");
            this.c3 = new ImageCanvas(this.applet, this, this.data3d, 1, "XZ");
        }
        catch (Exception exception) {
            this.applet.add("South", new Label("Caught Exception:" + exception.getMessage()));
            this.applet.setVisible(true);
            exception.printStackTrace();
        }
        this.c2.TakeOtherCanvas1(this.c1);
        this.c2.TakeOtherCanvas2(this.c3);
        this.c3.TakeOtherCanvas1(this.c2);
        this.c3.TakeOtherCanvas2(this.c1);
        this.c1.TakeOtherCanvas1(this.c2);
        this.c1.TakeOtherCanvas2(this.c3);
        panel.add(this.c1);
        panel.add(this.c2);
        panel.add(this.c3);
        MenuBar menuBar = this.MyMenu = new MenuBar();
        boolean bl = this.applet instanceof View5D;
        if (this.applet instanceof View5D_ && IJ.isMacintosh()) {
            bl = true;
        }
        Menu menu = new Menu("General", false);
        this.AddPopupMenu(menu, bl);
        MenuItem menuItem = new MenuItem("Help [?]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, '?'));
        menu.add(menuItem);
        menuItem = new MenuItem("Exit [$]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, '$'));
        menu.add(menuItem);
        menuItem = new MenuItem("Readmode (Complex only) [^]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, '^'));
        menu.add(menuItem);
        menu = new Menu("Import/Export", false);
        this.AddPopupMenu(menu, bl);
        menuItem = new MenuItem("Reload data [l]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'l'));
        menu.add(menuItem);
        menuItem = new MenuItem("Reload markers [L]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'L'));
        menu.add(menuItem);
        menuItem = new MenuItem("Export this element [X] (only in ImageJ)");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'X'));
        menu.add(menuItem);
        menuItem = new MenuItem("Spawn Viewer [s]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 's'));
        menu.add(menuItem);
        menu = new Menu("Measuring & Markers", false);
        this.AddPopupMenu(menu, bl);
        menuItem = new MenuItem("Set Axes Units and Scalings [N]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'N'));
        menu.add(menuItem);
        menuItem = new MenuItem("set marker [m]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'm'));
        menu.add(menuItem);
        menuItem = new MenuItem("delete active marker [M]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'M'));
        menu.add(menuItem);
        menuItem = new MenuItem("delete trailing markers [Q]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'Q'));
        menu.add(menuItem);
        menuItem = new MenuItem("tag/untag marker [&]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, '&'));
        menu.add(menuItem);
        menuItem = new MenuItem("new marker list [k]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'k'));
        menu.add(menuItem);
        menuItem = new MenuItem("delete marker list [K]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'K'));
        menu.add(menuItem);
        menuItem = new MenuItem("activate next marker [0]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, '0'));
        menu.add(menuItem);
        menuItem = new MenuItem("activate previous marker [9]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, '9'));
        menu.add(menuItem);
        menuItem = new MenuItem("activate next marker list [j]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'j'));
        menu.add(menuItem);
        menuItem = new MenuItem("activate previous marker list [J]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'J'));
        menu.add(menuItem);
        menuItem = new MenuItem("toggles the marker color of current list [w]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'w'));
        menu.add(menuItem);
        menuItem = new MenuItem("auto-track marker [W]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'W'));
        menu.add(menuItem);
        menuItem = new MenuItem("subtract track from data [#]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, '#'));
        menu.add(menuItem);
        menuItem = new MenuItem("Show detailed marker menu [n]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'n'));
        menu.add(menuItem);
        menuItem = new MenuItem("Reload markers [L]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'L'));
        menu.add(menuItem);
        menu = new Menu("Color", false);
        this.AddPopupMenu(menu, bl);
        menuItem = new MenuItem("Toggle multicolor overlay [C]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'C'));
        menu.add(menuItem);
        menuItem = new MenuItem("Next color map for element [c]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'c'));
        menu.add(menuItem);
        menuItem = new MenuItem("Next inverse color map [d]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'd'));
        menu.add(menuItem);
        menuItem = new MenuItem("Toggle over/underflow [o]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'o'));
        menu.add(menuItem);
        menuItem = new MenuItem("Toggle logarithmic scale [O]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'O'));
        menu.add(menuItem);
        menuItem = new MenuItem("Adjust threshold element [t]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 't'));
        menu.add(menuItem);
        menuItem = new MenuItem("Adjust all thresholds [T]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'T'));
        menu.add(menuItem);
        menuItem = new MenuItem("Coarse raise lower display threshold [1]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, '1'));
        menu.add(menuItem);
        menuItem = new MenuItem("Coarse decrease lower display threshold [2]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, '2'));
        menu.add(menuItem);
        menuItem = new MenuItem("Coarse raise upper display threshold [3]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, '3'));
        menu.add(menuItem);
        menuItem = new MenuItem("Coarse decrease upper display threshold [4], use 5-8 for fine tuning");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, '4'));
        menu.add(menuItem);
        menuItem = new MenuItem("Transfer display thresholds to data thresholds [!]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, '!'));
        menu.add(menuItem);
        menuItem = new MenuItem("Advance element [e]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'e'));
        menu.add(menuItem);
        menuItem = new MenuItem("Devance element [E]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'E'));
        menu.add(menuItem);
        menuItem = new MenuItem("Define underflow gate [u]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'u'));
        menu.add(menuItem);
        menuItem = new MenuItem("Toggle defined underflow gate [U]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'U'));
        menu.add(menuItem);
        menuItem = new MenuItem("Red glow colormap [R]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'R'));
        menu.add(menuItem);
        menuItem = new MenuItem("Gray colormap [G]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'G'));
        menu.add(menuItem);
        menuItem = new MenuItem("Rainbow colormap [B]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'B'));
        menu.add(menuItem);
        menuItem = new MenuItem("Red colomap [r]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'r'));
        menu.add(menuItem);
        menuItem = new MenuItem("Green colormap [g]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'g'));
        menu.add(menuItem);
        menuItem = new MenuItem("Blue colormap [b]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'b'));
        menu.add(menuItem);
        menuItem = new MenuItem("Show in overlay [v]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'v'));
        menu.add(menuItem);
        menuItem = new MenuItem("Show in multiplicative Overlay [V]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'V'));
        menu.add(menuItem);
        menu = new Menu("ROIs", false);
        this.AddPopupMenu(menu, bl);
        menuItem = new MenuItem("Toggle rectangular ROIs [S]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'S'));
        menu.add(menuItem);
        menuItem = new MenuItem("Extract with ROI [Y]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'Y'));
        menu.add(menuItem);
        menu = new Menu("Processing", false);
        this.AddPopupMenu(menu, bl);
        menuItem = new MenuItem("Clone element with upcast to float [f]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'f'));
        menu.add(menuItem);
        menuItem = new MenuItem("Clone displayed element as short [F]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'f'));
        menu.add(menuItem);
        menuItem = new MenuItem("Mathematically add gate element [+]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, '+'));
        menu.add(menuItem);
        menuItem = new MenuItem("Mathematically subtract from gate element [-]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, '-'));
        menu.add(menuItem);
        menuItem = new MenuItem("Mathematically multiply with gate element [*]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, '*'));
        menu.add(menuItem);
        menuItem = new MenuItem("Ratio with gate element [/]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, '/'));
        menu.add(menuItem);
        menuItem = new MenuItem("Define this element offset from ROI mean [_]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, '_'));
        menu.add(menuItem);
        menuItem = new MenuItem("Delete active element [D]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'D'));
        menu.add(menuItem);
        menu = new Menu("Histograms", false);
        this.AddPopupMenu(menu, bl);
        menuItem = new MenuItem("Select for histogram X-axis [x]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'x'));
        menu.add(menuItem);
        menuItem = new MenuItem("Select for histogram Y-axis [y]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'y'));
        menu.add(menuItem);
        menuItem = new MenuItem("Select for histogram Z-axis [z]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'z'));
        menu.add(menuItem);
        menuItem = new MenuItem("Histogram (<= 3 dimensional) / apply histogram ROI to data [h]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'h'));
        menu.add(menuItem);
        menuItem = new MenuItem("Force new histogram window [H]");
        menuItem.addActionListener(new MyMenuProcessor(this.c1, 'H'));
        menu.add(menuItem);
        this.label = new PositionLabel("View5D initialization.", this.c1, this.c2, this.c3, this.data3d);
        panel.add(this.label);
        this.c1.ConnectLabel(this.label);
        this.c2.ConnectLabel(this.label);
        this.c3.ConnectLabel(this.label);
        this.setBounds(0, 0, 20, 20);
        this.c1.UpdateAllNoCoord();
    }
}

