/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.ForbiddenConversionException;
import ucar.ma2.Index;
import ucar.ma2.Index0D;
import ucar.ma2.Index1D;
import ucar.ma2.Index2D;
import ucar.ma2.Index3D;
import ucar.ma2.Index4D;
import ucar.ma2.Index5D;
import ucar.ma2.Index6D;
import ucar.ma2.Index7D;
import ucar.ma2.IndexIterator;

public class ArrayString
extends Array {
    protected String[] storage;

    static ArrayString factory(Index index) {
        return ArrayString.factory(index, null);
    }

    static ArrayString factory(Index index, String[] storage) {
        if (index instanceof Index0D) {
            return new D0(index, storage);
        }
        if (index instanceof Index1D) {
            return new D1(index, storage);
        }
        if (index instanceof Index2D) {
            return new D2(index, storage);
        }
        if (index instanceof Index3D) {
            return new D3(index, storage);
        }
        if (index instanceof Index4D) {
            return new D4(index, storage);
        }
        if (index instanceof Index5D) {
            return new D5(index, storage);
        }
        if (index instanceof Index6D) {
            return new D6(index, storage);
        }
        if (index instanceof Index7D) {
            return new D7(index, storage);
        }
        return new ArrayString(index, storage);
    }

    public ArrayString(int[] dimensions) {
        super(DataType.STRING, dimensions);
        this.storage = new String[(int)this.indexCalc.getSize()];
    }

    ArrayString(Index ima, String[] data) {
        super(DataType.STRING, ima);
        this.storage = data != null ? data : new String[(int)ima.getSize()];
    }

    @Override
    protected Array createView(Index index) {
        return ArrayString.factory(index, this.storage);
    }

    @Override
    public Object getStorage() {
        return this.storage;
    }

    @Override
    protected void copyFrom1DJavaArray(IndexIterator iter, Object javaArray) {
        String[] ja;
        for (String aJa : ja = (String[])javaArray) {
            iter.setObjectNext(aJa);
        }
    }

    @Override
    protected void copyTo1DJavaArray(IndexIterator iter, Object javaArray) {
        String[] ja = (String[])javaArray;
        for (int i = 0; i < ja.length; ++i) {
            ja[i] = (String)iter.getObjectNext();
        }
    }

    @Override
    public ByteBuffer getDataAsByteBuffer() {
        int totalsize = 0;
        for (String aStorage : this.storage) {
            totalsize += aStorage.length() + 1;
        }
        ByteBuffer bb = ByteBuffer.allocate(2 * totalsize);
        CharBuffer cb = bb.asCharBuffer();
        for (String s2 : this.storage) {
            cb.append(s2);
            cb.append('\u0000');
        }
        return bb;
    }

    @Override
    public Class getElementType() {
        return String.class;
    }

    public String get(Index i) {
        return this.storage[i.currentElement()];
    }

    public void set(Index i, String value) {
        this.storage[i.currentElement()] = value;
    }

    @Override
    public double getDouble(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setDouble(Index i, double value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public float getFloat(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setFloat(Index i, float value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public long getLong(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setLong(Index i, long value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public int getInt(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setInt(Index i, int value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public short getShort(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setShort(Index i, short value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public byte getByte(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setByte(Index i, byte value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public boolean getBoolean(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setBoolean(Index i, boolean value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public char getChar(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setChar(Index i, char value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public Object getObject(Index i) {
        return this.storage[i.currentElement()];
    }

    @Override
    public void setObject(Index i, Object value) {
        this.storage[i.currentElement()] = (String)value;
    }

    @Override
    public double getDouble(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setDouble(int index, double value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public float getFloat(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setFloat(int index, float value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public long getLong(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setLong(int index, long value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public int getInt(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setInt(int index, int value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public short getShort(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setShort(int index, short value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public byte getByte(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setByte(int index, byte value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public char getChar(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setChar(int index, char value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public boolean getBoolean(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setBoolean(int index, boolean value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public Object getObject(int index) {
        return this.storage[index];
    }

    @Override
    public void setObject(int index, Object value) {
        this.storage[index] = (String)value;
    }

    public static class D7
    extends ArrayString {
        private Index7D ix;

        public D7(int len0, int len1, int len2, int len3, int len4, int len5, int len6) {
            super(new int[]{len0, len1, len2, len3, len4, len5, len6});
            this.ix = (Index7D)this.indexCalc;
        }

        private D7(Index i, String[] store) {
            super(i, store);
            this.ix = (Index7D)this.indexCalc;
        }

        public String get(int i, int j, int k, int l, int m4, int n, int o) {
            return this.storage[this.ix.setDirect(i, j, k, l, m4, n, o)];
        }

        public void set(int i, int j, int k, int l, int m4, int n, int o, String value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k, (int)l, (int)m4, (int)n, (int)o)] = value;
        }
    }

    public static class D6
    extends ArrayString {
        private Index6D ix;

        public D6(int len0, int len1, int len2, int len3, int len4, int len5) {
            super(new int[]{len0, len1, len2, len3, len4, len5});
            this.ix = (Index6D)this.indexCalc;
        }

        private D6(Index i, String[] store) {
            super(i, store);
            this.ix = (Index6D)this.indexCalc;
        }

        public String get(int i, int j, int k, int l, int m4, int n) {
            return this.storage[this.ix.setDirect(i, j, k, l, m4, n)];
        }

        public void set(int i, int j, int k, int l, int m4, int n, String value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k, (int)l, (int)m4, (int)n)] = value;
        }
    }

    public static class D5
    extends ArrayString {
        private Index5D ix;

        public D5(int len0, int len1, int len2, int len3, int len4) {
            super(new int[]{len0, len1, len2, len3, len4});
            this.ix = (Index5D)this.indexCalc;
        }

        private D5(Index i, String[] store) {
            super(i, store);
            this.ix = (Index5D)this.indexCalc;
        }

        public String get(int i, int j, int k, int l, int m4) {
            return this.storage[this.ix.setDirect(i, j, k, l, m4)];
        }

        public void set(int i, int j, int k, int l, int m4, String value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k, (int)l, (int)m4)] = value;
        }
    }

    public static class D4
    extends ArrayString {
        private Index4D ix;

        public D4(int len0, int len1, int len2, int len3) {
            super(new int[]{len0, len1, len2, len3});
            this.ix = (Index4D)this.indexCalc;
        }

        private D4(Index i, String[] store) {
            super(i, store);
            this.ix = (Index4D)this.indexCalc;
        }

        public String get(int i, int j, int k, int l) {
            return this.storage[this.ix.setDirect(i, j, k, l)];
        }

        public void set(int i, int j, int k, int l, String value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k, (int)l)] = value;
        }
    }

    public static class D3
    extends ArrayString {
        private Index3D ix;

        public D3(int len0, int len1, int len2) {
            super(new int[]{len0, len1, len2});
            this.ix = (Index3D)this.indexCalc;
        }

        private D3(Index i, String[] store) {
            super(i, store);
            this.ix = (Index3D)this.indexCalc;
        }

        public String get(int i, int j, int k) {
            return this.storage[this.ix.setDirect(i, j, k)];
        }

        public void set(int i, int j, int k, String value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k)] = value;
        }
    }

    public static class D2
    extends ArrayString {
        private Index2D ix;

        public D2(int len0, int len1) {
            super(new int[]{len0, len1});
            this.ix = (Index2D)this.indexCalc;
        }

        private D2(Index i, String[] store) {
            super(i, store);
            this.ix = (Index2D)this.indexCalc;
        }

        public String get(int i, int j) {
            return this.storage[this.ix.setDirect(i, j)];
        }

        public void set(int i, int j, String value) {
            this.storage[this.ix.setDirect((int)i, (int)j)] = value;
        }
    }

    public static class D1
    extends ArrayString {
        private Index1D ix;

        public D1(int len0) {
            super(new int[]{len0});
            this.ix = (Index1D)this.indexCalc;
        }

        private D1(Index i, String[] store) {
            super(i, store);
            this.ix = (Index1D)this.indexCalc;
        }

        public String get(int i) {
            return this.storage[this.ix.setDirect(i)];
        }

        public void set(int i, String value) {
            this.storage[this.ix.setDirect((int)i)] = value;
        }
    }

    public static class D0
    extends ArrayString {
        private Index0D ix;

        public D0() {
            super(new int[0]);
            this.ix = (Index0D)this.indexCalc;
        }

        private D0(Index i, String[] store) {
            super(i, store);
            this.ix = (Index0D)this.indexCalc;
        }

        public String get() {
            return this.storage[this.ix.currentElement()];
        }

        public void set(String value) {
            this.storage[this.ix.currentElement()] = value;
        }
    }
}

