/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.List;
import ome.units.quantity.Frequency;
import ome.units.quantity.Length;
import ome.xml.model.LightSource;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Pump;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.LaserMedium;
import ome.xml.model.enums.LaserType;
import ome.xml.model.enums.Pulse;
import ome.xml.model.enums.UnitsFrequency;
import ome.xml.model.enums.UnitsLength;
import ome.xml.model.enums.handlers.UnitsFrequencyEnumHandler;
import ome.xml.model.enums.handlers.UnitsLengthEnumHandler;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Laser
extends LightSource {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Laser.class);
    private LaserType type;
    private LaserMedium laserMedium;
    private Length wavelength;
    private PositiveInteger frequencyMultiplication;
    private Boolean tuneable;
    private Pulse pulse;
    private Boolean pockelCell;
    private Frequency repetitionRate;
    private LightSource pump;

    public Laser() {
    }

    public Laser(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public Laser(Laser orig) {
        super(orig);
        this.type = orig.type;
        this.laserMedium = orig.laserMedium;
        this.wavelength = orig.wavelength;
        this.frequencyMultiplication = orig.frequencyMultiplication;
        this.tuneable = orig.tuneable;
        this.pulse = orig.pulse;
        this.pockelCell = orig.pockelCell;
        this.repetitionRate = orig.repetitionRate;
        this.pump = orig.pump;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        Object baseValue;
        Enum modelUnit;
        String unitSymbol;
        super.update(element, model);
        if (element.hasAttribute("Type")) {
            this.setType(LaserType.fromString(element.getAttribute("Type")));
        }
        if (element.hasAttribute("LaserMedium")) {
            this.setLaserMedium(LaserMedium.fromString(element.getAttribute("LaserMedium")));
        }
        if (element.hasAttribute("Wavelength")) {
            unitSymbol = element.getAttribute("WavelengthUnit");
            if (unitSymbol == null || unitSymbol.isEmpty()) {
                unitSymbol = Laser.getWavelengthUnitXsdDefault();
            }
            modelUnit = UnitsLength.fromString(unitSymbol);
            baseValue = PositiveFloat.valueOf(element.getAttribute("Wavelength"));
            this.setWavelength(UnitsLengthEnumHandler.getQuantity(baseValue, modelUnit));
        }
        if (element.hasAttribute("FrequencyMultiplication")) {
            this.setFrequencyMultiplication(PositiveInteger.valueOf(element.getAttribute("FrequencyMultiplication")));
        }
        if (element.hasAttribute("Tuneable")) {
            this.setTuneable(Boolean.valueOf(element.getAttribute("Tuneable")));
        }
        if (element.hasAttribute("Pulse")) {
            this.setPulse(Pulse.fromString(element.getAttribute("Pulse")));
        }
        if (element.hasAttribute("PockelCell")) {
            this.setPockelCell(Boolean.valueOf(element.getAttribute("PockelCell")));
        }
        if (element.hasAttribute("RepetitionRate")) {
            unitSymbol = element.getAttribute("RepetitionRateUnit");
            if (unitSymbol == null || unitSymbol.isEmpty()) {
                unitSymbol = Laser.getRepetitionRateUnitXsdDefault();
            }
            modelUnit = UnitsFrequency.fromString(unitSymbol);
            baseValue = Double.valueOf(element.getAttribute("RepetitionRate"));
            this.setRepetitionRate(UnitsFrequencyEnumHandler.getQuantity(baseValue, (UnitsFrequency)modelUnit));
        }
        List<Element> Pump_nodeList = Laser.getChildrenByTagName(element, "Pump");
        for (Element Pump_element : Pump_nodeList) {
            Pump pump_reference = new Pump();
            pump_reference.setID(Pump_element.getAttribute("ID"));
            model.addReference(this, pump_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        if (reference instanceof Pump) {
            this.pump = (LightSource)o;
            return true;
        }
        return super.link(reference, o);
    }

    public LaserType getType() {
        return this.type;
    }

    public void setType(LaserType type) {
        this.type = type;
    }

    public LaserMedium getLaserMedium() {
        return this.laserMedium;
    }

    public void setLaserMedium(LaserMedium laserMedium) {
        this.laserMedium = laserMedium;
    }

    public Length getWavelength() {
        return this.wavelength;
    }

    public void setWavelength(Length wavelength) {
        this.wavelength = wavelength;
    }

    public static String getWavelengthUnitXsdDefault() {
        return "nm";
    }

    public PositiveInteger getFrequencyMultiplication() {
        return this.frequencyMultiplication;
    }

    public void setFrequencyMultiplication(PositiveInteger frequencyMultiplication) {
        this.frequencyMultiplication = frequencyMultiplication;
    }

    public Boolean getTuneable() {
        return this.tuneable;
    }

    public void setTuneable(Boolean tuneable) {
        this.tuneable = tuneable;
    }

    public Pulse getPulse() {
        return this.pulse;
    }

    public void setPulse(Pulse pulse) {
        this.pulse = pulse;
    }

    public Boolean getPockelCell() {
        return this.pockelCell;
    }

    public void setPockelCell(Boolean pockelCell) {
        this.pockelCell = pockelCell;
    }

    public Frequency getRepetitionRate() {
        return this.repetitionRate;
    }

    public void setRepetitionRate(Frequency repetitionRate) {
        this.repetitionRate = repetitionRate;
    }

    public static String getRepetitionRateUnitXsdDefault() {
        return "Hz";
    }

    public LightSource getLinkedPump() {
        return this.pump;
    }

    public void linkPump(LightSource o) {
        this.pump = o;
    }

    public void unlinkPump(LightSource o) {
        if (this.pump == o) {
            this.pump = null;
        }
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element Laser_element) {
        Enum enumUnits;
        if (Laser_element == null) {
            Laser_element = document.createElementNS(NAMESPACE, "Laser");
        }
        super.asXMLElement(document, Laser_element);
        if (this.type != null) {
            Laser_element.setAttribute("Type", this.type.toString());
        }
        if (this.laserMedium != null) {
            Laser_element.setAttribute("LaserMedium", this.laserMedium.toString());
        }
        if (this.wavelength != null) {
            if (this.wavelength.value() != null) {
                Laser_element.setAttribute("Wavelength", this.wavelength.value().toString());
            }
            if (this.wavelength.unit() != null) {
                try {
                    enumUnits = UnitsLength.fromString(this.wavelength.unit().getSymbol());
                    Laser_element.setAttribute("WavelengthUnit", ((UnitsLength)enumUnits).toString());
                }
                catch (EnumerationException e) {
                    LOGGER.debug("Unable to create xml for Laser:WavelengthUnit: {}", (Object)e.toString());
                }
            }
        }
        if (this.frequencyMultiplication != null) {
            Laser_element.setAttribute("FrequencyMultiplication", this.frequencyMultiplication.toString());
        }
        if (this.tuneable != null) {
            Laser_element.setAttribute("Tuneable", this.tuneable.toString());
        }
        if (this.pulse != null) {
            Laser_element.setAttribute("Pulse", this.pulse.toString());
        }
        if (this.pockelCell != null) {
            Laser_element.setAttribute("PockelCell", this.pockelCell.toString());
        }
        if (this.repetitionRate != null) {
            if (this.repetitionRate.value() != null) {
                Laser_element.setAttribute("RepetitionRate", this.repetitionRate.value().toString());
            }
            if (this.repetitionRate.unit() != null) {
                try {
                    enumUnits = UnitsFrequency.fromString(this.repetitionRate.unit().getSymbol());
                    Laser_element.setAttribute("RepetitionRateUnit", ((UnitsFrequency)enumUnits).toString());
                }
                catch (EnumerationException e) {
                    LOGGER.debug("Unable to create xml for Laser:RepetitionRateUnit: {}", (Object)e.toString());
                }
            }
        }
        if (this.pump != null) {
            Pump o = new Pump();
            o.setID(this.pump.getID());
            Element child = document.createElementNS(NAMESPACE, "Pump");
            o.asXMLElement(document, child);
            Laser_element.appendChild(child);
        }
        return Laser_element;
    }
}

