/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.units.quantity.ElectricPotential;
import ome.units.quantity.Frequency;
import ome.xml.model.Detector;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.Settings;
import ome.xml.model.enums.Binning;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.UnitsElectricPotential;
import ome.xml.model.enums.UnitsFrequency;
import ome.xml.model.enums.handlers.UnitsElectricPotentialEnumHandler;
import ome.xml.model.enums.handlers.UnitsFrequencyEnumHandler;
import ome.xml.model.primitives.PositiveInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DetectorSettings
extends Settings {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(DetectorSettings.class);
    private String id;
    private Double offset;
    private Double gain;
    private ElectricPotential voltage;
    private Double zoom;
    private Frequency readOutRate;
    private Binning binning;
    private PositiveInteger integration;
    private Detector detector;

    public DetectorSettings() {
    }

    public DetectorSettings(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public DetectorSettings(DetectorSettings orig) {
        super(orig);
        this.id = orig.id;
        this.offset = orig.offset;
        this.gain = orig.gain;
        this.voltage = orig.voltage;
        this.zoom = orig.zoom;
        this.readOutRate = orig.readOutRate;
        this.binning = orig.binning;
        this.integration = orig.integration;
        this.detector = orig.detector;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        Double baseValue;
        Enum modelUnit;
        String unitSymbol;
        super.update(element, model);
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException("DetectorSettings missing required ID property.");
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if (element.hasAttribute("Offset")) {
            this.setOffset(Double.valueOf(element.getAttribute("Offset")));
        }
        if (element.hasAttribute("Gain")) {
            this.setGain(Double.valueOf(element.getAttribute("Gain")));
        }
        if (element.hasAttribute("Voltage")) {
            unitSymbol = element.getAttribute("VoltageUnit");
            if (unitSymbol == null || unitSymbol.isEmpty()) {
                unitSymbol = DetectorSettings.getVoltageUnitXsdDefault();
            }
            modelUnit = UnitsElectricPotential.fromString(unitSymbol);
            baseValue = Double.valueOf(element.getAttribute("Voltage"));
            this.setVoltage(UnitsElectricPotentialEnumHandler.getQuantity(baseValue, modelUnit));
        }
        if (element.hasAttribute("Zoom")) {
            this.setZoom(Double.valueOf(element.getAttribute("Zoom")));
        }
        if (element.hasAttribute("ReadOutRate")) {
            unitSymbol = element.getAttribute("ReadOutRateUnit");
            if (unitSymbol == null || unitSymbol.isEmpty()) {
                unitSymbol = DetectorSettings.getReadOutRateUnitXsdDefault();
            }
            modelUnit = UnitsFrequency.fromString(unitSymbol);
            baseValue = Double.valueOf(element.getAttribute("ReadOutRate"));
            this.setReadOutRate(UnitsFrequencyEnumHandler.getQuantity(baseValue, (UnitsFrequency)modelUnit));
        }
        if (element.hasAttribute("Binning")) {
            this.setBinning(Binning.fromString(element.getAttribute("Binning")));
        }
        if (element.hasAttribute("Integration")) {
            this.setIntegration(PositiveInteger.valueOf(element.getAttribute("Integration")));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        return super.link(reference, o);
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public void setID(String id) {
        this.id = id;
    }

    public Double getOffset() {
        return this.offset;
    }

    public void setOffset(Double offset) {
        this.offset = offset;
    }

    public Double getGain() {
        return this.gain;
    }

    public void setGain(Double gain) {
        this.gain = gain;
    }

    public ElectricPotential getVoltage() {
        return this.voltage;
    }

    public void setVoltage(ElectricPotential voltage) {
        this.voltage = voltage;
    }

    public static String getVoltageUnitXsdDefault() {
        return "V";
    }

    public Double getZoom() {
        return this.zoom;
    }

    public void setZoom(Double zoom) {
        this.zoom = zoom;
    }

    public Frequency getReadOutRate() {
        return this.readOutRate;
    }

    public void setReadOutRate(Frequency readOutRate) {
        this.readOutRate = readOutRate;
    }

    public static String getReadOutRateUnitXsdDefault() {
        return "MHz";
    }

    public Binning getBinning() {
        return this.binning;
    }

    public void setBinning(Binning binning) {
        this.binning = binning;
    }

    public PositiveInteger getIntegration() {
        return this.integration;
    }

    public void setIntegration(PositiveInteger integration) {
        this.integration = integration;
    }

    public Detector getDetector() {
        return this.detector;
    }

    public void setDetector(Detector detector) {
        this.detector = detector;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element DetectorSettings_element) {
        Enum enumUnits;
        if (DetectorSettings_element == null) {
            DetectorSettings_element = document.createElementNS(NAMESPACE, "DetectorSettings");
        }
        super.asXMLElement(document, DetectorSettings_element);
        if (this.id != null) {
            DetectorSettings_element.setAttribute("ID", this.id);
        }
        if (this.offset != null) {
            DetectorSettings_element.setAttribute("Offset", this.offset.toString());
        }
        if (this.gain != null) {
            DetectorSettings_element.setAttribute("Gain", this.gain.toString());
        }
        if (this.voltage != null) {
            if (this.voltage.value() != null) {
                DetectorSettings_element.setAttribute("Voltage", this.voltage.value().toString());
            }
            if (this.voltage.unit() != null) {
                try {
                    enumUnits = UnitsElectricPotential.fromString(this.voltage.unit().getSymbol());
                    DetectorSettings_element.setAttribute("VoltageUnit", ((UnitsElectricPotential)enumUnits).toString());
                }
                catch (EnumerationException e) {
                    LOGGER.debug("Unable to create xml for DetectorSettings:VoltageUnit: {}", (Object)e.toString());
                }
            }
        }
        if (this.zoom != null) {
            DetectorSettings_element.setAttribute("Zoom", this.zoom.toString());
        }
        if (this.readOutRate != null) {
            if (this.readOutRate.value() != null) {
                DetectorSettings_element.setAttribute("ReadOutRate", this.readOutRate.value().toString());
            }
            if (this.readOutRate.unit() != null) {
                try {
                    enumUnits = UnitsFrequency.fromString(this.readOutRate.unit().getSymbol());
                    DetectorSettings_element.setAttribute("ReadOutRateUnit", ((UnitsFrequency)enumUnits).toString());
                }
                catch (EnumerationException e) {
                    LOGGER.debug("Unable to create xml for DetectorSettings:ReadOutRateUnit: {}", (Object)e.toString());
                }
            }
        }
        if (this.binning != null) {
            DetectorSettings_element.setAttribute("Binning", this.binning.toString());
        }
        if (this.integration != null) {
            DetectorSettings_element.setAttribute("Integration", this.integration.toString());
        }
        return DetectorSettings_element;
    }
}

