/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record;

import loci.poi.hssf.record.Record;
import loci.poi.hssf.record.RecordFormatException;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.util.LittleEndian;

public class DrawingRecord
extends Record {
    public static final short sid = 236;
    private byte[] recordData;

    public DrawingRecord() {
    }

    public DrawingRecord(RecordInputStream in) {
        super(in);
    }

    @Override
    protected void validateSid(short id) {
        if (id != 236) {
            throw new RecordFormatException("Not a MSODRAWING record");
        }
    }

    @Override
    protected void fillFields(RecordInputStream in) {
        this.recordData = in.readRemainder();
    }

    public void processContinueRecord(byte[] record) {
        byte[] newBuffer = new byte[this.recordData.length + record.length];
        System.arraycopy(this.recordData, 0, newBuffer, 0, this.recordData.length);
        System.arraycopy(record, 0, newBuffer, this.recordData.length, record.length);
        this.recordData = newBuffer;
    }

    @Override
    public int serialize(int offset, byte[] data) {
        if (this.recordData == null) {
            this.recordData = new byte[0];
        }
        LittleEndian.putShort(data, 0 + offset, (short)236);
        LittleEndian.putShort(data, 2 + offset, (short)this.recordData.length);
        if (this.recordData.length > 0) {
            System.arraycopy(this.recordData, 0, data, 4 + offset, this.recordData.length);
        }
        return this.getRecordSize();
    }

    @Override
    public int getRecordSize() {
        int retval = 4;
        if (this.recordData != null) {
            retval += this.recordData.length;
        }
        return retval;
    }

    @Override
    public short getSid() {
        return 236;
    }

    public byte[] getData() {
        return this.recordData;
    }

    public void setData(byte[] thedata) {
        this.recordData = thedata;
    }
}

