/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.in;

import ij.ImagePlus;
import ij.ImageStack;
import java.util.ArrayList;
import java.util.List;

public class Concatenator {
    public List<ImagePlus> concatenate(List<ImagePlus> imps) {
        boolean doAppendT = true;
        boolean doAppendZ = true;
        boolean doAppendC = true;
        ArrayList<ImagePlus> outputImps = new ArrayList<ImagePlus>();
        for (ImagePlus imp : imps) {
            int width = imp.getWidth();
            int height = imp.getHeight();
            int type = imp.getType();
            int cSize = imp.getNChannels();
            int zSize = imp.getNSlices();
            int tSize = imp.getNFrames();
            boolean append = false;
            for (int k = 0; k < outputImps.size(); ++k) {
                boolean canAppendC;
                ImagePlus outputImp = (ImagePlus)outputImps.get(k);
                int w = outputImp.getWidth();
                int h2 = outputImp.getHeight();
                int outType = outputImp.getType();
                int c = outputImp.getNChannels();
                int z = outputImp.getNSlices();
                int t2 = outputImp.getNFrames();
                if (width != w || height != h2 || type != outType) continue;
                boolean canAppendT = cSize == c && zSize == z;
                boolean canAppendZ = cSize == c && tSize == t2;
                boolean bl = canAppendC = zSize == z && tSize == t2;
                if (!canAppendT && !canAppendZ && !canAppendC) continue;
                ImageStack outputStack = outputImp.getStack();
                ImageStack inputStack = imp.getStack();
                for (int s2 = 0; s2 < inputStack.getSize(); ++s2) {
                    outputStack.addSlice(inputStack.getSliceLabel(s2 + 1), inputStack.getProcessor(s2 + 1));
                }
                outputImp.setStack(outputImp.getTitle(), outputStack);
                if (doAppendT && canAppendT) {
                    outputImp.setDimensions(c, z, t2 + tSize);
                } else if (doAppendZ && canAppendZ) {
                    outputImp.setDimensions(c, z + zSize, t2);
                } else if (doAppendC && canAppendC) {
                    outputImp.setDimensions(c + cSize, z, t2);
                }
                append = true;
                break;
            }
            if (append) continue;
            outputImps.add(imp);
        }
        return outputImps;
    }
}

