/*
 * Decompiled with CFR 0.152.
 */
package org.diplib.viewer;

import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.JFrame;
import org.diplib.viewer.Proxy;

public class Viewer
extends JFrame
implements GLEventListener,
WindowListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener {
    Proxy proxy_;
    Pointer pointer_;
    GLCanvas canvas_;
    Proxy.SetWindowTitleCallback title_cb_;
    Proxy.RefreshWindowCallback refresh_cb_;
    Proxy.CreateWindowCallback create_cb_;
    int framebuffer_width_;
    int framebuffer_height_;

    public Viewer(long l) {
        File file = new File(Viewer.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        String string = file.getParent() + File.separator + ".." + File.separator + ".." + File.separator + "lib";
        try {
            NativeLibrary.addSearchPath((String)"DIPviewer", (String)new File(string).getCanonicalPath());
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        this.proxy_ = (Proxy)Native.loadLibrary((String)"DIPviewer", Proxy.class);
        this.pointer_ = new Pointer(l);
        this.framebuffer_width_ = this.proxy_.proxyGetWidth(this.pointer_);
        this.framebuffer_height_ = this.proxy_.proxyGetHeight(this.pointer_);
        GLProfile gLProfile = GLProfile.get((String)"GL2");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setDoubleBuffered(true);
        this.canvas_ = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
        this.canvas_.addGLEventListener((GLEventListener)this);
        this.canvas_.addMouseListener((MouseListener)this);
        this.canvas_.addMouseMotionListener((MouseMotionListener)this);
        this.canvas_.addMouseWheelListener((MouseWheelListener)this);
        this.canvas_.addKeyListener((KeyListener)this);
        this.addWindowListener(this);
        this.setTitle("SliceViewer");
        this.getContentPane().add((Component)this.canvas_);
        this.setSize(this.proxy_.proxyGetWidth(this.pointer_), this.proxy_.proxyGetHeight(this.pointer_));
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
        this.setResizable(true);
        this.canvas_.requestFocusInWindow();
        this.title_cb_ = new Proxy.SetWindowTitleCallback(){

            @Override
            public void invoke(String string) {
                Viewer.this.setTitle(string);
            }
        };
        this.proxy_.proxySetWindowTitleCallback(this.pointer_, this.title_cb_);
        this.refresh_cb_ = new Proxy.RefreshWindowCallback(){

            @Override
            public void invoke() {
                Viewer.this.canvas_.display();
            }
        };
        this.proxy_.proxySetRefreshWindowCallback(this.pointer_, this.refresh_cb_);
        this.create_cb_ = new Proxy.CreateWindowCallback(){

            @Override
            public void invoke(Pointer pointer) {
                new Viewer(Pointer.nativeValue((Pointer)pointer));
            }
        };
        this.proxy_.proxySetCreateWindowCallback(this.pointer_, this.create_cb_);
    }

    Point translateMouse(MouseEvent mouseEvent) {
        return new Point(mouseEvent.getX() * this.framebuffer_width_ / this.canvas_.getWidth(), mouseEvent.getY() * this.framebuffer_height_ / this.canvas_.getHeight());
    }

    int translateModifiers(InputEvent inputEvent) {
        int n = inputEvent.getModifiersEx();
        int n2 = ((n & 0x40) > 0 ? 1 : 0) + ((n & 0x80) > 0 ? 2 : 0) + ((n & 0x200) > 0 ? 4 : 0) + ((n & 0x100) > 0 ? 8 : 0);
        return n2;
    }

    public String display() {
        return "org.java.viewer.Viewer";
    }

    public long[] pointer() {
        long[] lArray = new long[1];
        lArray[0] = Pointer.nativeValue((Pointer)this.pointer_);
        long[] lArray2 = lArray;
        return lArray2;
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        this.proxy_.proxyDrawEvent(this.pointer_);
        if (this.proxy_.proxyGetDestroyed(this.pointer_)) {
            this.dispose();
        }
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        gLAutoDrawable.getGL().setSwapInterval(0);
        this.proxy_.proxyCreateEvent(this.pointer_);
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        this.framebuffer_width_ = n3;
        this.framebuffer_height_ = n4;
        this.proxy_.proxyReshapeEvent(this.pointer_, n3, n4);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Point point = this.translateMouse(mouseEvent);
        this.proxy_.proxyClickEvent(this.pointer_, mouseEvent.getButton() - 1, 0, point.x, point.y, this.translateModifiers(mouseEvent));
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Point point = this.translateMouse(mouseEvent);
        this.proxy_.proxyClickEvent(this.pointer_, mouseEvent.getButton() - 1, 1, point.x, point.y, this.translateModifiers(mouseEvent));
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = this.translateMouse(mouseEvent);
        this.proxy_.proxyMotionEvent(this.pointer_, point.x, point.y);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        Point point = this.translateMouse(mouseWheelEvent);
        int n = 3;
        if (mouseWheelEvent.getWheelRotation() > 0) {
            ++n;
        }
        if (mouseWheelEvent.getWheelRotation() != 0) {
            this.proxy_.proxyClickEvent(this.pointer_, n, 1, point.x, point.y, this.translateModifiers(mouseWheelEvent));
            this.proxy_.proxyClickEvent(this.pointer_, n, 0, point.x, point.y, this.translateModifiers(mouseWheelEvent));
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        this.proxy_.proxyCloseEvent(this.pointer_);
        this.proxy_.proxyRelease(this.pointer_);
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
        this.proxy_.proxyVisibleEvent(this.pointer_, 1);
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
        this.proxy_.proxyVisibleEvent(this.pointer_, 0);
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n;
        int n2 = keyEvent.getKeyChar();
        if (n2 < 27) {
            n2 = n2 + 65 - 1;
        }
        if (n2 >= 97 && n2 <= 122) {
            n2 = n2 - 97 + 65;
        }
        if (((n = this.translateModifiers(keyEvent)) & 3) == 3 && n2 == 87) {
            System.out.println("Control-Shift-W not supported under Java");
        } else {
            this.proxy_.proxyKeyEvent(this.pointer_, (byte)n2, 0, 0, this.translateModifiers(keyEvent));
        }
        if (this.proxy_.proxyGetDestroyed(this.pointer_)) {
            this.dispose();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }
}

