/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.util;

import ij.IJ;
import ij.ImageJ;
import ij.gui.GenericDialog;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.List;
import java.util.StringTokenizer;
import loci.common.DebugTools;
import loci.plugins.BF;

public final class WindowTools {
    private WindowTools() {
    }

    public static void addScrollBars(Container pane) {
        GridBagLayout layout = (GridBagLayout)pane.getLayout();
        int count = pane.getComponentCount();
        Component[] c = new Component[count];
        GridBagConstraints[] gbc = new GridBagConstraints[count];
        for (int i = 0; i < count; ++i) {
            c[i] = pane.getComponent(i);
            gbc[i] = layout.getConstraints(c[i]);
        }
        pane.removeAll();
        layout.invalidateLayout(pane);
        Panel newPane = new Panel();
        GridBagLayout newLayout = new GridBagLayout();
        newPane.setLayout(newLayout);
        for (int i = 0; i < count; ++i) {
            newLayout.setConstraints(c[i], gbc[i]);
            newPane.add(c[i]);
        }
        Frame f = new Frame();
        f.setLayout(new BorderLayout());
        f.add((Component)newPane, "Center");
        f.pack();
        final Dimension size = newPane.getSize();
        f.remove(newPane);
        f.dispose();
        size.width += 25;
        size.height += 15;
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int maxWidth = 7 * screen.width / 8;
        int maxHeight = 3 * screen.height / 4;
        if (size.width > maxWidth) {
            size.width = maxWidth;
        }
        if (size.height > maxHeight) {
            size.height = maxHeight;
        }
        ScrollPane scroll = new ScrollPane(){

            @Override
            public Dimension getPreferredSize() {
                return size;
            }
        };
        scroll.add(newPane);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        layout.setConstraints(scroll, constraints);
        pane.add(scroll);
    }

    public static void placeWindow(Window w) {
        Dimension size = w.getSize();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        ImageJ ij = IJ.getInstance();
        Point p = new Point();
        if (ij == null) {
            p.x = (screen.width - size.width) / 2;
            p.y = (screen.height - size.height) / 2;
        } else {
            Rectangle ijBounds = ij.getBounds();
            p.x = ijBounds.x + (ijBounds.width - size.width) / 2;
            p.y = ijBounds.y + ijBounds.height + 5;
        }
        int pad = 10;
        if (p.x < 10) {
            p.x = 10;
        } else if (p.x + size.width + 10 > screen.width) {
            p.x = screen.width - size.width - 10;
        }
        if (p.y < 10) {
            p.y = 10;
        } else if (p.y + size.height + 10 > screen.height) {
            p.y = screen.height - size.height - 10;
        }
        w.setLocation(p);
    }

    public static void reportException(Throwable t2) {
        WindowTools.reportException(t2, false, null);
    }

    public static void reportException(Throwable t2, boolean quiet) {
        WindowTools.reportException(t2, quiet, null);
    }

    public static void reportException(Throwable t2, boolean quiet, String msg) {
        if (quiet) {
            return;
        }
        BF.status(quiet, "");
        if (t2 != null) {
            String s2 = DebugTools.getStackTrace(t2);
            StringTokenizer st = new StringTokenizer(s2, "\n\r");
            while (st.hasMoreTokens()) {
                IJ.log((String)st.nextToken());
            }
        }
        if (msg != null) {
            IJ.error((String)"Bio-Formats Importer", (String)msg);
        }
    }

    public static List<TextField> getNumericFields(GenericDialog gd) {
        return gd.getNumericFields();
    }

    public static List<Checkbox> getCheckboxes(GenericDialog gd) {
        return gd.getCheckboxes();
    }

    public static List<Choice> getChoices(GenericDialog gd) {
        return gd.getChoices();
    }
}

