/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.IOException;
import java.io.Reader;
import java.util.EnumSet;
import java.util.ServiceLoader;
import java.util.Set;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFiles;
import ucar.nc2.dataset.DatasetUrl;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.spi.NetcdfFileProvider;
import ucar.nc2.internal.dataset.DatasetEnhancer;
import ucar.nc2.internal.ncml.NcmlReader;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.cache.FileCache;
import ucar.nc2.util.cache.FileCacheIF;
import ucar.nc2.util.cache.FileFactory;

public class NetcdfDatasets {
    private static FileCache netcdfFileCache;
    private static FileFactory defaultNetcdfFileFactory;

    public static synchronized void initNetcdfFileCache(int minElementsInMemory, int maxElementsInMemory, int period) {
        NetcdfDatasets.initNetcdfFileCache(minElementsInMemory, maxElementsInMemory, -1, period);
    }

    public static synchronized void initNetcdfFileCache(int minElementsInMemory, int maxElementsInMemory, int hardLimit, int period) {
        netcdfFileCache = new FileCache("NetcdfFileCache", minElementsInMemory, maxElementsInMemory, hardLimit, period);
    }

    public static synchronized void disableNetcdfFileCache() {
        if (null != netcdfFileCache) {
            netcdfFileCache.disable();
        }
        netcdfFileCache = null;
    }

    public static synchronized void shutdown() {
        NetcdfDatasets.disableNetcdfFileCache();
        FileCache.shutdown();
    }

    public static synchronized FileCacheIF getNetcdfFileCache() {
        return netcdfFileCache;
    }

    public static NetcdfDataset openDataset(String location) throws IOException {
        return NetcdfDatasets.openDataset(location, true, null);
    }

    public static NetcdfDataset openDataset(String location, boolean enhance, CancelTask cancelTask) throws IOException {
        return NetcdfDatasets.openDataset(location, enhance, -1, cancelTask, null);
    }

    public static NetcdfDataset openDataset(String location, boolean enhance, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
        DatasetUrl durl = DatasetUrl.findDatasetUrl(location);
        return NetcdfDatasets.openDataset(durl, enhance ? NetcdfDataset.getDefaultEnhanceMode() : null, buffer_size, cancelTask, spiObject);
    }

    public static NetcdfDataset openDataset(DatasetUrl location, Set<NetcdfDataset.Enhance> enhanceMode, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
        NetcdfFile ncfile = NetcdfDatasets.openProtocolOrFile(location, buffer_size, cancelTask, spiObject);
        return NetcdfDatasets.enhance(ncfile, enhanceMode, cancelTask);
    }

    public static NetcdfDataset openNcmlDataset(Reader reader, String ncmlLocation, CancelTask cancelTask) throws IOException {
        NetcdfDataset.Builder builder = NcmlReader.readNcml(reader, ncmlLocation, cancelTask);
        if (!builder.getEnhanceMode().isEmpty()) {
            DatasetEnhancer enhancer = new DatasetEnhancer(builder, builder.getEnhanceMode(), cancelTask);
            return enhancer.enhance().build();
        }
        return builder.build();
    }

    public static NetcdfDataset enhance(NetcdfFile ncfile, Set<NetcdfDataset.Enhance> mode, CancelTask cancelTask) throws IOException {
        if (ncfile instanceof NetcdfDataset) {
            NetcdfDataset ncd = (NetcdfDataset)ncfile;
            NetcdfFile.Builder builder = ncd.toBuilder();
            if (DatasetEnhancer.enhanceNeeded(mode, ncd.getEnhanceMode())) {
                DatasetEnhancer enhancer = new DatasetEnhancer((NetcdfDataset.Builder)builder, mode, cancelTask);
                return enhancer.enhance().build();
            }
            return ncd;
        }
        NetcdfDataset.Builder builder = NetcdfDataset.builder(ncfile);
        if (DatasetEnhancer.enhanceNeeded(mode, null)) {
            DatasetEnhancer enhancer = new DatasetEnhancer(builder, mode, cancelTask);
            return enhancer.enhance().build();
        }
        return builder.build();
    }

    public static NetcdfDataset acquireDataset(DatasetUrl location, CancelTask cancelTask) throws IOException {
        return NetcdfDatasets.acquireDataset(null, location, NetcdfDataset.getDefaultEnhanceMode(), -1, cancelTask, null);
    }

    public static NetcdfDataset acquireDataset(DatasetUrl location, boolean enhanceMode, CancelTask cancelTask) throws IOException {
        return NetcdfDatasets.acquireDataset(null, location, enhanceMode ? NetcdfDataset.getDefaultEnhanceMode() : null, -1, cancelTask, null);
    }

    public static NetcdfDataset acquireDataset(DatasetUrl location, Set<NetcdfDataset.Enhance> enhanceMode, CancelTask cancelTask) throws IOException {
        return NetcdfDatasets.acquireDataset(null, location, enhanceMode, -1, cancelTask, null);
    }

    public static NetcdfDataset acquireDataset(FileFactory fac, DatasetUrl durl, Set<NetcdfDataset.Enhance> enhanceMode, int buffer_size, CancelTask cancelTask, Object iospMessage) throws IOException {
        if (netcdfFileCache == null) {
            if (fac == null) {
                return NetcdfDatasets.openDataset(durl, enhanceMode, buffer_size, cancelTask, iospMessage);
            }
            return (NetcdfDataset)fac.open(durl, buffer_size, cancelTask, iospMessage);
        }
        if (fac != null) {
            return (NetcdfDataset)NetcdfDatasets.openOrAcquireFile(netcdfFileCache, fac, null, durl, buffer_size, cancelTask, iospMessage);
        }
        fac = new StandardDatasetFactory(durl, enhanceMode);
        return (NetcdfDataset)NetcdfDatasets.openOrAcquireFile(netcdfFileCache, fac, fac.hashCode(), durl, buffer_size, cancelTask, iospMessage);
    }

    public static NetcdfFile openFile(String location, CancelTask cancelTask) throws IOException {
        DatasetUrl durl = DatasetUrl.findDatasetUrl(location);
        return NetcdfDatasets.openFile(durl, -1, cancelTask, null);
    }

    public static NetcdfFile openFile(DatasetUrl location, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
        return NetcdfDatasets.openProtocolOrFile(location, buffer_size, cancelTask, spiObject);
    }

    public static NetcdfFile acquireFile(DatasetUrl location, CancelTask cancelTask) throws IOException {
        return NetcdfDatasets.acquireFile(null, null, location, -1, cancelTask, null);
    }

    public static NetcdfFile acquireFile(FileFactory factory, Object hashKey, DatasetUrl location, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
        if (netcdfFileCache == null && factory != null) {
            return (NetcdfFile)factory.open(location, buffer_size, cancelTask, spiObject);
        }
        return NetcdfDatasets.openOrAcquireFile(netcdfFileCache, factory, hashKey, location, buffer_size, cancelTask, spiObject);
    }

    private static NetcdfFile openOrAcquireFile(FileCache cache, FileFactory factory, Object hashKey, DatasetUrl durl, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
        if (factory == null) {
            factory = defaultNetcdfFileFactory;
        }
        if (cache != null) {
            return (NetcdfFile)cache.acquire(factory, hashKey, durl, buffer_size, cancelTask, spiObject);
        }
        return (NetcdfFile)factory.open(durl, buffer_size, cancelTask, spiObject);
    }

    private static NetcdfFile openProtocolOrFile(DatasetUrl durl, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
        for (NetcdfFileProvider provider : ServiceLoader.load(NetcdfFileProvider.class)) {
            if (!provider.isOwnerOf(durl)) continue;
            return provider.open(durl.getTrueurl(), cancelTask);
        }
        for (NetcdfFileProvider provider : ServiceLoader.load(NetcdfFileProvider.class)) {
            if (!provider.isOwnerOf(durl.getTrueurl())) continue;
            return provider.open(durl.getTrueurl(), cancelTask);
        }
        if (durl.getServiceType() != null) {
            switch (durl.getServiceType()) {
                case File: 
                case HTTPServer: {
                    break;
                }
                default: {
                    throw new IOException("Unknown service type: " + (Object)((Object)durl.getServiceType()));
                }
            }
        }
        return NetcdfFiles.open(durl.getTrueurl(), buffer_size, cancelTask, spiObject);
    }

    static {
        defaultNetcdfFileFactory = new StandardFileFactory();
    }

    private static class StandardDatasetFactory
    implements FileFactory {
        DatasetUrl location;
        EnumSet<NetcdfDataset.Enhance> enhanceMode;

        StandardDatasetFactory(DatasetUrl location, Set<NetcdfDataset.Enhance> enhanceMode) {
            this.location = location;
            this.enhanceMode = enhanceMode == null ? EnumSet.noneOf(NetcdfDataset.Enhance.class) : EnumSet.copyOf(enhanceMode);
        }

        @Override
        public NetcdfFile open(DatasetUrl location, int buffer_size, CancelTask cancelTask, Object iospMessage) throws IOException {
            return NetcdfDatasets.openDataset(location, this.enhanceMode, buffer_size, cancelTask, iospMessage);
        }

        public int hashCode() {
            int result = this.location.hashCode();
            result += 37 * result + this.enhanceMode.hashCode();
            return result;
        }
    }

    private static class StandardFileFactory
    implements FileFactory {
        private StandardFileFactory() {
        }

        @Override
        public NetcdfFile open(DatasetUrl location, int buffer_size, CancelTask cancelTask, Object iospMessage) throws IOException {
            return NetcdfDatasets.openFile(location, buffer_size, cancelTask, iospMessage);
        }
    }
}

