/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in.LeicaMicrosystemsMetadata;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.in.LeicaMicrosystemsMetadata.Channel;
import loci.formats.in.LeicaMicrosystemsMetadata.Dimension;
import loci.formats.in.LeicaMicrosystemsMetadata.LMSFileReader;
import loci.formats.in.LeicaMicrosystemsMetadata.LMSImageXmlDocument;
import loci.formats.in.LeicaMicrosystemsMetadata.ROI;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.xml.model.primitives.Color;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LMSMetadataExtractor {
    private static final long METER_MULTIPLY = 1000000L;
    private LMSFileReader r;
    List<Long> channelBytesIncs = new ArrayList<Long>();
    int extras = 1;

    public LMSMetadataExtractor(LMSFileReader reader) {
        this.r = reader;
    }

    public void translateMetadata(List<LMSImageXmlDocument> docs) throws FormatException, IOException {
        int len = docs.size();
        this.r.setCore(new ArrayList<CoreMetadata>(len));
        this.r.getCore().clear();
        for (int i = 0; i < docs.size(); ++i) {
            CoreMetadata ms = new CoreMetadata();
            this.r.getCore().add(ms);
            this.r.setSeries(i);
            Node image = docs.get(i).getImageNode();
            this.r.metaTemp.imageNames[i] = docs.get(i).getImageName();
            this.translateImage((Element)image, i);
        }
        this.r.setSeries(0);
        ArrayList<CoreMetadata> newCore = new ArrayList<CoreMetadata>();
        for (int i = 0; i < this.r.getCore().size(); ++i) {
            for (int tile = 0; tile < this.r.metaTemp.tileCount[i]; ++tile) {
                newCore.add(this.r.getCore().get(i));
            }
        }
        this.r.setCore(newCore);
    }

    public void translateImage(Element image, int i) throws FormatException {
        CoreMetadata ms = this.r.getCore().get(i);
        ms.orderCertain = true;
        ms.metadataComplete = true;
        ms.littleEndian = true;
        ms.falseColor = true;
        this.translateChannelDescriptions(image, i);
        this.translateDimensionDescriptions(image, i);
        this.translateAttachmentNodes(image, i);
        this.translateScannerSettings(image, i);
        this.translateFilterSettings(image, i);
        this.translateTimestamps(image, i);
        this.translateLaserLines(image, i);
        this.translateROIs(image, i);
        this.translateSingleROIs(image, i);
        this.translateDetectors(image, i);
        ArrayDeque<String> nameStack = new ArrayDeque<String>();
        this.populateOriginalMetadata(image, nameStack);
        this.addUserCommentMeta(image, i);
    }

    public void translateChannelDescriptions(Element imageNode, int coreIndex) throws FormatException {
        CoreMetadata ms = this.r.getCore().get(coreIndex);
        NodeList channels = this.getChannelDescriptionNodes(imageNode);
        ms.sizeC = channels.getLength();
        ArrayList<String> luts = new ArrayList<String>();
        this.r.metaTemp.channelPrios = new int[this.r.metaTemp.tileCount.length][];
        for (int ch = 0; ch < channels.getLength(); ++ch) {
            Element channelElement = (Element)channels.item(ch);
            luts.add(channelElement.getAttribute("LUTName"));
            int channelTag = Integer.parseInt(channelElement.getAttribute("ChannelTag"));
            int resolution = Integer.parseInt(channelElement.getAttribute("Resolution"));
            double min2 = this.parseDouble(channelElement.getAttribute("Min"));
            double max = this.parseDouble(channelElement.getAttribute("Max"));
            String unit = channelElement.getAttribute("Unit");
            String lutName = channelElement.getAttribute("LUTName");
            long bytesInc = this.parseLong(channelElement.getAttribute("BytesInc"));
            Channel channel = new Channel(channelTag, resolution, min2, max, unit, lutName, bytesInc);
            this.r.metaTemp.channels.get(coreIndex).add(channel);
        }
        this.r.metaTemp.inverseRgb[coreIndex] = channels.getLength() < 3 || !((Element)channels.item(0)).getAttribute("LUTName").equals("Red") || !((Element)channels.item(1)).getAttribute("LUTName").equals("Green") || !((Element)channels.item(2)).getAttribute("LUTName").equals("Blue");
        this.translateLuts(luts, coreIndex);
    }

    private void translateLuts(List<String> luts, int imgIndex) {
        CoreMetadata ms = this.r.getCore().get(imgIndex);
        ArrayList<Color> channelColors = new ArrayList<Color>(ms.sizeC);
        this.r.metaTemp.channelPrios[imgIndex] = new int[ms.sizeC];
        int nextLut = 0;
        for (int channel = 0; channel < ms.sizeC; ++channel) {
            if (nextLut >= luts.size()) continue;
            Color lutColor = this.translateLut(luts.get(nextLut));
            channelColors.add(lutColor);
            this.r.metaTemp.channelPrios[imgIndex][channel] = this.getChannelPriority(luts.get(nextLut));
            ++nextLut;
        }
        this.r.metaTemp.channelColors.add(channelColors);
    }

    private int getChannelPriority(String lutName) {
        switch (lutName) {
            case "red": {
                return 0;
            }
            case "green": {
                return 1;
            }
            case "blue": {
                return 2;
            }
            case "cyan": {
                return 3;
            }
            case "magenta": {
                return 4;
            }
            case "yellow": {
                return 5;
            }
            case "black": {
                return 6;
            }
            case "gray": {
                return 7;
            }
        }
        return 8;
    }

    private Color translateLut(String lutName) {
        lutName = lutName.replaceAll("\\s+", "");
        Pattern pattern = Pattern.compile("Gradient\\(\\d+,\\d+,\\d+\\)", 2);
        Matcher matcher = pattern.matcher(lutName);
        if (matcher.find()) {
            String[] rgb = lutName.substring(9, lutName.length() - 1).split(",");
            return new Color(Integer.parseInt(rgb[2]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[0]), 255);
        }
        switch (lutName.toLowerCase()) {
            case "red": {
                return new Color(255, 0, 0, 255);
            }
            case "green": {
                return new Color(0, 255, 0, 255);
            }
            case "blue": {
                return new Color(0, 0, 255, 255);
            }
            case "cyan": {
                return new Color(0, 255, 255, 255);
            }
            case "magenta": {
                return new Color(255, 0, 255, 255);
            }
            case "yellow": {
                return new Color(255, 255, 0, 255);
            }
        }
        return new Color(255, 255, 255, 255);
    }

    private void translateDimensionDescriptions(Element imageNode, int coreIndex) throws FormatException {
        CoreMetadata cmd = this.r.getCore().get(coreIndex);
        NodeList dimensions = this.getDimensionDescriptionNodes(imageNode);
        for (int i = 0; i < dimensions.getLength(); ++i) {
            Element dimensionElement = (Element)dimensions.item(i);
            int id = this.parseInt(dimensionElement.getAttribute("DimID"));
            int size = this.parseInt(dimensionElement.getAttribute("NumberOfElements"));
            long bytesInc = this.parseLong(dimensionElement.getAttribute("BytesInc"));
            Double length = this.parseDouble(dimensionElement.getAttribute("Length"));
            String unit = dimensionElement.getAttribute("Unit");
            boolean oldPhysicalSize = this.r.useOldPhysicalSizeCalculation();
            Dimension dimension = new Dimension(Dimension.DimensionKey.with(id), size, bytesInc, unit, length, oldPhysicalSize);
            this.r.metaTemp.addDimension(coreIndex, dimension);
            if (Dimension.DimensionKey.with(id) != null) continue;
            this.extras *= dimension.size;
        }
        this.r.metaTemp.addChannelDimension(coreIndex);
        this.r.metaTemp.addMissingDimensions(coreIndex);
        this.setCoreDimensionSizes(coreIndex);
        this.setPixelType(coreIndex);
        cmd.interleaved = this.r.getImageFormat() == LMSFileReader.ImageFormat.TIF || this.r.getImageFormat() == LMSFileReader.ImageFormat.JPEG ? false : cmd.rgb;
        cmd.indexed = !cmd.rgb;
        cmd.imageCount = cmd.sizeZ * cmd.sizeT;
        cmd.imageCount = !cmd.rgb ? (cmd.imageCount *= cmd.sizeC) : (cmd.imageCount *= cmd.sizeC / 3);
        cmd.dimensionOrder = this.r.metaTemp.getDimensionOrder(coreIndex);
    }

    private void setCoreDimensionSizes(int coreIndex) {
        CoreMetadata cmd = this.r.getCore().get(coreIndex);
        cmd.sizeX = this.r.metaTemp.getDimension((int)coreIndex, (Dimension.DimensionKey)Dimension.DimensionKey.X).size;
        cmd.sizeY = this.r.metaTemp.getDimension((int)coreIndex, (Dimension.DimensionKey)Dimension.DimensionKey.Y).size;
        cmd.sizeZ = this.r.metaTemp.getDimension((int)coreIndex, (Dimension.DimensionKey)Dimension.DimensionKey.Z).size;
        cmd.sizeT = this.r.metaTemp.getDimension((int)coreIndex, (Dimension.DimensionKey)Dimension.DimensionKey.T).size;
        boolean bl = cmd.rgb = this.r.metaTemp.getDimension((int)coreIndex, (Dimension.DimensionKey)Dimension.DimensionKey.X).bytesInc % 3L == 0L;
        if (cmd.rgb) {
            this.r.metaTemp.getDimension((int)coreIndex, (Dimension.DimensionKey)Dimension.DimensionKey.X).bytesInc /= 3L;
        }
        if (this.extras > 1) {
            if (cmd.sizeZ == 1) {
                cmd.sizeZ = this.extras;
            } else {
                cmd.sizeT = cmd.sizeT == 0 ? this.extras : (cmd.sizeT *= this.extras);
            }
        }
        if (cmd.sizeX == 0) {
            cmd.sizeX = 1;
        }
        if (cmd.sizeY == 0) {
            cmd.sizeY = 1;
        }
        if (cmd.sizeC == 0) {
            cmd.sizeC = 1;
        }
        if (cmd.sizeZ == 0) {
            cmd.sizeZ = 1;
        }
        if (cmd.sizeT == 0) {
            cmd.sizeT = 1;
        }
    }

    private void setPixelType(int coreIndex) throws FormatException {
        CoreMetadata cmd = this.r.getCore().get(coreIndex);
        long xBytesInc = this.r.metaTemp.getDimension((int)coreIndex, (Dimension.DimensionKey)Dimension.DimensionKey.X).bytesInc;
        cmd.pixelType = FormatTools.pixelTypeFromBytes((int)xBytesInc, false, true);
    }

    public void translateAttachmentNodes(Element imageNode, int image) throws FormatException {
        boolean tilesAttachmentFound = false;
        NodeList attachmentNodes = this.getNodes(imageNode, "Attachment");
        if (attachmentNodes == null) {
            return;
        }
        for (int i = 0; i < attachmentNodes.getLength(); ++i) {
            Element attachment = (Element)attachmentNodes.item(i);
            String attachmentName = attachment.getAttribute("Name");
            if ("ContextDescription".equals(attachmentName)) {
                this.r.metaTemp.descriptions[image] = attachment.getAttribute("Content");
                continue;
            }
            if (!"TileScanInfo".equals(attachmentName)) continue;
            NodeList tiles = this.getNodes(attachment, "Tile");
            for (int tile = 0; tile < tiles.getLength(); ++tile) {
                Double number;
                Element tileNode = (Element)tiles.item(tile);
                String posX = tileNode.getAttribute("PosX");
                String posY = tileNode.getAttribute("PosY");
                while (this.r.metaTemp.fieldPosX.size() < image) {
                    this.r.metaTemp.fieldPosX.add(null);
                }
                while (this.r.metaTemp.fieldPosY.size() < image) {
                    this.r.metaTemp.fieldPosY.add(null);
                }
                if (posX != null) {
                    try {
                        number = DataTools.parseDouble(posX);
                        this.r.metaTemp.fieldPosX.add(new Length(number, UNITS.METER));
                    }
                    catch (NumberFormatException e) {
                        LMSFileReader.log.debug("", e);
                        this.r.metaTemp.fieldPosX.add(null);
                    }
                }
                if (posY == null) continue;
                try {
                    number = DataTools.parseDouble(posY);
                    this.r.metaTemp.fieldPosY.add(new Length(number, UNITS.METER));
                    continue;
                }
                catch (NumberFormatException e) {
                    LMSFileReader.log.debug("", e);
                    this.r.metaTemp.fieldPosY.add(null);
                }
            }
            tilesAttachmentFound = true;
        }
        if (!tilesAttachmentFound) {
            int i;
            NodeList confocalSettings = null;
            for (i = 0; i < attachmentNodes.getLength(); ++i) {
                Element attachment = (Element)attachmentNodes.item(i);
                String attachmentName = attachment.getAttribute("Name");
                if (!"HardwareSetting".equals(attachmentName)) continue;
                confocalSettings = this.getNodes(attachment, "ATLConfocalSettingDefinition");
                break;
            }
            if (confocalSettings != null) {
                for (i = 0; i < confocalSettings.getLength(); ++i) {
                    Element confocalSetting = (Element)confocalSettings.item(i);
                    String value = confocalSetting.getAttribute("StagePosX");
                    if (value != null && !value.trim().isEmpty()) {
                        this.r.metaTemp.fieldPosX.add(new Length(DataTools.parseDouble(value.trim()), UNITS.METER));
                    }
                    if ((value = confocalSetting.getAttribute("StagePosY")) == null || value.trim().isEmpty()) continue;
                    this.r.metaTemp.fieldPosY.add(new Length(DataTools.parseDouble(value.trim()), UNITS.METER));
                }
            } else {
                this.r.metaTemp.fieldPosX.add(null);
                this.r.metaTemp.fieldPosY.add(null);
            }
        }
    }

    public void translateScannerSettings(Element imageNode, int image) throws FormatException {
        int i;
        NodeList scannerSettings = this.getNodes(imageNode, "ScannerSettingRecord");
        NodeList attachmentNodes = this.getNodes(imageNode, "Attachment");
        if (attachmentNodes == null) {
            return;
        }
        NodeList confocalSettings = null;
        for (i = 0; i < attachmentNodes.getLength(); ++i) {
            Element attachment = (Element)attachmentNodes.item(i);
            String attachmentName = attachment.getAttribute("Name");
            if (!"HardwareSetting".equals(attachmentName)) continue;
            confocalSettings = this.getNodes(attachment, "ATLConfocalSettingDefinition");
        }
        if (scannerSettings == null && confocalSettings == null) {
            return;
        }
        this.r.metaTemp.expTimes[image] = new Double[this.r.getEffectiveSizeC()];
        this.r.metaTemp.gains[image] = new Double[this.r.getEffectiveSizeC()];
        this.r.metaTemp.detectorOffsets[image] = new Double[this.r.getEffectiveSizeC()];
        this.r.metaTemp.channelNames[image] = new String[this.r.getEffectiveSizeC()];
        this.r.metaTemp.exWaves[image] = new Double[this.r.getEffectiveSizeC()];
        if (scannerSettings != null) {
            for (i = 0; i < scannerSettings.getLength(); ++i) {
                String value;
                Element scannerSetting = (Element)scannerSettings.item(i);
                String id = scannerSetting.getAttribute("Identifier");
                if (id == null) {
                    id = "";
                }
                if ((value = scannerSetting.getAttribute("Variant")) == null || value.trim().isEmpty()) continue;
                if (id.equals("SystemType")) {
                    this.r.metaTemp.microscopeModels[image] = value;
                    continue;
                }
                if (id.equals("dblPinhole")) {
                    this.r.metaTemp.pinholes[image] = DataTools.parseDouble(value.trim()) * 1000000.0;
                    continue;
                }
                if (id.equals("dblZoom")) {
                    this.r.metaTemp.zooms[image] = DataTools.parseDouble(value.trim());
                    continue;
                }
                if (id.equals("dblStepSize")) {
                    this.r.metaTemp.zSteps[image] = DataTools.parseDouble(value.trim()) * 1000000.0;
                    continue;
                }
                if (id.equals("nDelayTime_s")) {
                    this.r.metaTemp.tSteps[image] = DataTools.parseDouble(value.trim());
                    continue;
                }
                if (id.equals("CameraName")) {
                    this.r.metaTemp.detectorModels.get(image).add(value);
                    continue;
                }
                if (id.equals("eDirectional")) {
                    this.r.addSeriesMeta("Reverse X orientation", (Object)"1".equals(value.trim()));
                    continue;
                }
                if (id.equals("eDirectionalY")) {
                    this.r.addSeriesMeta("Reverse Y orientation", (Object)"1".equals(value.trim()));
                    continue;
                }
                if (id.indexOf("WFC") != 1) continue;
                int c = 0;
                try {
                    c = Integer.parseInt(id.replaceAll("\\D", ""));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (c < 0 || c >= this.r.getEffectiveSizeC()) continue;
                if (id.endsWith("ExposureTime")) {
                    this.r.metaTemp.expTimes[image][c] = DataTools.parseDouble(value.trim());
                    continue;
                }
                if (id.endsWith("Gain")) {
                    this.r.metaTemp.gains[image][c] = DataTools.parseDouble(value.trim());
                    continue;
                }
                if (id.endsWith("WaveLength")) {
                    Double exWave = DataTools.parseDouble(value.trim());
                    if (exWave == null || !(exWave > 0.0)) continue;
                    this.r.metaTemp.exWaves[image][c] = exWave;
                    continue;
                }
                if (!id.endsWith("UesrDefName") && !id.endsWith("UserDefName") || value.equals("None") || this.r.metaTemp.channelNames[image][c] != null && !this.r.metaTemp.channelNames[image][c].trim().isEmpty()) continue;
                this.r.metaTemp.channelNames[image][c] = value;
            }
        }
        if (confocalSettings != null) {
            for (i = 0; i < confocalSettings.getLength(); ++i) {
                Element confocalSetting = (Element)confocalSettings.item(i);
                String value = confocalSetting.getAttribute("Pinhole");
                if (value != null && !value.trim().isEmpty()) {
                    this.r.metaTemp.pinholes[image] = DataTools.parseDouble(value.trim()) * 1000000.0;
                }
                if ((value = confocalSetting.getAttribute("Zoom")) != null && !value.trim().isEmpty()) {
                    this.r.metaTemp.zooms[image] = DataTools.parseDouble(value.trim());
                }
                if ((value = confocalSetting.getAttribute("ObjectiveName")) != null && !value.trim().isEmpty()) {
                    this.r.metaTemp.objectiveModels[image] = value.trim();
                }
                if ((value = confocalSetting.getAttribute("FlipX")) != null && !value.trim().isEmpty()) {
                    this.r.metaTemp.flipX[image] = "1".equals(value.trim());
                    this.r.addSeriesMeta("Reverse X orientation", (Object)this.r.metaTemp.flipX[image]);
                }
                if ((value = confocalSetting.getAttribute("FlipY")) != null && !value.trim().isEmpty()) {
                    this.r.metaTemp.flipY[image] = "1".equals(value.trim());
                    this.r.addSeriesMeta("Reverse Y orientation", (Object)this.r.metaTemp.flipY[image]);
                }
                if ((value = confocalSetting.getAttribute("SwapXY")) == null || value.trim().isEmpty()) continue;
                this.r.metaTemp.swapXY[image] = "1".equals(value.trim());
                this.r.addSeriesMeta("Swap XY orientation", (Object)this.r.metaTemp.swapXY[image]);
            }
        }
    }

    public void translateFilterSettings(Element imageNode, int image) throws FormatException {
        NodeList filterSettings = this.getNodes(imageNode, "FilterSettingRecord");
        if (filterSettings == null) {
            return;
        }
        int nextChannel = 0;
        for (int i = 0; i < filterSettings.getLength(); ++i) {
            Element filterSetting = (Element)filterSettings.item(i);
            String object = filterSetting.getAttribute("ObjectName");
            String attribute = filterSetting.getAttribute("Attribute");
            String objectClass = filterSetting.getAttribute("ClassName");
            String variant = filterSetting.getAttribute("Variant");
            String data = filterSetting.getAttribute("Data");
            if (attribute.equals("NumericalAperture")) {
                if (variant == null || variant.trim().isEmpty()) continue;
                this.r.metaTemp.lensNA[image] = DataTools.parseDouble(variant.trim());
                continue;
            }
            if (attribute.equals("OrderNumber")) {
                if (variant == null || variant.trim().isEmpty()) continue;
                this.r.metaTemp.serialNumber[image] = variant.trim();
                continue;
            }
            if (objectClass.equals("CDetectionUnit")) {
                int channel;
                if (!attribute.equals("State") || (channel = LMSMetadataExtractor.getChannelIndex(filterSetting)) < 0) continue;
                this.r.metaTemp.detectorIndexes.get(image).put(Integer.parseInt(data), object);
                this.r.metaTemp.activeDetector.get(image).add("Active".equals(variant.trim()));
                continue;
            }
            if (attribute.equals("Objective")) {
                StringTokenizer tokens = new StringTokenizer(variant, " ");
                boolean foundMag = false;
                StringBuilder model = new StringBuilder();
                while (!foundMag) {
                    String token = tokens.nextToken();
                    int x = token.indexOf(120);
                    if (x != -1) {
                        foundMag = true;
                        String na = token.substring(x + 1);
                        if (na != null && !na.trim().isEmpty()) {
                            this.r.metaTemp.lensNA[image] = DataTools.parseDouble(na.trim());
                        }
                        if ((na = token.substring(0, x)) == null || na.trim().isEmpty()) continue;
                        this.r.metaTemp.magnification[image] = DataTools.parseDouble(na.trim());
                        continue;
                    }
                    model.append(token);
                    model.append(" ");
                }
                String immersion = "Other";
                if (tokens.hasMoreTokens() && ((immersion = tokens.nextToken()) == null || immersion.trim().isEmpty())) {
                    immersion = "Other";
                }
                this.r.metaTemp.immersions[image] = immersion;
                String correction = "Other";
                if (tokens.hasMoreTokens() && ((correction = tokens.nextToken()) == null || correction.trim().isEmpty())) {
                    correction = "Other";
                }
                this.r.metaTemp.corrections[image] = correction;
                this.r.metaTemp.objectiveModels[image] = model.toString().trim();
                continue;
            }
            if (attribute.equals("RefractionIndex")) {
                if (variant == null || variant.trim().isEmpty()) continue;
                this.r.metaTemp.refractiveIndex[image] = DataTools.parseDouble(variant.trim());
                continue;
            }
            if (attribute.equals("XPos")) {
                if (variant == null || variant.trim().isEmpty()) continue;
                Double number = DataTools.parseDouble(variant.trim());
                this.r.metaTemp.posX[image] = new Length(number, UNITS.REFERENCEFRAME);
                continue;
            }
            if (attribute.equals("YPos")) {
                if (variant == null || variant.trim().isEmpty()) continue;
                Double number = DataTools.parseDouble(variant.trim());
                this.r.metaTemp.posY[image] = new Length(number, UNITS.REFERENCEFRAME);
                continue;
            }
            if (attribute.equals("ZPos")) {
                if (variant == null || variant.trim().isEmpty()) continue;
                Double number = DataTools.parseDouble(variant.trim());
                this.r.metaTemp.posZ[image] = new Length(number, UNITS.REFERENCEFRAME);
                continue;
            }
            if (!objectClass.equals("CSpectrophotometerUnit")) continue;
            Double v = DataTools.parseDouble(variant);
            String description = filterSetting.getAttribute("Description");
            if (description.endsWith("(left)")) {
                Length in;
                this.r.metaTemp.filterModels.get(image).add(object);
                if (v == null || !(v > 0.0) || (in = FormatTools.getCutIn(v)) == null) continue;
                this.r.metaTemp.cutIns.get(image).add(in);
                continue;
            }
            if (description.endsWith("(right)")) {
                Length out;
                if (v == null || !(v > 0.0) || (out = FormatTools.getCutOut(v)) == null) continue;
                this.r.metaTemp.cutOuts.get(image).add(out);
                continue;
            }
            if (!attribute.equals("Stain") || nextChannel >= this.r.metaTemp.channelNames[image].length) continue;
            this.r.metaTemp.channelNames[image][nextChannel++] = variant;
        }
    }

    public void translateTimestamps(Element imageNode, int image) throws FormatException {
        NodeList timeStampLists = this.getNodes(imageNode, "TimeStampList");
        if (timeStampLists == null) {
            return;
        }
        Element timeStampList = (Element)timeStampLists.item(0);
        this.r.metaTemp.timestamps[image] = new Double[this.r.getImageCount()];
        String numberOfTimeStamps = timeStampList.getAttribute("NumberOfTimeStamps");
        if (numberOfTimeStamps != null && !numberOfTimeStamps.isEmpty()) {
            String timeStampsRaw = timeStampList.getTextContent();
            List<String> timeStamps = Arrays.asList(timeStampsRaw.split(" "));
            for (int stamp = 0; stamp < timeStamps.size(); ++stamp) {
                if (stamp >= this.r.getImageCount()) continue;
                String timestamp = timeStamps.get(stamp);
                this.r.metaTemp.timestamps[image][stamp] = this.translateSingleTimestamp(timestamp);
            }
        } else {
            NodeList timestampNodes = this.getNodes(imageNode, "TimeStamp");
            if (timestampNodes != null) {
                for (int stamp = 0; stamp < timestampNodes.getLength(); ++stamp) {
                    if (stamp >= this.r.getImageCount()) continue;
                    Element timestamp = (Element)timestampNodes.item(stamp);
                    this.r.metaTemp.timestamps[image][stamp] = this.translateSingleTimestamp(timestamp);
                }
            } else {
                return;
            }
        }
        this.r.metaTemp.acquiredDate[image] = this.r.metaTemp.timestamps[image][0];
    }

    public void translateLaserLines(Element imageNode, int image) throws FormatException {
        NodeList aotfLists = this.getNodes(imageNode, "AotfList");
        if (aotfLists == null || aotfLists.getLength() == 0) {
            return;
        }
        int baseIntensityIndex = 0;
        for (int channel = 0; channel < aotfLists.getLength(); ++channel) {
            Element aotf = (Element)aotfLists.item(channel);
            NodeList laserLines = this.getNodes(aotf, "LaserLineSetting");
            if (laserLines == null) {
                return;
            }
            String gpName = aotf.getParentNode().getParentNode().getNodeName();
            boolean isMaster = gpName.endsWith("Sequential_Master") || gpName.endsWith("Attachment");
            this.r.metaTemp.laserFrap.get(image).add(gpName.endsWith("FRAP_Master"));
            for (int laser = 0; laser < laserLines.getLength(); ++laser) {
                int qualifier;
                Element laserLine = (Element)laserLines.item(laser);
                if (isMaster) continue;
                String lineIndex = laserLine.getAttribute("LineIndex");
                String qual = laserLine.getAttribute("Qualifier");
                int index = lineIndex == null || lineIndex.trim().isEmpty() ? 0 : Integer.parseInt(lineIndex.trim());
                int n = qualifier = qual == null || qual.trim().isEmpty() ? 0 : Integer.parseInt(qual.trim());
                if ((index += 2 - qualifier / 10) < 0) continue;
                String v = laserLine.getAttribute("LaserLine");
                Double wavelength = 0.0;
                if (v != null && !v.trim().isEmpty()) {
                    wavelength = DataTools.parseDouble(v.trim());
                }
                if (index < this.r.metaTemp.laserWavelength.get(image).size()) {
                    this.r.metaTemp.laserWavelength.get(image).set(index, wavelength);
                } else {
                    for (int i = this.r.metaTemp.laserWavelength.get(image).size(); i < index; ++i) {
                        this.r.metaTemp.laserWavelength.get(image).add(0.0);
                    }
                    this.r.metaTemp.laserWavelength.get(image).add(wavelength);
                }
                String intensity = laserLine.getAttribute("IntensityDev");
                Double realIntensity = 0.0;
                if (intensity != null && !intensity.trim().isEmpty() && (realIntensity = DataTools.parseDouble(intensity.trim())) == null) {
                    realIntensity = 0.0;
                }
                realIntensity = 100.0 - realIntensity;
                int realIndex = baseIntensityIndex + index;
                if (realIndex < this.r.metaTemp.laserIntensity.get(image).size()) {
                    this.r.metaTemp.laserIntensity.get(image).set(realIndex, realIntensity);
                    continue;
                }
                while (realIndex < this.r.metaTemp.laserIntensity.get(image).size()) {
                    this.r.metaTemp.laserIntensity.get(image).add(100.0);
                }
                this.r.metaTemp.laserIntensity.get(image).add(realIntensity);
            }
            baseIntensityIndex += this.r.metaTemp.laserWavelength.get(image).size();
        }
    }

    public void translateROIs(Element imageNode, int image) throws FormatException {
        NodeList rois = this.getNodes(imageNode, "Annotation");
        if (rois == null) {
            return;
        }
        this.r.metaTemp.imageROIs[image] = new ROI[rois.getLength()];
        for (int r = 0; r < rois.getLength(); ++r) {
            Double rotation;
            Double transY;
            String color;
            Element roiNode = (Element)rois.item(r);
            ROI roi = new ROI();
            String type = roiNode.getAttribute("type");
            if (type != null && !type.trim().isEmpty()) {
                roi.type = Integer.parseInt(type.trim());
            }
            if ((color = roiNode.getAttribute("color")) != null && !color.trim().isEmpty()) {
                roi.color = Long.parseLong(color.trim());
            }
            roi.name = roiNode.getAttribute("name");
            roi.fontName = roiNode.getAttribute("fontName");
            roi.fontSize = roiNode.getAttribute("fontSize");
            Double transX = DataTools.parseDouble(roiNode.getAttribute("transTransX"));
            if (transX != null) {
                roi.transX = transX / this.r.metaTemp.physicalSizeXs.get(image);
            }
            if ((transY = DataTools.parseDouble(roiNode.getAttribute("transTransY"))) != null) {
                roi.transY = transY / this.r.metaTemp.physicalSizeYs.get(image);
            }
            if ((transX = DataTools.parseDouble(roiNode.getAttribute("transScalingX"))) != null) {
                roi.scaleX = transX / this.r.metaTemp.physicalSizeXs.get(image);
            }
            if ((transY = DataTools.parseDouble(roiNode.getAttribute("transScalingY"))) != null) {
                roi.scaleY = transY / this.r.metaTemp.physicalSizeYs.get(image);
            }
            if ((rotation = DataTools.parseDouble(roiNode.getAttribute("transRotation"))) != null) {
                roi.rotation = rotation;
            }
            String linewidth = roiNode.getAttribute("linewidth");
            try {
                if (linewidth != null && !linewidth.trim().isEmpty()) {
                    roi.linewidth = Integer.parseInt(linewidth.trim());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            roi.text = roiNode.getAttribute("text");
            NodeList vertices = this.getNodes(roiNode, "Vertex");
            if (vertices == null) continue;
            for (int v = 0; v < vertices.getLength(); ++v) {
                Element vertex = (Element)vertices.item(v);
                String xx = vertex.getAttribute("x");
                String yy = vertex.getAttribute("y");
                if (xx != null && !xx.trim().isEmpty()) {
                    roi.x.add(DataTools.parseDouble(xx.trim()));
                }
                if (yy == null || yy.trim().isEmpty()) continue;
                roi.y.add(DataTools.parseDouble(yy.trim()));
            }
            this.r.metaTemp.imageROIs[image][r] = roi;
            if (this.getNodes(imageNode, "ROI") == null) continue;
            this.r.metaTemp.alternateCenter = true;
        }
    }

    public void translateSingleROIs(Element imageNode, int image) throws FormatException {
        if (this.r.metaTemp.imageROIs[image] != null) {
            return;
        }
        NodeList children = this.getNodes(imageNode, "ROI");
        if (children == null) {
            return;
        }
        if ((children = this.getNodes((Element)children.item(0), "Children")) == null) {
            return;
        }
        if ((children = this.getNodes((Element)children.item(0), "Element")) == null) {
            return;
        }
        this.r.metaTemp.imageROIs[image] = new ROI[children.getLength()];
        for (int r = 0; r < children.getLength(); ++r) {
            String color;
            NodeList rois = this.getNodes((Element)children.item(r), "ROISingle");
            Element roiNode = (Element)rois.item(0);
            ROI roi = new ROI();
            String type = roiNode.getAttribute("RoiType");
            if (type != null && !type.trim().isEmpty()) {
                roi.type = Integer.parseInt(type.trim());
            }
            if ((color = roiNode.getAttribute("Color")) != null && !color.trim().isEmpty()) {
                roi.color = Long.parseLong(color.trim());
            }
            Element parent = (Element)roiNode.getParentNode();
            parent = (Element)parent.getParentNode();
            roi.name = parent.getAttribute("Name");
            NodeList vertices = this.getNodes(roiNode, "P");
            double sizeX = this.r.metaTemp.physicalSizeXs.get(image);
            double sizeY = this.r.metaTemp.physicalSizeYs.get(image);
            for (int v = 0; v < vertices.getLength(); ++v) {
                Double y;
                Double x;
                Element vertex = (Element)vertices.item(v);
                String xx = vertex.getAttribute("X");
                String yy = vertex.getAttribute("Y");
                if (xx != null && !xx.trim().isEmpty() && (x = DataTools.parseDouble(xx.trim())) != null) {
                    roi.x.add(x / sizeX);
                }
                if (yy == null || yy.trim().isEmpty() || (y = DataTools.parseDouble(yy.trim())) == null) continue;
                roi.y.add(y / sizeY);
            }
            Element transform = (Element)this.getNodes(roiNode, "Transformation").item(0);
            Double rotation = DataTools.parseDouble(transform.getAttribute("Rotation"));
            if (rotation != null) {
                roi.rotation = rotation;
            }
            Element scaling = (Element)this.getNodes(transform, "Scaling").item(0);
            Double scaleX = DataTools.parseDouble(scaling.getAttribute("XScale"));
            Double scaleY = DataTools.parseDouble(scaling.getAttribute("YScale"));
            if (scaleX != null) {
                roi.scaleX = scaleX;
            }
            if (scaleY != null) {
                roi.scaleY = scaleY;
            }
            Element translation = (Element)this.getNodes(transform, "Translation").item(0);
            Double transX = DataTools.parseDouble(translation.getAttribute("X"));
            Double transY = DataTools.parseDouble(translation.getAttribute("Y"));
            if (transX != null) {
                roi.transX = transX / sizeX;
            }
            if (transY != null) {
                roi.transY = transY / sizeY;
            }
            this.r.metaTemp.imageROIs[image][r] = roi;
        }
    }

    public void translateDetectors(Element imageNode, int image) throws FormatException {
        NodeList definitions = this.getNodes(imageNode, "ATLConfocalSettingDefinition");
        if (definitions == null) {
            return;
        }
        ArrayList<String> channels = new ArrayList<String>();
        int nextChannel = 0;
        for (int definition = 0; definition < definitions.getLength(); ++definition) {
            Element definitionNode = (Element)definitions.item(definition);
            String parentName = definitionNode.getParentNode().getNodeName();
            boolean isMaster = parentName.endsWith("Master");
            NodeList detectors = this.getNodes(definitionNode, "Detector");
            if (detectors == null) {
                return;
            }
            int count = 0;
            for (int d = 0; d < detectors.getLength(); ++d) {
                int channel;
                String v;
                Element detector = (Element)detectors.item(d);
                NodeList multibands = null;
                if (!isMaster) {
                    multibands = this.getNodes(definitionNode, "MultiBand");
                }
                Double gain = (v = detector.getAttribute("Gain")) == null || v.trim().isEmpty() ? null : DataTools.parseDouble(v.trim());
                v = detector.getAttribute("Offset");
                Double offset = v == null || v.trim().isEmpty() ? null : DataTools.parseDouble(v.trim());
                boolean active = "1".equals(detector.getAttribute("IsActive"));
                String c = detector.getAttribute("Channel");
                int n = channel = c == null || c.trim().length() == 0 ? 0 : Integer.parseInt(c);
                if (active) {
                    if (this.r.metaTemp.detectorIndexes.get(image) != null && this.r.metaTemp.detectorModels.get(image) != null) {
                        this.r.metaTemp.detectorModels.get(image).add(this.r.metaTemp.detectorIndexes.get(image).get(channel));
                    }
                    Element multiband = null;
                    if (multibands != null) {
                        for (int i = 0; i < multibands.getLength(); ++i) {
                            Element mb = (Element)multibands.item(i);
                            if (channel != Integer.parseInt(mb.getAttribute("Channel"))) continue;
                            multiband = mb;
                            break;
                        }
                    }
                    if (multiband != null) {
                        Length out;
                        Length in;
                        String dye = multiband.getAttribute("DyeName");
                        if (!channels.contains(dye)) {
                            channels.add(dye);
                        }
                        Double cutIn = DataTools.parseDouble(multiband.getAttribute("LeftWorld"));
                        Double cutOut = DataTools.parseDouble(multiband.getAttribute("RightWorld"));
                        if (cutIn != null && cutIn.intValue() > 0 && (in = FormatTools.getCutIn(Double.valueOf(Math.round(cutIn)))) != null) {
                            this.r.metaTemp.cutIns.get(image).add(in);
                        }
                        if (cutOut != null && cutOut.intValue() > 0 && (out = FormatTools.getCutOut(Double.valueOf(Math.round(cutOut)))) != null) {
                            this.r.metaTemp.cutOuts.get(image).add(out);
                        }
                    } else {
                        channels.add("");
                    }
                    if (!isMaster) {
                        if (channel < nextChannel) {
                            nextChannel = 0;
                        }
                        if (nextChannel < this.r.getEffectiveSizeC()) {
                            if (this.r.metaTemp.gains[image] != null) {
                                this.r.metaTemp.gains[image][nextChannel] = gain;
                            }
                            if (this.r.metaTemp.detectorOffsets[image] != null) {
                                this.r.metaTemp.detectorOffsets[image][nextChannel] = offset;
                            }
                        }
                        ++nextChannel;
                    }
                } else {
                    ++count;
                }
                if (!active || this.r.metaTemp.activeDetector.get(image) == null) continue;
                this.r.metaTemp.activeDetector.get(image).add(active);
            }
            if (isMaster) continue;
            this.r.metaTemp.laserActive.get(image).add(count < detectors.getLength());
        }
        if (channels != null && this.r.metaTemp.channelNames[image] != null) {
            for (int i = 0; i < this.r.getEffectiveSizeC(); ++i) {
                int index = i + channels.size() - this.r.getEffectiveSizeC();
                if (index < 0 || index >= channels.size() || this.r.metaTemp.channelNames[image][i] != null && !this.r.metaTemp.channelNames[image][i].trim().isEmpty()) continue;
                this.r.metaTemp.channelNames[image][i] = (String)channels.get(index);
            }
        }
    }

    private double translateSingleTimestamp(String timestamp) {
        timestamp = timestamp.trim();
        int stampLowStart = Math.max(0, timestamp.length() - 8);
        int stampHighEnd = Math.max(0, stampLowStart);
        String stampHigh = timestamp.substring(0, stampHighEnd);
        String stampLow = timestamp.substring(stampLowStart, timestamp.length());
        long high = stampHigh == null || stampHigh.trim().isEmpty() ? 0L : Long.parseLong(stampHigh.trim(), 16);
        long low = stampLow == null || stampLow.trim().isEmpty() ? 0L : Long.parseLong(stampLow.trim(), 16);
        long milliseconds = DateTools.getMillisFromTicks(high, low);
        double seconds = (double)milliseconds / 1000.0;
        return seconds;
    }

    private double translateSingleTimestamp(Element timestamp) {
        String stampHigh = timestamp.getAttribute("HighInteger");
        String stampLow = timestamp.getAttribute("LowInteger");
        long high = stampHigh == null || stampHigh.trim().isEmpty() ? 0L : Long.parseLong(stampHigh.trim());
        long low = stampLow == null || stampLow.trim().isEmpty() ? 0L : Long.parseLong(stampLow.trim());
        long milliseconds = DateTools.getMillisFromTicks(high, low);
        double seconds = (double)milliseconds / 1000.0;
        return seconds;
    }

    private void addUserCommentMeta(Element imageNode, int image) throws FormatException {
        NodeList attachmentNodes = this.getNodes(imageNode, "User-Comment");
        if (attachmentNodes == null) {
            return;
        }
        for (int i = 0; i < attachmentNodes.getLength(); ++i) {
            Node attachment = attachmentNodes.item(i);
            this.r.addSeriesMeta("User-Comment[" + i + "]", attachment.getTextContent());
            if (i != 0 || this.r.metaTemp.descriptions[image] != null) continue;
            this.r.metaTemp.descriptions[image] = attachment.getTextContent();
        }
    }

    private void populateOriginalMetadata(Element root, Deque<String> nameStack) {
        String name = root.getNodeName();
        if (root.hasAttributes() && !name.equals("Element") && !name.equals("Attachment") && !name.equals("LMSDataContainerHeader")) {
            nameStack.push(name);
            String suffix = root.getAttribute("Identifier");
            String value = root.getAttribute("Variant");
            if (suffix == null || suffix.trim().length() == 0) {
                suffix = root.getAttribute("Description");
            }
            StringBuilder key = new StringBuilder();
            Iterator<String> nameStackIterator = nameStack.descendingIterator();
            while (nameStackIterator.hasNext()) {
                String k = nameStackIterator.next();
                key.append(k);
                key.append("|");
            }
            if (suffix != null && value != null && suffix.length() > 0 && value.length() > 0 && !suffix.equals("HighInteger") && !suffix.equals("LowInteger")) {
                this.r.addSeriesMetaList(key.toString() + suffix, value);
            } else {
                NamedNodeMap attributes = root.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Attr attr = (Attr)attributes.item(i);
                    if (attr.getName().equals("HighInteger") || attr.getName().equals("LowInteger")) continue;
                    this.r.addSeriesMeta(key.toString() + attr.getName(), attr.getValue());
                }
            }
        }
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            this.populateOriginalMetadata((Element)child, nameStack);
        }
        if (root.hasAttributes() && !name.equals("Element") && !name.equals("Attachment") && !name.equals("LMSDataContainerHeader")) {
            nameStack.pop();
        }
    }

    public long parseLong(String value) {
        return value == null || value.trim().isEmpty() ? 0L : Long.parseLong(value.trim());
    }

    public int parseInt(String value) {
        return value == null || value.trim().isEmpty() ? 0 : Integer.parseInt(value.trim());
    }

    public double parseDouble(String value) {
        return StringUtils.isBlank(value) ? 0.0 : DataTools.parseDouble(value.trim());
    }

    private Element getImageDescription(Element root) {
        return (Element)root.getElementsByTagName("ImageDescription").item(0);
    }

    private NodeList getChannelDescriptionNodes(Element root) {
        Element imageDescription = this.getImageDescription(root);
        Element channels = (Element)imageDescription.getElementsByTagName("Channels").item(0);
        return channels.getElementsByTagName("ChannelDescription");
    }

    private NodeList getDimensionDescriptionNodes(Element root) {
        Element imageDescription = this.getImageDescription(root);
        Element channels = (Element)imageDescription.getElementsByTagName("Dimensions").item(0);
        return channels.getElementsByTagName("DimensionDescription");
    }

    private NodeList getNodes(Element root, String nodeName) {
        NodeList nodes = root.getElementsByTagName(nodeName);
        if (nodes.getLength() == 0) {
            NodeList children = root.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                NodeList childNodes;
                Node child = children.item(i);
                if (!(child instanceof Element) || (childNodes = this.getNodes((Element)child, nodeName)) == null) continue;
                return childNodes;
            }
            return null;
        }
        return nodes;
    }

    public static int getChannelIndex(Element filterSetting) {
        int channel;
        String data = filterSetting.getAttribute("data");
        if (data == null || data.equals("")) {
            data = filterSetting.getAttribute("Data");
        }
        int n = channel = data == null || data.equals("") ? 0 : Integer.parseInt(data);
        if (channel < 0) {
            return -1;
        }
        return channel - 1;
    }
}

