/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;

public class DCIMGReader
extends FormatReader {
    private static final boolean IS_LITTLE = true;
    private static final long DCIMG_VERSION_0 = 7L;
    private static final long DCIMG_VERSION_1 = 0x1000000L;
    private static final long DCIMG_PIXELTYPE_MONO8 = 1L;
    private static final long DCIMG_PIXELTYPE_MONO16 = 2L;
    private long version;
    private long headerSize;
    private long dataOffset;
    private long pixelType;
    private long bytesPerImage;
    private long bytesPerRow;
    private long offsetToFooter;
    private boolean fourPixelCorrectionInFooter = false;
    private long offsetToFourPixels;
    private long fourPixelOffsetInFrame;
    private int fourPixelCorrectionLine;
    private long fourPixelCorrectionOffset;
    private long currentStreamPosition;
    private long frameFooterSize;
    private List<String> companionFiles = new ArrayList<String>();
    private String[] uniqueFiles;

    public DCIMGReader() {
        super("Hamamatsu DCIMG", "dcimg");
        this.suffixSufficient = false;
        this.domains = new String[]{"Unknown"};
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 1;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        return this.uniqueFiles;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        String desc = stream.readString(5);
        return desc.equals("DCIMG");
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        int zp = no / this.getSizeT();
        int tp = no % this.getSizeT();
        try (RandomAccessInputStream stream = new RandomAccessInputStream(this.uniqueFiles[zp]);){
            stream.order(true);
            int byteFactor = FormatTools.getBytesPerPixel(this.getPixelType());
            if (this.version >= 0x1000000L) {
                stream.seek(this.headerSize + this.dataOffset + (long)tp * (this.bytesPerImage + this.frameFooterSize) + (long)(byteFactor * y * this.getSizeX()));
            } else {
                stream.seek(this.headerSize + this.dataOffset + (long)tp * this.bytesPerImage + (long)(byteFactor * y * this.getSizeX()));
            }
            for (int row = h2 - 1; row >= 0; --row) {
                if (this.fourPixelCorrectionInFooter && row == this.fourPixelCorrectionLine && x < 4) {
                    this.currentStreamPosition = stream.getFilePointer();
                    stream.seek(this.fourPixelCorrectionOffset + (long)(byteFactor * x));
                    stream.read(buf, byteFactor * row * w, byteFactor * (4 - x));
                    stream.seek(this.currentStreamPosition + (long)(byteFactor * 4));
                    stream.read(buf, byteFactor * (row * w + 4), byteFactor * (w - 4));
                } else {
                    stream.skipBytes(byteFactor * x);
                    stream.read(buf, byteFactor * row * w, byteFactor * w);
                }
                stream.skipBytes(byteFactor * (this.getSizeX() - w - x));
            }
        }
        return buf;
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.in.order(true);
        if (!this.isThisType(this.in)) {
            throw new FormatException("Not a valid DCIMG file.");
        }
        this.in.seek(8L);
        this.version = this.in.readUnsignedInt();
        LOGGER.info("DCIMG Version: {}", (Object)this.version);
        if (this.version != 7L && this.version < 0x1000000L) {
            throw new FormatException(String.format("Unknown DCIMG version number %d.", this.version));
        }
        if (this.version > 0x1000000L) {
            LOGGER.warn(String.format("Your file is DCAM version %d, but only %d is guaranteed to work.", this.version, 0x1000000L));
        }
        this.in.skipBytes(28);
        this.headerSize = this.in.readUnsignedInt();
        this.in.skipBytes(4);
        long fileSize = this.in.readUnsignedInt();
        this.in.skipBytes(12);
        long fileSize2 = this.in.readUnsignedInt();
        if (fileSize != fileSize2) {
            throw new FormatException("Improper header. File sizes do not match.");
        }
        this.in.skipBytes(16);
        CoreMetadata m4 = (CoreMetadata)this.core.get(0);
        m4.dimensionOrder = "XYZCT";
        m4.rgb = false;
        m4.interleaved = false;
        m4.littleEndian = true;
        m4.indexed = false;
        m4.falseColor = false;
        m4.metadataComplete = true;
        m4.thumbnail = false;
        m4.sizeC = 1;
        if (this.version == 7L) {
            this.parseDCAMVersion0Header(this.in);
            this.parseDCAMVersion0Footer(this.in);
        } else if (this.version == 0x1000000L) {
            this.parseDCAMVersion1Header(this.in);
        }
        if (this.pixelType == 1L) {
            m4.pixelType = 1;
        } else if (this.pixelType == 2L) {
            m4.pixelType = 3;
        } else {
            throw new FormatException(String.format("Unknown pixel type %d.", this.pixelType));
        }
        this.fourPixelCorrectionLine = this.getFourPixelCorrectionLine();
        this.fourPixelCorrectionOffset = this.getFourPixelCorrectionOffset();
        if (this.isGroupFiles()) {
            Location currentFile = new Location(id).getAbsoluteFile();
            Location directory = currentFile.getParentFile();
            this.scanDirectory(directory);
        } else {
            String file2 = new Location(id).getAbsolutePath();
            this.companionFiles.add(file2);
        }
        this.uniqueFiles = this.companionFiles.toArray(new String[this.companionFiles.size()]);
        m4.sizeZ = this.uniqueFiles.length;
        m4.imageCount = this.getSizeZ() * this.getSizeT() * this.getSizeC();
        LOGGER.info("sizeX: {} sizeY: {} sizeZ: {} sizeC: {} sizeT: {}", m4.sizeX, m4.sizeY, m4.sizeZ, m4.sizeC, m4.sizeT);
        this.addGlobalMeta("Version", this.version);
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        this.in.close();
    }

    private void scanDirectory(Location dir) throws FormatException, IOException {
        Object[] files = dir.list(true);
        if (files == null) {
            return;
        }
        Arrays.sort(files);
        for (Object f : files) {
            String file2 = new Location(dir, (String)f).getAbsolutePath();
            LOGGER.info("Checking file {}", (Object)file2);
            this.addFileToList(file2);
        }
    }

    private void addFileToList(String file2) throws FormatException, IOException {
        if (!DCIMGReader.checkSuffix(file2, "dcimg")) {
            LOGGER.warn("File {} failed extension check. Does not end in 'dcimg'.", (Object)file2);
            return;
        }
        try (RandomAccessInputStream stream = new RandomAccessInputStream(file2);){
            if (!this.isThisType(stream)) {
                LOGGER.warn("File {} is not DCIMG.", (Object)file2);
                return;
            }
            this.companionFiles.add(file2);
        }
    }

    private void parseDCAMVersion0Header(RandomAccessInputStream stream) throws IOException {
        CoreMetadata m4 = (CoreMetadata)this.core.get(0);
        stream.seek(this.headerSize);
        stream.skipBytes(32);
        m4.sizeT = stream.readInt();
        this.pixelType = stream.readInt();
        stream.skipBytes(4);
        m4.sizeX = stream.readInt();
        this.bytesPerRow = stream.readUnsignedInt();
        m4.sizeY = stream.readInt();
        this.bytesPerImage = stream.readUnsignedInt();
        stream.skipBytes(8);
        this.dataOffset = stream.readInt();
        this.offsetToFooter = stream.readLong();
    }

    private void parseDCAMVersion1Header(RandomAccessInputStream stream) throws IOException {
        CoreMetadata m4 = (CoreMetadata)this.core.get(0);
        stream.seek(this.headerSize);
        stream.skipBytes(60);
        m4.sizeT = stream.readInt();
        this.pixelType = stream.readInt();
        stream.skipBytes(4);
        m4.sizeX = stream.readInt();
        m4.sizeY = stream.readInt();
        stream.skipBytes(4);
        this.bytesPerImage = stream.readUnsignedInt();
        stream.skipBytes(8);
        this.dataOffset = stream.readLong();
        stream.skipBytes(20);
        this.frameFooterSize = stream.readUnsignedInt();
    }

    private void parseDCAMVersion0Footer(RandomAccessInputStream stream) throws IOException, FormatException {
        long footerOffset = this.headerSize + this.offsetToFooter;
        stream.seek(footerOffset);
        long footerVersion = stream.readUnsignedInt();
        if (this.version != footerVersion) {
            throw new FormatException(String.format("Header DCIMG version %d does not match footer version %d.", footerVersion, this.version));
        }
        stream.skipBytes(4);
        long secondFooterOffset = stream.readLong();
        stream.seek(footerOffset + secondFooterOffset);
        stream.skipBytes(88);
        this.offsetToFourPixels = stream.readLong();
        stream.skipBytes(4);
        this.fourPixelOffsetInFrame = stream.readUnsignedInt();
        long fourPixelSize = stream.readLong();
        if (fourPixelSize > 0L) {
            this.fourPixelCorrectionInFooter = true;
        }
    }

    private int getFourPixelCorrectionLine() {
        if (this.version == 7L) {
            if (this.fourPixelCorrectionInFooter) {
                return (int)(this.fourPixelOffsetInFrame / this.bytesPerRow + 1L);
            }
            return this.getSizeY() - 1;
        }
        if (this.version == 0x1000000L) {
            if (this.frameFooterSize >= 512L | this.frameFooterSize == 32L) {
                this.fourPixelCorrectionInFooter = true;
            }
            if (this.getSizeY() % 2 == 0) {
                return this.getSizeY() / 2;
            }
            return this.getSizeY() / 2 + 1;
        }
        return 0;
    }

    private long getFourPixelCorrectionOffset() {
        if (this.version == 7L) {
            return this.headerSize + this.offsetToFooter + this.offsetToFourPixels;
        }
        return this.headerSize + this.dataOffset + this.bytesPerImage + 12L;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.version = 0L;
            this.headerSize = 0L;
            this.dataOffset = 0L;
            this.pixelType = 0L;
            this.bytesPerImage = 0L;
            this.bytesPerRow = 0L;
            this.offsetToFooter = 0L;
            this.fourPixelCorrectionInFooter = false;
            this.offsetToFourPixels = 0L;
            this.fourPixelOffsetInFrame = 0L;
            this.fourPixelCorrectionLine = 0;
            this.fourPixelCorrectionOffset = 0L;
            this.currentStreamPosition = 0L;
            this.frameFooterSize = 0L;
            this.companionFiles.clear();
            this.uniqueFiles = null;
        }
    }
}

