/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.write;

import com.google.common.base.Preconditions;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Formatter;
import java.util.StringTokenizer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.jdom2.Element;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDatasets;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.Indent;
import ucar.nc2.write.CDLWriter;
import ucar.nc2.write.NcmlWriter;

@Immutable
public class Ncdump {
    private final NetcdfFile ncfile;
    private final WantValues wantValues;
    private final boolean ncml;
    private final boolean strict;
    private final String varNames;
    private final String locationName;
    private final CancelTask cancelTask;
    private static String usage = "usage: Ncdump <filename> [-cdl | -ncml] [-c | -vall] [-v varName1;varName2;..] [-v varName(0:1,:,12)]\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ncdump(String command, Writer out, CancelTask ct) throws IOException {
        StringTokenizer stoke = new StringTokenizer(command);
        if (!stoke.hasMoreTokens()) {
            out.write(usage);
            return;
        }
        String filename = stoke.nextToken();
        try (NetcdfFile nc = NetcdfDatasets.openFile(filename, ct);){
            int pos = command.indexOf(filename);
            command = command.substring(pos + filename.length());
            Ncdump.ncdump(nc, command, out, ct);
        }
        catch (FileNotFoundException e) {
            out.write("file not found= ");
            out.write(filename);
        }
        finally {
            out.close();
        }
    }

    public static void ncdump(NetcdfFile nc, String command, Writer out, CancelTask ct) throws IOException {
        WantValues showValues = WantValues.none;
        Builder builder = Ncdump.builder(nc).setCancelTask(ct);
        if (command != null) {
            StringTokenizer stoke = new StringTokenizer(command);
            while (stoke.hasMoreTokens()) {
                String toke = stoke.nextToken();
                if (toke.equalsIgnoreCase("-help")) {
                    out.write(usage);
                    out.write(10);
                    return;
                }
                if (toke.equalsIgnoreCase("-vall")) {
                    showValues = WantValues.all;
                }
                if (toke.equalsIgnoreCase("-c") && showValues == WantValues.none) {
                    showValues = WantValues.coordsOnly;
                }
                if (toke.equalsIgnoreCase("-ncml")) {
                    builder.setNcml(true);
                }
                if (toke.equalsIgnoreCase("-cdl") || toke.equalsIgnoreCase("-strict")) {
                    builder.setStrict(true);
                }
                if (toke.equalsIgnoreCase("-v") && stoke.hasMoreTokens()) {
                    builder.setVarNames(stoke.nextToken());
                }
                if (!toke.equalsIgnoreCase("-datasetname") || !stoke.hasMoreTokens()) continue;
                builder.setLocationName(stoke.nextToken());
            }
        }
        builder.setWantValues(showValues);
        out.write(builder.build().print());
        out.flush();
    }

    public static Builder builder(NetcdfFile ncfile) {
        return new Builder(ncfile);
    }

    private Ncdump(Builder builder) {
        this.ncfile = builder.ncfile;
        this.wantValues = builder.wantValues;
        this.ncml = builder.ncml;
        this.strict = builder.strict;
        this.varNames = builder.varNames;
        this.locationName = builder.locationName;
        this.cancelTask = builder.cancelTask;
    }

    public String print() {
        Formatter out;
        block16: {
            boolean headerOnly = this.wantValues == WantValues.none && this.varNames == null;
            out = new Formatter();
            try {
                if (this.ncml) {
                    return Ncdump.writeNcml(this.ncfile, this.wantValues, this.locationName);
                }
                if (headerOnly) {
                    CDLWriter.writeCDL(this.ncfile, out, this.strict, this.locationName);
                    break block16;
                }
                Indent indent = new Indent(2);
                CDLWriter cdlWriter = new CDLWriter(this.ncfile, out, this.strict);
                cdlWriter.toStringStart(indent, this.strict, this.locationName);
                indent.incr();
                out.format("%n%sdata:%n", indent);
                indent.incr();
                if (this.wantValues == WantValues.all) {
                    for (Variable v : this.ncfile.getVariables()) {
                        Ncdump.printArray(out, v.read(), v.getFullName(), indent, this.cancelTask);
                        if (this.cancelTask == null || !this.cancelTask.isCancel()) continue;
                        return out.toString();
                    }
                } else if (this.wantValues == WantValues.coordsOnly) {
                    for (Variable v : this.ncfile.getVariables()) {
                        if (v.isCoordinateVariable()) {
                            Ncdump.printArray(out, v.read(), v.getFullName(), indent, this.cancelTask);
                        }
                        if (this.cancelTask == null || !this.cancelTask.isCancel()) continue;
                        return out.toString();
                    }
                }
                if (this.wantValues != WantValues.all && this.varNames != null) {
                    StringTokenizer stoke = new StringTokenizer(this.varNames, ";");
                    while (stoke.hasMoreTokens()) {
                        String varSubset = stoke.nextToken();
                        if (varSubset.indexOf(40) >= 0) {
                            Array data = this.ncfile.readSection(varSubset);
                            Ncdump.printArray(out, data, varSubset, indent, this.cancelTask);
                        } else {
                            Variable v = this.ncfile.findVariable(varSubset);
                            if (v == null) {
                                out.format(" cant find variable: %s%n   %s", varSubset, usage);
                                continue;
                            }
                            if (this.wantValues != WantValues.coordsOnly || v.isCoordinateVariable()) {
                                Ncdump.printArray(out, v.read(), v.getFullName(), indent, this.cancelTask);
                            }
                        }
                        if (this.cancelTask == null || !this.cancelTask.isCancel()) continue;
                        return out.toString();
                    }
                }
                indent.decr();
                indent.decr();
                cdlWriter.toStringEnd();
            }
            catch (Exception e) {
                out.format("%n%s%n", e.getMessage());
            }
        }
        return out.toString();
    }

    public static String printVariableData(Variable v, CancelTask ct) throws IOException {
        Array data = v.read();
        Formatter out = new Formatter();
        Ncdump.printArray(out, data, v.getFullName(), new Indent(2), ct);
        return out.toString();
    }

    private static String printVariableDataSection(Variable v, String sectionSpec, CancelTask ct) throws IOException, InvalidRangeException {
        Array data = v.read(sectionSpec);
        Formatter out = new Formatter();
        Ncdump.printArray(out, data, v.getFullName(), new Indent(2), ct);
        return out.toString();
    }

    public static String printArrayPlain(Array ma) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ma.resetLocalIterator();
        while (ma.hasNext()) {
            pw.print(ma.next());
            pw.print(' ');
        }
        return sw.toString();
    }

    public static String printArray(Array ma) {
        return Ncdump.printArray(ma, "", null);
    }

    public static String printArray(Array array, String name, CancelTask ct) {
        Formatter out = new Formatter();
        Ncdump.printArray(out, array, name, null, new Indent(2), ct, true);
        return out.toString();
    }

    private static void printArray(Formatter out, Array array, String name, Indent indent, CancelTask ct) {
        Ncdump.printArray(out, array, name, null, indent, ct, true);
        out.flush();
    }

    private static void printArray(Formatter out, Array array, String name, String units, Indent ilev, CancelTask ct, boolean printSeq) {
        if (ct != null && ct.isCancel()) {
            return;
        }
        if (name != null) {
            out.format("%s%s = ", ilev, name);
        }
        ilev.incr();
        if (array == null) {
            out.format("null array for %s", name);
            ilev.decr();
            return;
        }
        if (array instanceof ArrayChar && array.getRank() > 0) {
            Ncdump.printStringArray(out, (ArrayChar)array, ilev, ct);
        } else if (array.getElementType() == String.class) {
            Ncdump.printStringArray(out, array, ilev, ct);
        } else if (array instanceof ArraySequence) {
            if (printSeq) {
                Ncdump.printSequence(out, (ArraySequence)array, ilev, ct);
            }
        } else if (array instanceof ArrayStructure) {
            Ncdump.printStructureDataArray(out, (ArrayStructure)array, ilev, ct);
        } else if (array.getElementType() == ByteBuffer.class) {
            array.resetLocalIterator();
            while (array.hasNext()) {
                Ncdump.printByteBuffer(out, (ByteBuffer)array.next(), ilev);
                out.format("%s%n", array.hasNext() ? "," : ";");
                if (ct == null || !ct.isCancel()) continue;
                return;
            }
        } else if (array instanceof ArrayObject) {
            Ncdump.printVariableArray(out, (ArrayObject)array, ilev, ct);
        } else {
            Ncdump.printArray(out, array, ilev, ct);
        }
        if (units != null) {
            out.format(" %s", units);
        }
        out.format("%n", new Object[0]);
        ilev.decr();
        out.flush();
    }

    private static void printArray(Formatter out, Array ma, Indent indent, CancelTask ct) {
        if (ct != null && ct.isCancel()) {
            return;
        }
        int rank = ma.getRank();
        Index ima = ma.getIndex();
        if (rank == 0) {
            Object value = ma.getObject(ima);
            if (ma.isUnsigned()) {
                assert (value instanceof Number) : "A data type being unsigned implies that it is numeric.";
                value = DataType.widenNumberIfNegative((Number)value);
            }
            out.format("%s", value);
            return;
        }
        int[] dims = ma.getShape();
        int last = dims[0];
        out.format("%n%s{", indent);
        if (rank == 1 && ma.getElementType() != StructureData.class) {
            for (int ii = 0; ii < last; ++ii) {
                Object value = ma.getObject(ima.set(ii));
                if (ma.isUnsigned()) {
                    assert (value instanceof Number) : "A data type being unsigned implies that it is numeric.";
                    value = DataType.widenNumberIfNegative((Number)value);
                }
                if (ii > 0) {
                    out.format(", ", new Object[0]);
                }
                out.format("%s", value);
                if (ct == null || !ct.isCancel()) continue;
                return;
            }
            out.format("}", new Object[0]);
            return;
        }
        indent.incr();
        for (int ii = 0; ii < last; ++ii) {
            Array slice = ma.slice(0, ii);
            if (ii > 0) {
                out.format(",", new Object[0]);
            }
            Ncdump.printArray(out, slice, indent, ct);
            if (ct == null || !ct.isCancel()) continue;
            return;
        }
        indent.decr();
        out.format("%n%s}", indent);
    }

    private static void printStringArray(Formatter out, ArrayChar ma, Indent indent, CancelTask ct) {
        if (ct != null && ct.isCancel()) {
            return;
        }
        int rank = ma.getRank();
        if (rank == 1) {
            out.format("  \"%s\"", ma.getString());
            return;
        }
        if (rank == 2) {
            boolean first = true;
            ArrayChar.StringIterator iter = ma.getStringIterator();
            while (iter.hasNext()) {
                if (!first) {
                    out.format(", ", new Object[0]);
                }
                out.format("  \"%s\"", iter.next());
                first = false;
                if (ct == null || !ct.isCancel()) continue;
                return;
            }
            return;
        }
        int[] dims = ma.getShape();
        int last = dims[0];
        out.format("%n%s{", indent);
        indent.incr();
        for (int ii = 0; ii < last; ++ii) {
            ArrayChar slice = (ArrayChar)ma.slice(0, ii);
            if (ii > 0) {
                out.format(",", new Object[0]);
            }
            Ncdump.printStringArray(out, slice, indent, ct);
            if (ct == null || !ct.isCancel()) continue;
            return;
        }
        indent.decr();
        out.format("%n%s}", indent);
    }

    private static void printByteBuffer(Formatter out, ByteBuffer bb, Indent indent) {
        out.format("%s0x", indent);
        int last = bb.limit() - 1;
        if (last < 0) {
            out.format("00", new Object[0]);
        } else {
            for (int i = bb.position(); i <= last; ++i) {
                out.format("%02x", bb.get(i));
            }
        }
    }

    private static void printStringArray(Formatter out, Array ma, Indent indent, CancelTask ct) {
        if (ct != null && ct.isCancel()) {
            return;
        }
        int rank = ma.getRank();
        Index ima = ma.getIndex();
        if (rank == 0) {
            out.format("  \"%s\"", ma.getObject(ima));
            return;
        }
        if (rank == 1) {
            boolean first = true;
            int i = 0;
            while ((long)i < ma.getSize()) {
                if (!first) {
                    out.format(", ", new Object[0]);
                }
                out.format("  \"%s\"", ma.getObject(ima.set(i)));
                first = false;
                ++i;
            }
            return;
        }
        int[] dims = ma.getShape();
        int last = dims[0];
        out.format("%n%s{", indent);
        indent.incr();
        for (int ii = 0; ii < last; ++ii) {
            Array slice = ma.slice(0, ii);
            if (ii > 0) {
                out.format(",", new Object[0]);
            }
            Ncdump.printStringArray(out, slice, indent, ct);
        }
        indent.decr();
        out.format("%n%s}", indent);
    }

    private static void printStructureDataArray(Formatter out, ArrayStructure array, Indent indent, CancelTask ct) {
        try (StructureDataIterator sdataIter = array.getStructureDataIterator();){
            int count = 0;
            while (sdataIter.hasNext()) {
                StructureData sdata = sdataIter.next();
                out.format("%n%s{", indent);
                Ncdump.printStructureData(out, sdata, indent, ct);
                out.format("%s} %s(%d)", indent, sdata.getName(), count);
                if (ct != null && ct.isCancel()) {
                    return;
                }
                ++count;
            }
        }
        catch (IOException ioe) {
            out.format("%n%s%n", ioe.getMessage());
        }
    }

    private static void printVariableArray(Formatter out, ArrayObject array, Indent indent, CancelTask ct) {
        out.format("%n%s{", indent);
        indent.incr();
        IndexIterator iter = array.getIndexIterator();
        boolean first = true;
        while (iter.hasNext()) {
            Array data = (Array)iter.next();
            if (!first) {
                out.format(", ", new Object[0]);
            }
            Ncdump.printArray(out, data, indent, ct);
            first = false;
        }
        indent.decr();
        out.format("%n%s}", indent);
    }

    private static void printSequence(Formatter out, ArraySequence seq, Indent indent, CancelTask ct) {
        try (StructureDataIterator iter = seq.getStructureDataIterator();){
            while (iter.hasNext()) {
                StructureData sdata = iter.next();
                out.format("%n%s{", indent);
                Ncdump.printStructureData(out, sdata, indent, ct);
                out.format("%s} %s", indent, sdata.getName());
                if (ct == null || !ct.isCancel()) continue;
                return;
            }
        }
        catch (IOException ioe) {
            out.format("%n%s%n", ioe.getMessage());
        }
    }

    public static String printStructureData(StructureData sdata) {
        Formatter out = new Formatter();
        for (StructureMembers.Member m4 : sdata.getMembers()) {
            Array memData = sdata.getArray(m4);
            if (memData instanceof ArrayChar) {
                out.format("%s", ((ArrayChar)memData).getString());
            } else {
                Ncdump.printArray(out, memData, null, null, new Indent(2), null, true);
            }
            out.format(",", new Object[0]);
        }
        return out.toString();
    }

    private static void printStructureData(Formatter out, StructureData sdata, Indent indent, CancelTask ct) {
        indent.incr();
        for (StructureMembers.Member m4 : sdata.getMembers()) {
            Array sdataArray = sdata.getArray(m4);
            Ncdump.printArray(out, sdataArray, m4.getName(), m4.getUnitsString(), indent, ct, true);
            if (ct == null || !ct.isCancel()) continue;
            return;
        }
        indent.decr();
    }

    private static String writeNcml(NetcdfFile ncfile, WantValues showValues, @Nullable String url) {
        Predicate<? super Variable> writeVarsPred;
        Preconditions.checkNotNull(ncfile);
        Preconditions.checkNotNull(showValues);
        switch (showValues) {
            case none: {
                writeVarsPred = NcmlWriter.writeNoVariablesPredicate;
                break;
            }
            case coordsOnly: {
                writeVarsPred = NcmlWriter.writeCoordinateVariablesPredicate;
                break;
            }
            case all: {
                writeVarsPred = NcmlWriter.writeAllVariablesPredicate;
                break;
            }
            default: {
                String message = String.format("CAN'T HAPPEN: showValues (%s) != null and checked all possible enum values.", new Object[]{showValues});
                throw new AssertionError((Object)message);
            }
        }
        NcmlWriter ncmlWriter = new NcmlWriter(null, null, writeVarsPred);
        Element netcdfElement = ncmlWriter.makeNetcdfElement(ncfile, url);
        return ncmlWriter.writeToString(netcdfElement);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println(usage);
            return;
        }
        String filename = args[0];
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8));
             NetcdfFile nc = NetcdfDatasets.openFile(filename, null);){
            StringBuilder command = new StringBuilder();
            for (int i = 1; i < args.length; ++i) {
                command.append(args[i]);
                command.append(" ");
            }
            Ncdump.ncdump(nc, command.toString(), writer, null);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static class Builder {
        private NetcdfFile ncfile;
        private WantValues wantValues = WantValues.none;
        private boolean ncml;
        private boolean strict;
        private String varNames;
        @Nullable
        private String locationName;
        private CancelTask cancelTask;

        private Builder(NetcdfFile ncfile) {
            this.ncfile = ncfile;
        }

        public Builder setShowAllValues() {
            this.wantValues = WantValues.all;
            return this;
        }

        public Builder setShowCoordValues() {
            this.wantValues = WantValues.coordsOnly;
            return this;
        }

        public Builder setLocationName(String locationName) {
            if (locationName != null && !locationName.isEmpty()) {
                this.locationName = locationName;
            }
            return this;
        }

        public Builder setWantValues(WantValues wantValues) {
            this.wantValues = wantValues;
            return this;
        }

        public Builder setNcml(boolean ncml) {
            this.ncml = ncml;
            return this;
        }

        public Builder setStrict(boolean strict) {
            this.strict = strict;
            return this;
        }

        public Builder setVarNames(String varNames) {
            this.varNames = varNames;
            return this;
        }

        public Builder setCancelTask(CancelTask cancelTask) {
            this.cancelTask = cancelTask;
            return this;
        }

        public Ncdump build() {
            return new Ncdump(this);
        }
    }

    public static enum WantValues {
        none,
        coordsOnly,
        all;

    }
}

