/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.reflect;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class ProxyGenerator {
    static void generate(Class c, PrintStream out) throws SecurityException {
        String proxyName = c.getName() + "Proxy";
        out.println();
        out.println("public class " + proxyName + " extends " + c.getName() + "{");
        out.println("  private " + c.getName() + " proxy;\n");
        out.println("  public " + proxyName + " ( " + c.getName() + " proxy) {");
        out.println("    this.proxy = proxy;");
        out.println("  }\n");
        ArrayList allMethods = new ArrayList();
        ProxyGenerator.addAllMethods(allMethods, c);
        allMethods.sort(new MethodComparator());
        for (Object allMethod : allMethods) {
            ProxyGenerator.genMethod((Method)allMethod, out);
        }
        out.println("}");
    }

    private static void addAllMethods(ArrayList allMethods, Class c) {
        if (c == null) {
            return;
        }
        if (c == Object.class) {
            return;
        }
        Method[] methodsArray = c.getDeclaredMethods();
        allMethods.addAll(Arrays.asList(methodsArray));
        ProxyGenerator.addAllMethods(allMethods, c.getSuperclass());
    }

    static void genMethod(Method m4, PrintStream out) throws SecurityException {
        int i;
        int mods = m4.getModifiers();
        if (Modifier.isFinal(mods) || Modifier.isPrivate(mods) || Modifier.isStatic(mods)) {
            return;
        }
        out.print("  " + Modifier.toString(mods));
        out.print(" " + m4.getReturnType().getName());
        out.print(" " + m4.getName() + "(");
        Class<?>[] params = m4.getParameterTypes();
        for (int i2 = 0; i2 < params.length; ++i2) {
            if (i2 > 0) {
                out.print(", ");
            }
            out.print(ProxyGenerator.makeClassName(params[i2]) + " p" + i2);
        }
        out.print(")");
        Class<?>[] ex = m4.getExceptionTypes();
        if (ex.length > 0) {
            out.print(" throws ");
            for (i = 0; i < ex.length; ++i) {
                if (i > 0) {
                    out.print(", ");
                }
                out.print(ex[i].getName());
            }
        }
        out.println(" {");
        out.print("    ");
        if (!m4.getReturnType().getName().equals("void")) {
            out.print("return ");
        }
        out.print("proxy." + m4.getName() + "(");
        for (i = 0; i < params.length; ++i) {
            if (i > 0) {
                out.print(",");
            }
            out.print(" p" + i);
        }
        out.println(");");
        out.println("  }\n");
    }

    static String makeClassName(Class c) {
        if (c.isArray()) {
            return ProxyGenerator.makeClassName(c.getComponentType()) + "[]";
        }
        return c.getName();
    }

    public static void showMethods(Class c, PrintStream out) {
        Method[] methodsArray;
        out.println("Methods for class " + c.getName());
        for (Method m4 : methodsArray = c.getDeclaredMethods()) {
            System.out.println(" " + m4.getName());
        }
    }

    public static class MethodComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Method t1 = (Method)o1;
            Method t2 = (Method)o2;
            return t1.getName().compareTo(t2.getName());
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }
    }
}

