/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.remote;

import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.point.PointCollectionImpl;
import ucar.nc2.ft.point.PointIteratorEmpty;
import ucar.nc2.ft.point.remote.PointIteratorStream;
import ucar.nc2.ft.point.remote.PointStream;
import ucar.nc2.ft.point.remote.PointStreamProto;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamProto;
import ucar.nc2.time.CalendarDateUnit;

public abstract class PointCollectionStreamAbstract
extends PointCollectionImpl {
    private static final Logger logger = LoggerFactory.getLogger(PointCollectionStreamAbstract.class);
    private boolean needUnits;

    public PointCollectionStreamAbstract(String name) {
        super(name, CalendarDateUnit.unixDateUnit, null);
        this.needUnits = true;
    }

    public PointCollectionStreamAbstract(String name, CalendarDateUnit timeUnit, String altUnits) {
        super(name, timeUnit, altUnits);
        this.needUnits = false;
    }

    public abstract InputStream getInputStream() throws IOException;

    @Override
    public PointFeatureIterator getPointFeatureIterator() throws IOException {
        InputStream in = this.getInputStream();
        boolean leaveStreamOpen = false;
        try {
            PointStream.MessageType mtype = PointStream.readMagic(in);
            if (mtype == PointStream.MessageType.PointFeatureCollection) {
                int len = NcStream.readVInt(in);
                byte[] data = new byte[len];
                NcStream.readFully(in, data);
                PointStreamProto.PointFeatureCollection pfc = PointStreamProto.PointFeatureCollection.parseFrom(data);
                if (this.needUnits) {
                    try {
                        this.altUnits = !pfc.getAltUnit().isEmpty() ? pfc.getAltUnit() : null;
                        this.timeUnit = CalendarDateUnit.of(null, pfc.getTimeUnit());
                    }
                    catch (IllegalArgumentException e) {
                        String message = String.format("Invalid time unit found in stream (%s). Using default (%s).", pfc.getTimeUnit(), this.timeUnit.getUdUnit());
                        logger.error(message, e);
                    }
                    this.needUnits = false;
                }
                PointIteratorStream iter = new PointIteratorStream(this, in, new PointStream.ProtobufPointFeatureMaker(pfc));
                leaveStreamOpen = true;
                PointIteratorStream pointIteratorStream = iter;
                return pointIteratorStream;
            }
            if (mtype == PointStream.MessageType.End) {
                PointIteratorEmpty len = new PointIteratorEmpty();
                return len;
            }
            if (mtype == PointStream.MessageType.Error) {
                int len = NcStream.readVInt(in);
                byte[] data = new byte[len];
                NcStream.readFully(in, data);
                NcStreamProto.Error proto = NcStreamProto.Error.parseFrom(data);
                throw new IOException(NcStream.decodeErrorMessage(proto));
            }
            throw new IOException("Illegal pointstream message type= " + (Object)((Object)mtype));
        }
        finally {
            if (!leaveStreamOpen) {
                in.close();
            }
        }
    }
}

