/*
 * Decompiled with CFR 0.152.
 */
package org.perf4j.aop;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.context.HashMapContext;
import org.perf4j.LoggingStopWatch;
import org.perf4j.aop.AbstractJoinPoint;
import org.perf4j.aop.Profiled;

public class AgnosticTimingAspect {
    private Map<String, Expression> jexlExpressionCache = new ConcurrentHashMap<String, Expression>(64, 0.75f, 16);

    public Object runProfiledMethod(AbstractJoinPoint joinPoint, Profiled profiled, LoggingStopWatch stopWatch) throws Throwable {
        String message;
        String tag;
        Object object;
        block6: {
            if (!stopWatch.isLogging()) {
                return joinPoint.proceed();
            }
            stopWatch.setTimeThreshold(profiled.timeThreshold());
            stopWatch.setNormalAndSlowSuffixesEnabled(profiled.normalAndSlowSuffixesEnabled());
            Object retVal = null;
            Throwable exceptionThrown = null;
            try {
                object = retVal = joinPoint.proceed();
                tag = this.getStopWatchTag(profiled, joinPoint, retVal, exceptionThrown);
                message = this.getStopWatchMessage(profiled, joinPoint, retVal, exceptionThrown);
                if (!profiled.logFailuresSeparately()) break block6;
                tag = exceptionThrown == null ? tag + ".success" : tag + ".failure";
            }
            catch (Throwable t2) {
                try {
                    exceptionThrown = t2;
                    throw exceptionThrown;
                }
                catch (Throwable throwable) {
                    String tag2 = this.getStopWatchTag(profiled, joinPoint, retVal, exceptionThrown);
                    String message2 = this.getStopWatchMessage(profiled, joinPoint, retVal, exceptionThrown);
                    if (profiled.logFailuresSeparately()) {
                        tag2 = exceptionThrown == null ? tag2 + ".success" : tag2 + ".failure";
                    }
                    stopWatch.stop(tag2, message2);
                    throw throwable;
                }
            }
        }
        stopWatch.stop(tag, message);
        return object;
    }

    protected String getStopWatchTag(Profiled profiled, AbstractJoinPoint joinPoint, Object returnValue, Throwable exceptionThrown) {
        String tag = "@@USE_METHOD_NAME".equals(profiled.tag()) ? joinPoint.getMethodName() : (profiled.el() && profiled.tag().indexOf("{") >= 0 ? this.evaluateJexl(profiled.tag(), joinPoint.getParameters(), joinPoint.getExecutingObject(), returnValue, exceptionThrown) : profiled.tag());
        return tag;
    }

    protected String getStopWatchMessage(Profiled profiled, AbstractJoinPoint joinPoint, Object returnValue, Throwable exceptionThrown) {
        String message;
        if (profiled.el() && profiled.message().indexOf("{") >= 0) {
            message = this.evaluateJexl(profiled.message(), joinPoint.getParameters(), joinPoint.getExecutingObject(), returnValue, exceptionThrown);
            if ("".equals(message)) {
                message = null;
            }
        } else {
            message = "".equals(profiled.message()) ? null : profiled.message();
        }
        return message;
    }

    protected String evaluateJexl(String text, Object[] args, Object annotatedObject, Object returnValue, Throwable exceptionThrown) {
        int bracketIndex;
        StringBuilder retVal = new StringBuilder(text.length());
        HashMapContext jexlContext = new HashMapContext();
        for (int i = 0; i < args.length; ++i) {
            jexlContext.getVars().put("$" + i, args[i]);
        }
        jexlContext.getVars().put("$this", annotatedObject);
        jexlContext.getVars().put("$return", returnValue);
        jexlContext.getVars().put("$exception", exceptionThrown);
        int lastCloseBracketIndex = -1;
        while ((bracketIndex = text.indexOf(123, lastCloseBracketIndex + 1)) >= 0) {
            String expressionText;
            retVal.append(text.substring(lastCloseBracketIndex + 1, bracketIndex));
            lastCloseBracketIndex = text.indexOf(125, bracketIndex + 1);
            if (lastCloseBracketIndex == -1) {
                lastCloseBracketIndex = text.length();
            }
            if ((expressionText = text.substring(bracketIndex + 1, lastCloseBracketIndex)).length() <= 0) continue;
            try {
                Object result = this.getJexlExpression(expressionText).evaluate((JexlContext)jexlContext);
                retVal.append(result);
            }
            catch (Exception e) {
                retVal.append("_EL_ERROR_");
            }
        }
        if (lastCloseBracketIndex < text.length()) {
            retVal.append(text.substring(lastCloseBracketIndex + 1, text.length()));
        }
        return retVal.toString();
    }

    protected Expression getJexlExpression(String expressionText) throws Exception {
        Expression retVal = this.jexlExpressionCache.get(expressionText);
        if (retVal == null) {
            retVal = ExpressionFactory.createExpression((String)expressionText);
            this.jexlExpressionCache.put(expressionText, retVal);
        }
        return retVal;
    }
}

