/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.ode;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.commons.math.ode.DerivativeException;
import org.apache.commons.math.ode.StepInterpolator;

public abstract class AbstractStepInterpolator
implements StepInterpolator {
    protected double previousTime;
    protected double currentTime;
    protected double h;
    protected double[] currentState;
    protected double interpolatedTime;
    protected double[] interpolatedState;
    private boolean finalized;
    private boolean forward;

    protected AbstractStepInterpolator() {
        this.previousTime = Double.NaN;
        this.currentTime = Double.NaN;
        this.h = Double.NaN;
        this.interpolatedTime = Double.NaN;
        this.currentState = null;
        this.interpolatedState = null;
        this.finalized = false;
        this.forward = true;
    }

    protected AbstractStepInterpolator(double[] y, boolean forward) {
        this.previousTime = Double.NaN;
        this.currentTime = Double.NaN;
        this.h = Double.NaN;
        this.interpolatedTime = Double.NaN;
        this.currentState = y;
        this.interpolatedState = new double[y.length];
        this.finalized = false;
        this.forward = forward;
    }

    protected AbstractStepInterpolator(AbstractStepInterpolator interpolator) {
        this.previousTime = interpolator.previousTime;
        this.currentTime = interpolator.currentTime;
        this.h = interpolator.h;
        this.interpolatedTime = interpolator.interpolatedTime;
        if (interpolator.currentState != null) {
            this.currentState = (double[])interpolator.currentState.clone();
            this.interpolatedState = (double[])interpolator.interpolatedState.clone();
        } else {
            this.currentState = null;
            this.interpolatedState = null;
        }
        this.finalized = interpolator.finalized;
        this.forward = interpolator.forward;
    }

    protected void reinitialize(double[] y, boolean forward) {
        this.previousTime = Double.NaN;
        this.currentTime = Double.NaN;
        this.h = Double.NaN;
        this.interpolatedTime = Double.NaN;
        this.currentState = y;
        this.interpolatedState = new double[y.length];
        this.finalized = false;
        this.forward = forward;
    }

    public StepInterpolator copy() throws DerivativeException {
        this.finalizeStep();
        return this.doCopy();
    }

    protected abstract StepInterpolator doCopy();

    public void shift() {
        this.previousTime = this.currentTime;
    }

    public void storeTime(double t2) {
        this.currentTime = t2;
        this.h = this.currentTime - this.previousTime;
        this.interpolatedTime = t2;
        System.arraycopy(this.currentState, 0, this.interpolatedState, 0, this.currentState.length);
        this.finalized = false;
    }

    public double getPreviousTime() {
        return this.previousTime;
    }

    public double getCurrentTime() {
        return this.currentTime;
    }

    public double getInterpolatedTime() {
        return this.interpolatedTime;
    }

    public void setInterpolatedTime(double time) throws DerivativeException {
        this.interpolatedTime = time;
        double oneMinusThetaH = this.currentTime - this.interpolatedTime;
        this.computeInterpolatedState((this.h - oneMinusThetaH) / this.h, oneMinusThetaH);
    }

    public boolean isForward() {
        return this.forward;
    }

    protected abstract void computeInterpolatedState(double var1, double var3) throws DerivativeException;

    public double[] getInterpolatedState() {
        return (double[])this.interpolatedState.clone();
    }

    public final void finalizeStep() throws DerivativeException {
        if (!this.finalized) {
            this.doFinalize();
            this.finalized = true;
        }
    }

    protected void doFinalize() throws DerivativeException {
    }

    public abstract void writeExternal(ObjectOutput var1) throws IOException;

    public abstract void readExternal(ObjectInput var1) throws IOException;

    protected void writeBaseExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.currentState.length);
        out.writeDouble(this.previousTime);
        out.writeDouble(this.currentTime);
        out.writeDouble(this.h);
        out.writeBoolean(this.forward);
        for (int i = 0; i < this.currentState.length; ++i) {
            out.writeDouble(this.currentState[i]);
        }
        out.writeDouble(this.interpolatedTime);
        try {
            this.finalizeStep();
        }
        catch (DerivativeException e) {
            throw new IOException(e.getMessage());
        }
    }

    protected double readBaseExternal(ObjectInput in) throws IOException {
        int dimension = in.readInt();
        this.previousTime = in.readDouble();
        this.currentTime = in.readDouble();
        this.h = in.readDouble();
        this.forward = in.readBoolean();
        this.currentState = new double[dimension];
        for (int i = 0; i < this.currentState.length; ++i) {
            this.currentState[i] = in.readDouble();
        }
        this.interpolatedTime = Double.NaN;
        this.interpolatedState = new double[dimension];
        this.finalized = true;
        return in.readDouble();
    }
}

