/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.AbstractIntegerDistribution;
import org.apache.commons.math.distribution.PascalDistribution;
import org.apache.commons.math.special.Beta;
import org.apache.commons.math.util.MathUtils;

public class PascalDistributionImpl
extends AbstractIntegerDistribution
implements PascalDistribution,
Serializable {
    private static final long serialVersionUID = 6751309484392813623L;
    private int numberOfSuccesses;
    private double probabilityOfSuccess;

    public PascalDistributionImpl(int r, double p) {
        this.setNumberOfSuccesses(r);
        this.setProbabilityOfSuccess(p);
    }

    public int getNumberOfSuccesses() {
        return this.numberOfSuccesses;
    }

    public double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    public void setNumberOfSuccesses(int successes) {
        if (successes < 0) {
            throw new IllegalArgumentException("number of successes must be non-negative.");
        }
        this.numberOfSuccesses = successes;
    }

    public void setProbabilityOfSuccess(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("probability of success must be between 0.0 and 1.0, inclusive.");
        }
        this.probabilityOfSuccess = p;
    }

    protected int getDomainLowerBound(double p) {
        return -1;
    }

    protected int getDomainUpperBound(double p) {
        return 0x7FFFFFFE;
    }

    public double cumulativeProbability(int x) throws MathException {
        double ret = x < 0 ? 0.0 : Beta.regularizedBeta(this.getProbabilityOfSuccess(), this.getNumberOfSuccesses(), x + 1);
        return ret;
    }

    public double probability(int x) {
        double ret = x < 0 ? 0.0 : MathUtils.binomialCoefficientDouble(x + this.getNumberOfSuccesses() - 1, this.getNumberOfSuccesses() - 1) * Math.pow(this.getProbabilityOfSuccess(), this.getNumberOfSuccesses()) * Math.pow(1.0 - this.getProbabilityOfSuccess(), x);
        return ret;
    }

    public int inverseCumulativeProbability(double p) throws MathException {
        int ret = p == 0.0 ? -1 : (p == 1.0 ? Integer.MAX_VALUE : super.inverseCumulativeProbability(p));
        return ret;
    }
}

