/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.Timestamp;

public class BrukerReader
extends FormatReader {
    private static final String DATE_FORMAT = "HH:mm:ss  d MMM yyyy";
    private ArrayList<String> pixelsFiles = new ArrayList();
    private ArrayList<String> allFiles = new ArrayList();
    private int lastSeries = -1;
    private RandomAccessInputStream seriesStream;
    private String[] sizes = null;
    private String[] ordering = null;
    private int ni = 0;
    private int nr = 0;
    private int ns = 0;
    private int bits = 0;
    private boolean signed = false;
    private boolean isFloat = false;
    private String[] imageNames = null;
    private String[] institutions = null;
    private String[] users = null;
    private String[] timestamps = null;

    public BrukerReader() {
        super("Bruker", "");
        this.suffixSufficient = false;
        this.domains = new String[]{"Medical Imaging"};
        this.hasCompanionFiles = true;
        this.datasetDescription = "One 'fid' and one 'acqp' plus several other metadata files and a 'pdata' directory";
    }

    @Override
    public int getRequiredDirectories(String[] files) throws FormatException, IOException {
        return 1;
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        Location file2 = new Location(name).getAbsoluteFile();
        return file2.getName().equals("fid") || file2.getName().equals("acqp");
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return false;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        long offset;
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        if (this.getSeries() != this.lastSeries) {
            if (this.seriesStream != null) {
                this.seriesStream.close();
            }
            this.seriesStream = new RandomAccessInputStream(this.pixelsFiles.get(this.getSeries()));
            this.lastSeries = this.getSeries();
        }
        if ((offset = (long)no * (long)FormatTools.getPlaneSize(this)) < this.seriesStream.length()) {
            this.seriesStream.seek(offset);
            this.readPlane(this.seriesStream, x, y, w, h2, buf);
        }
        return buf;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        String dir = this.pixelsFiles.get(this.getSeries());
        Location realDir = new Location(dir).getParentFile();
        realDir = realDir.getParentFile();
        realDir = realDir.getParentFile();
        dir = realDir.getAbsolutePath();
        ArrayList<String> files = new ArrayList<String>();
        files.add(new Location(this.getCurrentFile()).getAbsolutePath());
        for (String f : this.allFiles) {
            if (!f.startsWith(dir) || f.endsWith("2dseq") && noPixels || files.contains(f)) continue;
            files.add(f);
        }
        return files.toArray(new String[files.size()]);
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelsFiles.clear();
            this.allFiles.clear();
            this.lastSeries = -1;
            if (this.seriesStream != null) {
                this.seriesStream.close();
            }
            this.seriesStream = null;
            this.sizes = null;
            this.ordering = null;
            this.ni = 0;
            this.nr = 0;
            this.ns = 0;
            this.bits = 0;
            this.signed = false;
            this.isFloat = false;
            this.imageNames = null;
            this.institutions = null;
            this.users = null;
            this.timestamps = null;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        Location originalFile = new Location(id).getAbsoluteFile();
        Location parent = originalFile.getParentFile().getParentFile();
        String[] acquisitionDirs = parent.list(true);
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                Integer i1 = 0;
                try {
                    i1 = Integer.parseInt(s1);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                Integer i2 = 0;
                try {
                    i2 = Integer.parseInt(s2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return i1.compareTo(i2);
            }
        };
        Arrays.sort(acquisitionDirs, comparator);
        ArrayList<String> acqpFiles = new ArrayList<String>();
        ArrayList<String> recoFiles = new ArrayList<String>();
        ArrayList<String> procFiles = new ArrayList<String>();
        for (String f : acquisitionDirs) {
            String[] files;
            Location dir = new Location(parent, f);
            if (!dir.isDirectory()) continue;
            for (String file2 : files = dir.list(true)) {
                String[] moreFiles;
                Location child = new Location(dir, file2);
                if (!child.isDirectory()) {
                    this.allFiles.add(child.getAbsolutePath());
                    if (!file2.equals("acqp")) continue;
                    acqpFiles.add(child.getAbsolutePath());
                    continue;
                }
                Location grandchild = new Location(child, "1");
                if (!grandchild.exists()) continue;
                for (String m4 : moreFiles = grandchild.list(true)) {
                    Location ggc = new Location(grandchild, m4);
                    if (ggc.isDirectory()) continue;
                    this.allFiles.add(ggc.getAbsolutePath());
                    if (m4.equals("2dseq")) {
                        this.pixelsFiles.add(ggc.getAbsolutePath());
                        continue;
                    }
                    if (m4.equals("reco")) {
                        recoFiles.add(ggc.getAbsolutePath());
                        continue;
                    }
                    if (!m4.equals("d3proc")) continue;
                    procFiles.add(ggc.getAbsolutePath());
                }
            }
            if (acqpFiles.size() > this.pixelsFiles.size()) {
                acqpFiles.remove(acqpFiles.size() - 1);
            }
            if (recoFiles.size() > this.pixelsFiles.size()) {
                recoFiles.remove(recoFiles.size() - 1);
            }
            if (procFiles.size() <= this.pixelsFiles.size()) continue;
            procFiles.remove(procFiles.size() - 1);
        }
        this.imageNames = new String[this.pixelsFiles.size()];
        this.timestamps = new String[this.pixelsFiles.size()];
        this.institutions = new String[this.pixelsFiles.size()];
        this.users = new String[this.pixelsFiles.size()];
        this.core.clear();
        for (int series = 0; series < this.pixelsFiles.size(); ++series) {
            int zs;
            this.sizes = null;
            this.ordering = null;
            this.ns = 0;
            this.nr = 0;
            this.ni = 0;
            this.bits = 0;
            this.signed = false;
            this.isFloat = false;
            RandomAccessInputStream s2 = new RandomAccessInputStream(this.pixelsFiles.get(series), 1);
            long pixelsFileSize = s2.length();
            s2.close();
            CoreMetadata ms = new CoreMetadata();
            this.core.add(ms);
            this.setSeries(series);
            String acqData = DataTools.readFile((String)acqpFiles.get(series));
            String[] lines = acqData.split("\n");
            this.parseLines(lines);
            String recoData = DataTools.readFile((String)recoFiles.get(series));
            lines = recoData.split("\n");
            this.parseLines(lines);
            boolean parsedProcFile = false;
            if (series < procFiles.size()) {
                String procData = DataTools.readFile((String)procFiles.get(series));
                lines = procData.split("\n");
                this.parseLines(lines);
                parsedProcFile = true;
            }
            ms.pixelType = FormatTools.pixelTypeFromBytes(this.bits / 8, this.signed, this.isFloat);
            if (parsedProcFile && this.getSizeZ() * this.getSizeT() != this.nr * this.ni && (this.ni > 1 || this.nr > 1 || this.ns > 1)) {
                this.ni = 1;
                this.nr = 1;
                this.ns = 1;
            } else {
                ms.sizeX = 0;
                ms.sizeY = 0;
                ms.sizeZ = 0;
                ms.sizeT = 0;
            }
            int td = Integer.parseInt(this.sizes[0]);
            int ys = this.sizes.length > 1 ? Integer.parseInt(this.sizes[1]) : 0;
            int n = zs = this.sizes.length > 2 ? Integer.parseInt(this.sizes[2]) : 0;
            if (this.getSizeY() == 0 || this.getSizeZ() == 0) {
                if (this.sizes.length == 2) {
                    if (this.ni == 1) {
                        ms.sizeY = ys;
                        ms.sizeZ = this.nr;
                    } else {
                        ms.sizeY = ys;
                        ms.sizeZ = this.ni;
                    }
                } else if (this.sizes.length == 3) {
                    ms.sizeY = this.ni * ys;
                    ms.sizeZ = this.nr * zs;
                }
            }
            if (this.getSizeX() == 0) {
                ms.sizeX = td;
            }
            if (this.getSizeT() == 0) {
                ms.sizeZ /= this.ns;
                ms.sizeT = this.ns * this.nr;
            }
            ms.sizeC = 1;
            ms.imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
            ms.dimensionOrder = "XYCTZ";
            ms.rgb = false;
            ms.interleaved = false;
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        for (int series = 0; series < this.getSeriesCount(); ++series) {
            store.setImageName(this.imageNames[series] + " #" + (series + 1), series);
            String date = DateTools.formatDate(this.timestamps[series], DATE_FORMAT);
            if (date != null) {
                store.setImageAcquisitionDate(new Timestamp(date), series);
            }
            String expID = MetadataTools.createLSID("Experimenter", series);
            store.setExperimenterID(expID, series);
            store.setExperimenterLastName(this.users[series], series);
            store.setExperimenterInstitution(this.institutions[series], series);
            store.setImageExperimenterRef(expID, series);
        }
    }

    private void parseLines(String[] lines) {
        CoreMetadata ms = (CoreMetadata)this.core.get(this.getCoreIndex());
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            int index = line.indexOf("=");
            if (index < 0) continue;
            String key = line.substring(0, index);
            String value = line.substring(index + 1);
            if (value.startsWith("(") && (value = lines[i + 1].trim()).startsWith("<")) {
                value = value.substring(1, value.length() - 1);
            }
            if (key.length() < 4) continue;
            this.addSeriesMeta(key.substring(3), value);
            if (key.equals("##$NI")) {
                this.ni = Integer.parseInt(value);
                continue;
            }
            if (key.equals("##$NR")) {
                this.nr = Integer.parseInt(value);
                continue;
            }
            if (key.equals("##$ACQ_word_size")) {
                this.bits = Integer.parseInt(value.substring(1, value.lastIndexOf("_")));
                continue;
            }
            if (key.equals("##$BYTORDA")) {
                ms.littleEndian = value.toLowerCase().equals("little");
                continue;
            }
            if (key.equals("##$ACQ_size")) {
                this.sizes = value.split(" ");
                continue;
            }
            if (key.equals("##$ACQ_obj_order")) {
                this.ordering = value.split(" ");
                continue;
            }
            if (key.equals("##$ACQ_time")) {
                this.timestamps[this.series] = value;
                continue;
            }
            if (key.equals("##$ACQ_institution")) {
                this.institutions[this.series] = value;
                continue;
            }
            if (key.equals("##$ACQ_operator")) {
                this.users[this.series] = value;
                continue;
            }
            if (key.equals("##$ACQ_scan_name")) {
                this.imageNames[this.series] = value;
                continue;
            }
            if (key.equals("##$ACQ_ns_list_size")) {
                this.ns = Integer.parseInt(value);
                continue;
            }
            if (key.equals("##$RECO_size")) {
                this.sizes = value.split(" ");
                continue;
            }
            if (key.equals("##$RECO_wordtype")) {
                this.bits = Integer.parseInt(value.substring(1, value.indexOf("BIT")));
                this.signed = value.indexOf("_SGN_") >= 0;
                this.isFloat = !value.endsWith("_INT");
                continue;
            }
            if (key.equals("##$IM_SIX")) {
                ms.sizeX = Integer.parseInt(value);
                continue;
            }
            if (key.equals("##$IM_SIY")) {
                ms.sizeY = Integer.parseInt(value);
                continue;
            }
            if (key.equals("##$IM_SIZ")) {
                ms.sizeZ = Integer.parseInt(value);
                continue;
            }
            if (!key.equals("##$IM_SIT")) continue;
            ms.sizeT = Integer.parseInt(value);
        }
    }
}

