/*
 * Decompiled with CFR 0.152.
 */
package view5d;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.LookUpTable;
import ij.WindowManager;
import ij.gui.GUI;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.plugin.frame.PlugInFrame;
import ij.process.ImageProcessor;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.MenuBar;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import view5d.ANGenericDialog;
import view5d.AnElement;
import view5d.ImgPanel;
import view5d.My3DData;

public class View5D_
extends PlugInFrame
implements PlugIn,
WindowListener {
    public static String VersionString = "unknown";
    int previousId;
    ImagePlus imp;
    ImageProcessor ip;
    My3DData data3d;
    TextArea myLabel;
    MenuBar IJMenu;
    Vector<ImgPanel> panels = new Vector();
    String[] DimensionChoices = new String[]{"ZCT", "CZT", "ZTC", "TZC", "CTZ", "TCZ"};
    String[] AppendChoices = new String[]{"Color", "Time"};
    boolean AspectFromData = false;
    public int SizeX = 0;
    public int SizeY = 0;
    public int SizeZ = 0;
    public int Elements = 1;
    public int Times = 1;
    public int DimensionOrder = 0;
    public int AppendTo = 0;

    public String getVersion() {
        try {
            URL resourceUrl = View5D_.class.getResource(View5D_.class.getSimpleName() + ".class");
            JarURLConnection connection = (JarURLConnection)resourceUrl.openConnection();
            Manifest manifest = connection.getManifest();
            Attributes mainAttrs = manifest.getMainAttributes();
            if (mainAttrs == null) {
                return null;
            }
            return mainAttrs.getValue("Implementation-Version");
        }
        catch (IOException E) {
            return "unkown version";
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.data3d.cleanup();
        this.removeAll();
        System.gc();
        this.dispose();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        this.setVisible(true);
    }

    public void UpdatePanels() {
        for (int i = 0; i < this.panels.size(); ++i) {
            this.panels.elementAt((int)i).c1.UpdateAllNoCoord();
        }
    }

    void ImportDialog() {
        ANGenericDialog md = new ANGenericDialog("Import Data");
        md.addChoice("Dimension Order", this.DimensionChoices, this.DimensionChoices[this.DimensionOrder]);
        md.addMessage("Size X: " + this.SizeX + ", Size Y: " + this.SizeY);
        md.addNumericFields("SliceCount, Size Z: ", this.SizeZ, 3, 3);
        md.addNumericFields("TimeCount, Numer of Timepoints: ", this.Times, 3, 3);
        md.addNumericFields("Colors: ", this.Elements, 3, 3);
        if (this.data3d != null) {
            md.addChoice("append along", this.AppendChoices, this.AppendChoices[this.AppendTo]);
        }
        md.addCheckbox("Lock Aspects with data scaling", this.AspectFromData);
        md.showDialog();
        if (!md.wasCanceled()) {
            this.DimensionOrder = md.getNextChoiceIndex();
            this.SizeZ = (int)md.getNextNumber();
            this.Times = (int)md.getNextNumber();
            this.Elements = (int)md.getNextNumber();
            if (this.data3d != null) {
                this.AppendTo = md.getNextChoiceIndex();
            }
            this.AspectFromData = md.getNextBoolean();
        }
    }

    public boolean LoadImg(int NumZ) {
        int redEl = -1;
        int greenEl = -1;
        int blueEl = -1;
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            return false;
        }
        this.ip = this.imp.getProcessor();
        ImageStack ims = this.imp.getImageStack();
        this.SizeX = ims.getWidth();
        this.SizeY = ims.getHeight();
        if (NumZ > 0) {
            this.SizeZ = 1;
            this.Elements = ims.getSize();
        } else {
            this.SizeZ = ims.getSize();
            if (this.SizeZ > 1) {
                int SizeZ2 = 1;
                try {
                    SizeZ2 = this.imp.getNSlices();
                    this.Times = this.imp.getNFrames();
                    this.Elements = this.SizeZ / (SizeZ2 * this.Times);
                    this.SizeZ = SizeZ2;
                }
                catch (Exception e) {
                    SizeZ2 = (int)IJ.getNumber((String)"SliceCount unknown while importing stack. Number of slices: ", (double)this.SizeZ);
                    this.Times = this.SizeZ / SizeZ2;
                    if (this.Times > 1) {
                        this.Times = (int)IJ.getNumber((String)"TimeCount unknown while importing stack. Number of times: ", (double)this.Times);
                    }
                    this.Elements = this.SizeZ / (SizeZ2 * this.Times);
                    this.SizeZ = SizeZ2;
                }
            }
        }
        this.DimensionOrder = 1;
        if (this.SizeZ > 1 || this.Elements > 1 || this.Times > 1 || this.data3d != null) {
            this.ImportDialog();
        }
        int HistoX = 0;
        int HistoY = -1;
        int HistoZ = -1;
        int DataType = AnElement.ByteType;
        int NumBytes = 1;
        int NumBits = 8;
        int ImageType = this.imp.getType();
        switch (ImageType) {
            case 3: {
                DataType = AnElement.ByteType;
                NumBytes = 1;
                NumBits = 8;
                break;
            }
            case 4: {
                DataType = AnElement.ByteType;
                NumBytes = 1;
                NumBits = 8;
                this.Elements = 3;
                break;
            }
            case 0: {
                DataType = AnElement.ByteType;
                NumBytes = 1;
                NumBits = 8;
                break;
            }
            case 1: {
                DataType = AnElement.UnsignedShortType;
                NumBytes = 2;
                NumBits = 16;
                break;
            }
            case 2: {
                DataType = AnElement.FloatType;
                NumBytes = 4;
                NumBits = 32;
            }
        }
        double[] Scales = new double[5];
        for (int j = 0; j < 5; ++j) {
            Scales[j] = 1.0;
        }
        double[] Offsets = new double[5];
        for (int j = 0; j < 5; ++j) {
            Offsets[j] = 0.0;
        }
        double ScaleV = 1.0;
        double OffsetV = 0.0;
        String[] Names = new String[5];
        String[] Units = new String[5];
        Names[0] = "X";
        Names[1] = "Y";
        Names[2] = "Z";
        Names[3] = "Elements";
        Names[4] = "Time";
        Units[0] = "pixels";
        Units[1] = "ypixels";
        Units[2] = "zpixels";
        Units[3] = "elements";
        Units[4] = "time";
        String NameV = "intensity";
        String UnitV = "a.u.";
        Calibration myCal = this.imp.getCalibration();
        if (myCal.scaled()) {
            Scales[0] = myCal.pixelWidth;
            Scales[1] = myCal.pixelHeight;
            Scales[2] = myCal.pixelDepth;
            Offsets[0] = myCal.xOrigin;
            Offsets[1] = myCal.yOrigin;
            Offsets[2] = myCal.zOrigin;
            if (myCal.getUnits() != "") {
                Units[0] = myCal.getUnits();
                Units[1] = myCal.getUnits();
                Units[2] = myCal.getUnits();
            }
            if (myCal.frameInterval != 0.0 && Scales[2] == 0.0) {
                Scales[2] = myCal.frameInterval;
                Units[2] = "seconds";
            }
        }
        if (myCal.calibrated()) {
            NameV = "calib. int.";
            UnitV = myCal.getValueUnit();
            OffsetV = myCal.getCValue(0);
            ScaleV = myCal.getCValue(1.0) - OffsetV;
        }
        if (this.data3d == null) {
            if (this.Elements > 1) {
                redEl = 0;
                greenEl = 1;
            }
            if (this.Elements > 2) {
                blueEl = 2;
            }
            if (this.Elements >= 5) {
                redEl = -1;
                greenEl = -1;
                blueEl = -1;
            }
            this.data3d = new My3DData((Container)((Object)this), this.SizeX, this.SizeY, this.SizeZ, this.Elements, this.Times, redEl, greenEl, blueEl, HistoX, HistoY, HistoZ, DataType, NumBytes, NumBits, Scales, Offsets, ScaleV, OffsetV, Names, Units);
            this.data3d.DimensionOrder = this.DimensionOrder;
            this.data3d.AppendTo = this.AppendTo;
            for (int e = 0; e < this.Elements; ++e) {
                this.data3d.SetValueScale(e, ScaleV, OffsetV, NameV, UnitV);
            }
        } else {
            if (this.SizeX != this.data3d.SizeX || this.SizeY != this.data3d.SizeY || this.SizeZ != this.data3d.SizeZ) {
                IJ.error((String)"New image to load does not correspond in size! ...Not loading it.");
                System.out.println("Error! Size of new image to load does not correspond to old image\n");
                return false;
            }
            if (this.AppendTo == 0) {
                for (int i = 0; i < this.Elements; ++i) {
                    int nr = this.data3d.GenerateNewElement(DataType, NumBytes, NumBits, Scales, Offsets, ScaleV, OffsetV, Names, Units);
                    this.data3d.SetValueScale(nr, ScaleV, OffsetV, NameV, UnitV);
                }
            } else {
                for (int i = 0; i < this.Times; ++i) {
                }
                this.panels.elementAt(0).CheckScrollBar();
            }
        }
        this.data3d.SetUp(DataType, this, this.Elements, this.Times, ImageType);
        if (this.Elements == 1 && this.data3d.Elements <= 3 && this.data3d.Elements > 1) {
            this.data3d.ActiveElement = 0;
            this.data3d.MarkChannel(0);
            this.data3d.MarkAsHistoDim(0);
            this.data3d.ActiveElement = 1;
            this.data3d.MarkChannel(1);
            this.data3d.MarkAsHistoDim(1);
            if (this.data3d.Elements == 3) {
                this.data3d.ActiveElement = 2;
                this.data3d.MarkChannel(2);
            }
        }
        if (this.data3d.Elements > 1 && this.data3d.Elements < 5 || redEl >= 0) {
            this.data3d.elementsLinked = false;
            this.data3d.ToggleColor(true);
        } else {
            this.data3d.elementsLinked = true;
            this.data3d.ToggleColor(false);
        }
        this.data3d.AdjustThresh();
        if (this.data3d.HistoY < 0 && this.data3d.Elements > 1) {
            this.data3d.HistoY = 1;
        }
        if (!this.panels.isEmpty()) {
            this.CheckforLUT();
            this.VerifyAspect();
        }
        return true;
    }

    public void CheckforLUT() {
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            return;
        }
        int ImageType = this.imp.getType();
        LookUpTable lt = this.imp.createLut();
        if (ImageType == 3 || ImageType != 4 && !lt.isGrayscale() || this.imp.isInvertedLut()) {
            int lastLUT = this.data3d.AddLookUpTable(lt.getMapSize(), lt.getReds(), lt.getGreens(), lt.getBlues(), 0);
            NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
            String LUTName = "User defined " + nf.format(lastLUT - 15 + 1);
            this.panels.firstElement().c1.label.PixDisplay.AddColorMenu(LUTName, lastLUT);
            this.data3d.SetColorModelNr(this.data3d.ActiveElement, lastLUT);
            if (!this.data3d.SetThresh(0.0, lt.getMapSize() - 1)) {
                this.data3d.InvalidateSlices();
            }
        }
    }

    public void VerifyAspect() {
        if (this.AspectFromData) {
            System.out.println("Locking Aspects\n");
            for (int i = 0; i < this.panels.size(); ++i) {
                this.panels.elementAt((int)i).c1.AspectFromView = true;
                this.panels.elementAt((int)i).c2.AspectFromView = true;
                this.panels.elementAt((int)i).c3.AspectFromView = true;
                this.panels.elementAt((int)i).c1.AspectLocked.setState(true);
                this.panels.elementAt((int)i).c2.AspectLocked.setState(true);
                this.panels.elementAt((int)i).c3.AspectLocked.setState(true);
            }
        }
    }

    public View5D_() {
        super("5D Viewer");
        VersionString = this.getVersion();
        this.data3d = null;
        if (!this.LoadImg(0)) {
            IJ.showMessage((String)"Error: View5D needs a loaded image in ImageJ, when starting!");
            return;
        }
        ImgPanel mypan = new ImgPanel((Container)((Object)this), this.data3d);
        this.panels.addElement(mypan);
        this.CheckforLUT();
        this.VerifyAspect();
        this.setLayout(new BorderLayout());
        this.add("Center", mypan);
        this.myLabel = new TextArea("5D-viewer Java Applet by Rainer Heintzmann, [press '?' for help]", 1, 76, 3);
        this.add("North", this.myLabel);
        mypan.CheckScrollBar();
        this.setMenuBar(mypan.MyMenu);
        mypan.InitScaling();
        this.addWindowListener(this);
        this.pack();
        GUI.center((Window)((Object)this));
        this.setVisible(true);
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize((int)(size.getWidth() / 2.0), (int)(size.getHeight() / 1.5));
        this.repaint();
    }

    public ImagePlus GetImp() {
        return this.imp;
    }

    public ImageProcessor GetIp() {
        return this.ip;
    }

    void showAbout() {
        IJ.showMessage((String)("About View5D, Version V" + this.getVersion()), (String)" 5D-Viewer by Rainer Heintzmann\nUniversity of Jena, Jena, Germany and Leibniz Institute of PHotonics Technology, Germany\nheintzmann@googlemail.com\nhttp://www.nanoimaging.de/View5D/\nuse mouse click for changing slices, \ndrag images, zoom by typing 'A' and 'a'\n'next page' and 'prev. page'  for changing perpendicular slice ,\n'<' and '>' for perpendicular magnificaltion\ntype 'i' for init, 'c' for change ColorMap, '1,2' and '3,4' for Threshold");
    }
}

