/*
 * Decompiled with CFR 0.152.
 */
package view5d;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.TextArea;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import view5d.APoint;
import view5d.AlternateViewer;
import view5d.AnElement;
import view5d.Bundle;
import view5d.ByteElement;
import view5d.ComplexElement;
import view5d.DoubleElement;
import view5d.FloatElement;
import view5d.ImageErr;
import view5d.ImgPanel;
import view5d.IntegerElement;
import view5d.My3DData;
import view5d.ShortElement;
import view5d.UnsignedShortElement;

public class View5D
extends Applet {
    static final long serialVersionUID = 2L;
    public int SizeX = 0;
    public int SizeY = 0;
    public int SizeZ = 0;
    public int Elements = 1;
    public int Times = 1;
    int defaultColor0 = -1;
    int redEl = -1;
    int greenEl = -1;
    int blueEl = -1;
    My3DData data3d = null;
    TextArea myLabel;
    ImgPanel mypan = null;
    AlternateViewer aviewer;
    Vector<ImgPanel> panels = new Vector();
    public String filename = null;

    public static Dimension getScreenSize() {
        try {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] gs = ge.getScreenDevices();
            DisplayMode dm = gs[0].getDisplayMode();
            return new Dimension(dm.getWidth(), dm.getHeight());
        }
        catch (Exception e) {
            Dimension size = new Dimension(640, 480);
            return size;
        }
    }

    public String getVersion() {
        try {
            URL resourceUrl = View5D.class.getResource(View5D.class.getSimpleName() + ".class");
            JarURLConnection connection = (JarURLConnection)resourceUrl.openConnection();
            Manifest manifest = connection.getManifest();
            Attributes mainAttrs = manifest.getMainAttributes();
            if (mainAttrs == null) {
                return null;
            }
            return mainAttrs.getValue("Implementation-Version");
        }
        catch (IOException E) {
            return "unkown version";
        }
    }

    public void UpdatePanels() {
        for (int i = 0; i < this.panels.size(); ++i) {
            this.panels.elementAt((int)i).c1.UpdateAllNoCoord();
        }
    }

    public View5D AddElement(byte[] myarray, int SizeX, int SizeY, int SizeZ, int Elements, int Times) {
        int DataType = AnElement.ByteType;
        int NumBytes = 1;
        int NumBits = 8;
        int ne = this.data3d.GenerateNewElement(DataType, NumBytes, NumBits, this.data3d.GetScale(this.data3d.ActiveElement), this.data3d.GetOffset(this.data3d.ActiveElement), 1.0, 0.0, this.data3d.GetAxisNames(), this.data3d.GetAxisUnits());
        for (int t = 0; t < Times; ++t) {
            System.arraycopy(myarray, t * SizeX * SizeY * SizeZ, ((ByteElement)this.data3d.ElementAt((int)ne, (int)t)).myData, 0, SizeX * SizeY * SizeZ);
        }
        this.data3d.GetBundleAt(ne).ToggleOverlayDispl(1);
        Elements = this.data3d.GetNumElements();
        Times = this.data3d.GetNumTimes();
        return this;
    }

    public View5D AddElement(short[] myarray, int SizeX, int SizeY, int SizeZ, int Elements, int Times) {
        int DataType = AnElement.ShortType;
        int NumBytes = 2;
        int NumBits = 16;
        int ne = this.data3d.GenerateNewElement(DataType, NumBytes, NumBits, this.data3d.GetScale(this.data3d.ActiveElement), this.data3d.GetOffset(this.data3d.ActiveElement), 1.0, 0.0, this.data3d.GetAxisNames(), this.data3d.GetAxisUnits());
        for (int t = 0; t < Times; ++t) {
            System.arraycopy(myarray, t * SizeX * SizeY * SizeZ, ((ShortElement)this.data3d.ElementAt((int)ne, (int)t)).myData, 0, SizeX * SizeY * SizeZ);
        }
        this.data3d.GetBundleAt(ne).ToggleOverlayDispl(1);
        Elements = this.data3d.GetNumElements();
        Times = this.data3d.GetNumTimes();
        return this;
    }

    public View5D AddElement(char[] myarray, int SizeX, int SizeY, int SizeZ, int Elements, int Times) {
        int DataType = AnElement.UnsignedShortType;
        int NumBytes = 1;
        int NumBits = 8;
        int ne = this.data3d.GenerateNewElement(DataType, NumBytes, NumBits, this.data3d.GetScale(this.data3d.ActiveElement), this.data3d.GetOffset(this.data3d.ActiveElement), 1.0, 0.0, this.data3d.GetAxisNames(), this.data3d.GetAxisUnits());
        for (int t = 0; t < Times; ++t) {
            System.arraycopy(myarray, t * SizeX * SizeY * SizeZ, ((UnsignedShortElement)this.data3d.ElementAt((int)ne, (int)t)).myData, 0, SizeX * SizeY * SizeZ);
        }
        this.data3d.GetBundleAt(ne).ToggleOverlayDispl(1);
        Elements = this.data3d.GetNumElements();
        Times = this.data3d.GetNumTimes();
        return this;
    }

    public View5D AddElement(float[] myarray, int SizeX, int SizeY, int SizeZ, int Elements, int Times) {
        int DataType = AnElement.FloatType;
        int NumBytes = 4;
        int NumBits = 32;
        int ne = this.data3d.GenerateNewElement(DataType, NumBytes, NumBits, this.data3d.GetScale(this.data3d.ActiveElement), this.data3d.GetOffset(this.data3d.ActiveElement), 1.0, 0.0, this.data3d.GetAxisNames(), this.data3d.GetAxisUnits());
        for (int t = 0; t < Times; ++t) {
            System.arraycopy(myarray, t * SizeX * SizeY * SizeZ, ((FloatElement)this.data3d.ElementAt((int)ne, (int)t)).myData, 0, SizeX * SizeY * SizeZ);
        }
        this.data3d.GetBundleAt(ne).ToggleOverlayDispl(1);
        Elements = this.data3d.GetNumElements();
        Times = this.data3d.GetNumTimes();
        return this;
    }

    public View5D AddElement(double[] myarray, int SizeX, int SizeY, int SizeZ, int Elements, int Times) {
        int DataType = AnElement.DoubleType;
        int NumBytes = 8;
        int NumBits = 64;
        int ne = this.data3d.GenerateNewElement(DataType, NumBytes, NumBits, this.data3d.GetScale(this.data3d.ActiveElement), this.data3d.GetOffset(this.data3d.ActiveElement), 1.0, 0.0, this.data3d.GetAxisNames(), this.data3d.GetAxisUnits());
        for (int t = 0; t < Times; ++t) {
            System.arraycopy(myarray, t * SizeX * SizeY * SizeZ, ((DoubleElement)this.data3d.ElementAt((int)ne, (int)t)).myData, 0, SizeX * SizeY * SizeZ);
        }
        this.data3d.GetBundleAt(ne).ToggleOverlayDispl(1);
        Elements = this.data3d.GetNumElements();
        Times = this.data3d.GetNumTimes();
        return this;
    }

    public View5D AddElementC(float[] myarray, int SizeX, int SizeY, int SizeZ, int Elements, int Times) {
        int DataType = AnElement.ComplexType;
        int NumBytes = 8;
        int NumBits = 64;
        int ne = this.data3d.GenerateNewElement(DataType, NumBytes, NumBits, this.data3d.GetScale(this.data3d.ActiveElement), this.data3d.GetOffset(this.data3d.ActiveElement), 1.0, 0.0, this.data3d.GetAxisNames(), this.data3d.GetAxisUnits());
        for (int t = 0; t < Times; ++t) {
            System.arraycopy(myarray, 2 * t * SizeX * SizeY * SizeZ, ((ComplexElement)this.data3d.ElementAt((int)ne, (int)t)).myData, 0, 2 * SizeX * SizeY * SizeZ);
        }
        this.data3d.GetBundleAt(ne).ToggleOverlayDispl(1);
        Elements = this.data3d.GetNumElements();
        Times = this.data3d.GetNumTimes();
        return this;
    }

    public View5D AddTime(byte[] myarray, int SizeX, int SizeY, int SizeZ, int Elements, int Times) {
        int DataType = AnElement.ByteType;
        int NumBytes = 1;
        int NumBits = 8;
        int nt = this.data3d.GenerateNewTime(DataType, NumBytes, NumBits, this.data3d.GetScale(this.data3d.ActiveElement), this.data3d.GetOffset(this.data3d.ActiveElement), 1.0, 0.0, this.data3d.GetAxisNames(), this.data3d.GetAxisUnits(), Elements);
        for (int e = 0; e < Elements; ++e) {
            System.arraycopy(myarray, e * SizeX * SizeY * SizeZ, ((ByteElement)this.data3d.ElementAt((int)e, (int)nt)).myData, 0, SizeX * SizeY * SizeZ);
        }
        this.mypan.CheckScrollBar();
        if (this.aviewer != null) {
            ((ImgPanel)this.aviewer.mycomponent).CheckScrollBar();
        }
        return this;
    }

    public View5D AddTime(short[] myarray, int SizeX, int SizeY, int SizeZ, int Elements, int Times) {
        int DataType = AnElement.ShortType;
        int NumBytes = 2;
        int NumBits = 16;
        int nt = this.data3d.GenerateNewTime(DataType, NumBytes, NumBits, this.data3d.GetScale(this.data3d.ActiveElement), this.data3d.GetOffset(this.data3d.ActiveElement), 1.0, 0.0, this.data3d.GetAxisNames(), this.data3d.GetAxisUnits(), Elements);
        for (int e = 0; e < Elements; ++e) {
            System.arraycopy(myarray, e * SizeX * SizeY * SizeZ, ((ShortElement)this.data3d.ElementAt((int)e, (int)nt)).myData, 0, SizeX * SizeY * SizeZ);
        }
        this.mypan.CheckScrollBar();
        if (this.aviewer != null) {
            ((ImgPanel)this.aviewer.mycomponent).CheckScrollBar();
        }
        return this;
    }

    public View5D AddTime(char[] myarray, int SizeX, int SizeY, int SizeZ, int Elements, int Times) {
        int DataType = AnElement.UnsignedShortType;
        int NumBytes = 1;
        int NumBits = 8;
        int nt = this.data3d.GenerateNewTime(DataType, NumBytes, NumBits, this.data3d.GetScale(this.data3d.ActiveElement), this.data3d.GetOffset(this.data3d.ActiveElement), 1.0, 0.0, this.data3d.GetAxisNames(), this.data3d.GetAxisUnits(), Elements);
        for (int e = 0; e < Elements; ++e) {
            System.arraycopy(myarray, e * SizeX * SizeY * SizeZ, ((UnsignedShortElement)this.data3d.ElementAt((int)e, (int)nt)).myData, 0, SizeX * SizeY * SizeZ);
        }
        this.mypan.CheckScrollBar();
        if (this.aviewer != null) {
            ((ImgPanel)this.aviewer.mycomponent).CheckScrollBar();
        }
        return this;
    }

    public View5D AddTime(float[] myarray, int SizeX, int SizeY, int SizeZ, int Elements, int Times) {
        int DataType = AnElement.FloatType;
        int NumBytes = 4;
        int NumBits = 32;
        int nt = this.data3d.GenerateNewTime(DataType, NumBytes, NumBits, this.data3d.GetScale(this.data3d.ActiveElement), this.data3d.GetOffset(this.data3d.ActiveElement), 1.0, 0.0, this.data3d.GetAxisNames(), this.data3d.GetAxisUnits(), Elements);
        for (int e = 0; e < Elements; ++e) {
            System.arraycopy(myarray, e * SizeX * SizeY * SizeZ, ((FloatElement)this.data3d.ElementAt((int)e, (int)nt)).myData, 0, SizeX * SizeY * SizeZ);
        }
        this.mypan.CheckScrollBar();
        if (this.aviewer != null) {
            ((ImgPanel)this.aviewer.mycomponent).CheckScrollBar();
        }
        return this;
    }

    public View5D AddTime(double[] myarray, int SizeX, int SizeY, int SizeZ, int Elements, int Times) {
        int DataType = AnElement.DoubleType;
        int NumBytes = 8;
        int NumBits = 64;
        int nt = this.data3d.GenerateNewTime(DataType, NumBytes, NumBits, this.data3d.GetScale(this.data3d.ActiveElement), this.data3d.GetOffset(this.data3d.ActiveElement), 1.0, 0.0, this.data3d.GetAxisNames(), this.data3d.GetAxisUnits(), Elements);
        for (int e = 0; e < Elements; ++e) {
            System.arraycopy(myarray, e * SizeX * SizeY * SizeZ, ((DoubleElement)this.data3d.ElementAt((int)e, (int)nt)).myData, 0, SizeX * SizeY * SizeZ);
        }
        this.mypan.CheckScrollBar();
        if (this.aviewer != null) {
            ((ImgPanel)this.aviewer.mycomponent).CheckScrollBar();
        }
        return this;
    }

    public View5D AddTimeC(float[] myarray, int SizeX, int SizeY, int SizeZ, int Elements, int Times) {
        int DataType = AnElement.ComplexType;
        int NumBytes = 8;
        int NumBits = 64;
        int nt = this.data3d.GenerateNewTime(DataType, NumBytes, NumBits, this.data3d.GetScale(this.data3d.ActiveElement), this.data3d.GetOffset(this.data3d.ActiveElement), 1.0, 0.0, this.data3d.GetAxisNames(), this.data3d.GetAxisUnits(), Elements);
        for (int e = 0; e < Elements; ++e) {
            System.arraycopy(myarray, 2 * e * SizeX * SizeY * SizeZ, ((ComplexElement)this.data3d.ElementAt((int)e, (int)nt)).myData, 0, 2 * SizeX * SizeY * SizeZ);
        }
        this.mypan.CheckScrollBar();
        if (this.aviewer != null) {
            ((ImgPanel)this.aviewer.mycomponent).CheckScrollBar();
        }
        return this;
    }

    public static View5D Start5DViewer(byte[] barray, int SizeX, int SizeY, int SizeZ, int Elements, int Times, int AX, int AY) {
        int DataType = AnElement.ByteType;
        int NumBytes = 1;
        int NumBits = 8;
        View5D anApplet = View5D.Prepare5DViewer(SizeX, SizeY, SizeZ, Elements, Times, DataType, NumBytes, NumBits);
        ((ByteElement)anApplet.data3d.ActElement()).myData = barray;
        anApplet.data3d.ToggleOverlayDispl(1);
        anApplet.aviewer = new AlternateViewer(anApplet, AX, AY);
        for (int t = 0; t < Times; ++t) {
            for (int e = 0; e < Elements; ++e) {
                if (e == 0 && t == 0) {
                    anApplet.aviewer.Assign3DData(anApplet, anApplet.mypan, anApplet.data3d);
                    continue;
                }
                System.arraycopy(barray, (e + Elements * t) * SizeX * SizeY * SizeZ, ((ByteElement)anApplet.data3d.ElementAt((int)e, (int)t)).myData, 0, SizeX * SizeY * SizeZ);
            }
        }
        anApplet.start();
        return anApplet;
    }

    public void minimize() {
        this.aviewer.setState(1);
    }

    public void toFront() {
        this.data3d.InvalidateSlices();
        if (this.aviewer.getState() != 0) {
            this.aviewer.setState(0);
        }
        this.aviewer.setVisible(true);
        this.aviewer.toFront();
        this.aviewer.repaint();
    }

    public void closeAll() {
        this.dispatchEvent(new WindowEvent(this.aviewer, 201));
        this.aviewer.dispose();
        this.stop();
        this.destroy();
    }

    public void SetElementsLinked(boolean doLink) {
        this.data3d.setElementsLinked(doLink);
    }

    public void setTimesLinked(boolean doLink) {
        this.data3d.setTimesLinked(doLink);
    }

    public void SetGamma(int e, double gamma) {
        this.data3d.SetGamma(e, gamma);
    }

    public static View5D Start5DViewerB(byte[] array, int SizeX, int SizeY, int SizeZ, int Elements, int Times, int AX, int AY) {
        return View5D.Start5DViewer(array, SizeX, SizeY, SizeZ, Elements, Times, AX, AY);
    }

    public static View5D Start5DViewer(byte[] array, int SizeX, int SizeY, int SizeZ, int Elements, int Times) {
        Dimension size = View5D.getScreenSize();
        return View5D.Start5DViewer(array, SizeX, SizeY, SizeZ, Elements, Times, (int)(size.getWidth() / 2.0), (int)(size.getHeight() / 1.5));
    }

    public static View5D Start5DViewerB(byte[] array, int SizeX, int SizeY, int SizeZ, int Elements, int Times) {
        Dimension size = View5D.getScreenSize();
        return View5D.Start5DViewer(array, SizeX, SizeY, SizeZ, Elements, Times, (int)(size.getWidth() / 2.0), (int)(size.getHeight() / 1.5));
    }

    @Override
    public void setSize(int width, int height) {
        this.aviewer.setSize(width, height);
    }

    public void ReplaceData(int e, int t, byte[] anarray) {
        int[] sizes = this.data3d.sizes;
        int tsize = sizes[0] * sizes[1] * sizes[2];
        System.arraycopy(anarray, 0, ((ByteElement)this.data3d.ElementAt((int)e, (int)t)).myData, 0, tsize);
    }

    public void ReplaceDataB(int e, int t, byte[] anarray) {
        int[] sizes = this.data3d.sizes;
        int tsize = sizes[0] * sizes[1] * sizes[2];
        System.arraycopy(anarray, 0, ((ByteElement)this.data3d.ElementAt((int)e, (int)t)).myData, 0, tsize);
    }

    public void ReplaceData(int e, int t, double[] anarray) {
        int[] sizes = this.data3d.sizes;
        int tsize = sizes[0] * sizes[1] * sizes[2];
        System.arraycopy(anarray, 0, ((DoubleElement)this.data3d.ElementAt((int)e, (int)t)).myData, 0, tsize);
    }

    public void ReplaceDataD(int e, int t, double[] anarray) {
        int[] sizes = this.data3d.sizes;
        int tsize = sizes[0] * sizes[1] * sizes[2];
        System.arraycopy(anarray, 0, ((DoubleElement)this.data3d.ElementAt((int)e, (int)t)).myData, 0, tsize);
    }

    public void ReplaceData(int e, int t, float[] anarray) {
        int[] sizes = this.data3d.sizes;
        int tsize = sizes[0] * sizes[1] * sizes[2];
        System.arraycopy(anarray, 0, ((FloatElement)this.data3d.ElementAt((int)e, (int)t)).myData, 0, tsize);
    }

    public void ReplaceDataF(int e, int t, float[] anarray) {
        int[] sizes = this.data3d.sizes;
        int tsize = sizes[0] * sizes[1] * sizes[2];
        System.arraycopy(anarray, 0, ((FloatElement)this.data3d.ElementAt((int)e, (int)t)).myData, 0, tsize);
    }

    public void ReplaceData(int e, int t, int[] anarray) {
        int[] sizes = this.data3d.sizes;
        int tsize = sizes[0] * sizes[1] * sizes[2];
        System.arraycopy(anarray, 0, ((IntegerElement)this.data3d.ElementAt((int)e, (int)t)).myData, 0, tsize);
    }

    public void ReplaceDataI(int e, int t, int[] anarray) {
        int[] sizes = this.data3d.sizes;
        int tsize = sizes[0] * sizes[1] * sizes[2];
        System.arraycopy(anarray, 0, ((IntegerElement)this.data3d.ElementAt((int)e, (int)t)).myData, 0, tsize);
    }

    public void ReplaceData(int e, int t, char[] anarray) {
        int[] sizes = this.data3d.sizes;
        int tsize = sizes[0] * sizes[1] * sizes[2];
        System.arraycopy(anarray, 0, ((UnsignedShortElement)this.data3d.ElementAt((int)e, (int)t)).myData, 0, tsize);
    }

    public void ReplaceDataUS(int e, int t, char[] anarray) {
        int[] sizes = this.data3d.sizes;
        int tsize = sizes[0] * sizes[1] * sizes[2];
        System.arraycopy(anarray, 0, ((UnsignedShortElement)this.data3d.ElementAt((int)e, (int)t)).myData, 0, tsize);
    }

    public void ReplaceDataC(int e, int t, float[] anarray) {
        int[] sizes = this.data3d.sizes;
        int tsize = 2 * sizes[0] * sizes[1] * sizes[2];
        System.arraycopy(anarray, 0, ((ComplexElement)this.data3d.ElementAt((int)e, (int)t)).myData, 0, tsize);
    }

    public int getNumElements() {
        return this.data3d.GetNumElements();
    }

    public int getNumTime() {
        return this.data3d.GetNumTimes();
    }

    public static View5D Dummy(byte[] sarray, int SizeX, int SizeY, int SizeZ, int Elements, int Times) {
        int DataType = AnElement.ByteType;
        int NumBytes = 1;
        int NumBits = 8;
        View5D anApplet = View5D.Prepare5DViewer(SizeX, SizeY, SizeZ, 1, 1, DataType, NumBytes, NumBits);
        sarray[0] = 0;
        ((ByteElement)anApplet.data3d.ActElement()).myData = sarray;
        anApplet.data3d.ToggleOverlayDispl(1);
        anApplet.aviewer = new AlternateViewer(anApplet, 600, 600);
        for (int t = 0; t < Times; ++t) {
            for (int e = 0; e < Elements; ++e) {
                if (e == 0 && t == 0) {
                    anApplet.aviewer.Assign3DData(anApplet, anApplet.mypan, anApplet.data3d);
                    continue;
                }
                System.arraycopy(sarray, (e + Elements * t) * SizeX * SizeY * SizeZ, ((ByteElement)anApplet.data3d.ElementAt((int)e, (int)t)).myData, 0, SizeX * SizeY * SizeZ);
            }
        }
        anApplet.start();
        return anApplet;
    }

    public static int DummyI(int sss) {
        return 44;
    }

    public static View5D Start5DViewer(short[] sarray, int SizeX, int SizeY, int SizeZ, int Elements, int Times, int AX, int AY) {
        int DataType = AnElement.ShortType;
        int NumBytes = 2;
        int NumBits = 8;
        View5D anApplet = View5D.Prepare5DViewer(SizeX, SizeY, SizeZ, Elements, Times, DataType, NumBytes, NumBits);
        ((ShortElement)anApplet.data3d.ActElement()).myData = sarray;
        anApplet.data3d.ToggleOverlayDispl(1);
        anApplet.aviewer = new AlternateViewer(anApplet, AX, AY);
        for (int t = 0; t < Times; ++t) {
            for (int e = 0; e < Elements; ++e) {
                if (e == 0 && t == 0) {
                    anApplet.aviewer.Assign3DData(anApplet, anApplet.mypan, anApplet.data3d);
                    continue;
                }
                System.arraycopy(sarray, (e + Elements * t) * SizeX * SizeY * SizeZ, ((ShortElement)anApplet.data3d.ElementAt((int)e, (int)t)).myData, 0, SizeX * SizeY * SizeZ);
            }
        }
        anApplet.start();
        return anApplet;
    }

    public static View5D Start5DViewerS(short[] array, int SizeX, int SizeY, int SizeZ, int Elements, int Times, int AX, int AY) {
        return View5D.Start5DViewer(array, SizeX, SizeY, SizeZ, Elements, Times, AX, AY);
    }

    public static View5D Start5DViewerS(short[] array, int SizeX, int SizeY, int SizeZ, int Elements, int Times) {
        Dimension size = View5D.getScreenSize();
        return View5D.Start5DViewer(array, SizeX, SizeY, SizeZ, Elements, Times, (int)(size.getWidth() / 2.0), (int)(size.getHeight() / 1.5));
    }

    public static View5D Start5DViewer(short[] array, int SizeX, int SizeY, int SizeZ, int Elements, int Times) {
        Dimension size = View5D.getScreenSize();
        return View5D.Start5DViewer(array, SizeX, SizeY, SizeZ, Elements, Times, (int)(size.getWidth() / 2.0), (int)(size.getHeight() / 1.5));
    }

    public static View5D Start5DViewer(char[] sarray, int SizeX, int SizeY, int SizeZ, int Elements, int Times, int AX, int AY) {
        int DataType = AnElement.UnsignedShortType;
        int NumBytes = 2;
        int NumBits = 16;
        View5D anApplet = View5D.Prepare5DViewer(SizeX, SizeY, SizeZ, Elements, Times, DataType, NumBytes, NumBits);
        ((UnsignedShortElement)anApplet.data3d.ActElement()).myData = sarray;
        anApplet.data3d.ToggleOverlayDispl(1);
        anApplet.aviewer = new AlternateViewer(anApplet, AX, AY);
        for (int t = 0; t < Times; ++t) {
            for (int e = 0; e < Elements; ++e) {
                if (e == 0 && t == 0) {
                    anApplet.aviewer.Assign3DData(anApplet, anApplet.mypan, anApplet.data3d);
                    continue;
                }
                System.arraycopy(sarray, (e + Elements * t) * SizeX * SizeY * SizeZ, ((UnsignedShortElement)anApplet.data3d.ElementAt((int)e, (int)t)).myData, 0, SizeX * SizeY * SizeZ);
            }
        }
        anApplet.start();
        return anApplet;
    }

    public static View5D Start5DViewerUS(char[] array, int SizeX, int SizeY, int SizeZ, int Elements, int Times, int AX, int AY) {
        return View5D.Start5DViewer(array, SizeX, SizeY, SizeZ, Elements, Times, AY, AX);
    }

    public static View5D Start5DViewerUS(char[] array, int SizeX, int SizeY, int SizeZ, int Elements, int Times) {
        Dimension size = View5D.getScreenSize();
        return View5D.Start5DViewer(array, SizeX, SizeY, SizeZ, Elements, Times, (int)(size.getWidth() / 2.0), (int)(size.getHeight() / 1.5));
    }

    public static View5D Start5DViewer(char[] array, int SizeX, int SizeY, int SizeZ, int Elements, int Times) {
        Dimension size = View5D.getScreenSize();
        return View5D.Start5DViewer(array, SizeX, SizeY, SizeZ, Elements, Times, (int)(size.getWidth() / 2.0), (int)(size.getHeight() / 1.5));
    }

    public static View5D Start5DViewer(float[] farray, int SizeX, int SizeY, int SizeZ, int Elements, int Times, int AX, int AY) {
        int DataType = AnElement.FloatType;
        int NumBytes = 4;
        int NumBits = 32;
        View5D anApplet = View5D.Prepare5DViewer(SizeX, SizeY, SizeZ, Elements, Times, DataType, NumBytes, NumBits);
        ((FloatElement)anApplet.data3d.ActElement()).myData = farray;
        anApplet.data3d.ToggleOverlayDispl(1);
        anApplet.aviewer = new AlternateViewer(anApplet, AX, AY);
        for (int t = 0; t < Times; ++t) {
            for (int e = 0; e < Elements; ++e) {
                if (e == 0 && t == 0) {
                    anApplet.aviewer.Assign3DData(anApplet, anApplet.mypan, anApplet.data3d);
                    continue;
                }
                System.arraycopy(farray, (e + Elements * t) * SizeX * SizeY * SizeZ, ((FloatElement)anApplet.data3d.ElementAt((int)e, (int)t)).myData, 0, SizeX * SizeY * SizeZ);
            }
        }
        anApplet.start();
        return anApplet;
    }

    public static View5D Start5DViewerF(float[] array, int SizeX, int SizeY, int SizeZ, int Elements, int Times, int AX, int AY) {
        return View5D.Start5DViewer(array, SizeX, SizeY, SizeZ, Elements, Times, AX, AY);
    }

    public static View5D Start5DViewerF(float[] array, int SizeX, int SizeY, int SizeZ, int Elements, int Times) {
        Dimension size = View5D.getScreenSize();
        return View5D.Start5DViewer(array, SizeX, SizeY, SizeZ, Elements, Times, (int)(size.getWidth() / 2.0), (int)(size.getHeight() / 1.5));
    }

    public static View5D Start5DViewer(float[] array, int SizeX, int SizeY, int SizeZ, int Elements, int Times) {
        Dimension size = View5D.getScreenSize();
        return View5D.Start5DViewer(array, SizeX, SizeY, SizeZ, Elements, Times, (int)(size.getWidth() / 2.0), (int)(size.getHeight() / 1.5));
    }

    public static View5D Start5DViewerC(float[] carray, int SizeX, int SizeY, int SizeZ, int Elements, int Times, int AX, int AY) {
        int DataType = AnElement.ComplexType;
        int NumBytes = 8;
        int NumBits = 64;
        View5D anApplet = View5D.Prepare5DViewer(SizeX, SizeY, SizeZ, Elements, Times, DataType, NumBytes, NumBits);
        ((ComplexElement)anApplet.data3d.ActElement()).myData = carray;
        anApplet.data3d.ToggleOverlayDispl(1);
        anApplet.aviewer = new AlternateViewer(anApplet, AX, AY);
        for (int t = 0; t < Times; ++t) {
            for (int e = 0; e < Elements; ++e) {
                if (e == 0 && t == 0) {
                    anApplet.aviewer.Assign3DData(anApplet, anApplet.mypan, anApplet.data3d);
                    continue;
                }
                System.arraycopy(carray, 2 * (e + Elements * t) * SizeX * SizeY * SizeZ, ((ComplexElement)anApplet.data3d.ElementAt((int)e, (int)t)).myData, 0, 2 * SizeX * SizeY * SizeZ);
            }
        }
        anApplet.start();
        return anApplet;
    }

    public static View5D Start5DViewerC(float[] carray, int SizeX, int SizeY, int SizeZ, int Elements, int Times) {
        Dimension size = View5D.getScreenSize();
        return View5D.Start5DViewerC(carray, SizeX, SizeY, SizeZ, Elements, Times, (int)(size.getWidth() / 2.0), (int)(size.getHeight() / 1.5));
    }

    public static View5D Start5DViewer(double[] farray, int SizeX, int SizeY, int SizeZ, int Elements, int Times, int AX, int AY) {
        int DataType = AnElement.DoubleType;
        int NumBytes = 8;
        int NumBits = 64;
        View5D anApplet = View5D.Prepare5DViewer(SizeX, SizeY, SizeZ, Elements, Times, DataType, NumBytes, NumBits);
        ((DoubleElement)anApplet.data3d.ActElement()).myData = farray;
        anApplet.data3d.ToggleOverlayDispl(1);
        anApplet.aviewer = new AlternateViewer(anApplet, AX, AY);
        for (int t = 0; t < Times; ++t) {
            for (int e = 0; e < Elements; ++e) {
                if (e == 0 && t == 0) {
                    anApplet.aviewer.Assign3DData(anApplet, anApplet.mypan, anApplet.data3d);
                    continue;
                }
                System.arraycopy(farray, (e + Elements * t) * SizeX * SizeY * SizeZ, ((DoubleElement)anApplet.data3d.ElementAt((int)e, (int)t)).myData, 0, SizeX * SizeY * SizeZ);
            }
        }
        anApplet.start();
        return anApplet;
    }

    public static View5D Start5DViewerD(double[] array, int SizeX, int SizeY, int SizeZ, int Elements, int Times, int AX, int AY) {
        return View5D.Start5DViewer(array, SizeX, SizeY, SizeZ, Elements, Times, AX, AY);
    }

    public static View5D Start5DViewerD(double[] array, int SizeX, int SizeY, int SizeZ, int Elements, int Times) {
        Dimension size = View5D.getScreenSize();
        return View5D.Start5DViewer(array, SizeX, SizeY, SizeZ, Elements, Times, (int)(size.getWidth() / 2.0), (int)(size.getHeight() / 1.5));
    }

    public static View5D Start5DViewer(double[] array, int SizeX, int SizeY, int SizeZ, int Elements, int Times) {
        Dimension size = View5D.getScreenSize();
        return View5D.Start5DViewer(array, SizeX, SizeY, SizeZ, Elements, Times, (int)(size.getWidth() / 2.0), (int)(size.getHeight() / 1.5));
    }

    public static View5D Start5DViewer(int[] iarray, int SizeX, int SizeY, int SizeZ, int Elements, int Times, int AX, int AY) {
        int DataType = AnElement.IntegerType;
        int NumBytes = 4;
        int NumBits = 32;
        View5D anApplet = View5D.Prepare5DViewer(SizeX, SizeY, SizeZ, Elements, Times, DataType, NumBytes, NumBits);
        ((IntegerElement)anApplet.data3d.ActElement()).myData = iarray;
        anApplet.data3d.ToggleOverlayDispl(1);
        anApplet.aviewer = new AlternateViewer(anApplet, AX, AY);
        for (int t = 0; t < Times; ++t) {
            for (int e = 0; e < Elements; ++e) {
                if (e == 0 && t == 0) {
                    anApplet.aviewer.Assign3DData(anApplet, anApplet.mypan, anApplet.data3d);
                    continue;
                }
                System.arraycopy(iarray, (e + Elements * t) * SizeX * SizeY * SizeZ, ((IntegerElement)anApplet.data3d.ElementAt((int)e, (int)t)).myData, 0, SizeX * SizeY * SizeZ);
            }
        }
        anApplet.start();
        return anApplet;
    }

    public static View5D Start5DViewerI(int[] array, int SizeX, int SizeY, int SizeZ, int Elements, int Times, int AX, int AY) {
        return View5D.Start5DViewer(array, SizeX, SizeY, SizeZ, Elements, Times, AX, AY);
    }

    public static View5D Start5DViewerI(int[] array, int SizeX, int SizeY, int SizeZ, int Elements, int Times) {
        Dimension size = View5D.getScreenSize();
        return View5D.Start5DViewer(array, SizeX, SizeY, SizeZ, Elements, Times, (int)(size.getWidth() / 2.0), (int)(size.getHeight() / 1.5));
    }

    public static View5D Start5DViewer(int[] array, int SizeX, int SizeY, int SizeZ, int Elements, int Times) {
        Dimension size = View5D.getScreenSize();
        return View5D.Start5DViewer(array, SizeX, SizeY, SizeZ, Elements, Times, (int)(size.getWidth() / 2.0), (int)(size.getHeight() / 1.5));
    }

    public void ProcessKeyMainWindow(char myChar) {
        this.mypan.c1.ProcessKey(myChar);
        this.mypan.c1.UpdateAll();
    }

    public void ProcessKeyElementWindow(char myChar) {
        this.mypan.label.PixDisplay.ProcessKey(myChar);
        this.mypan.c1.UpdateAll();
    }

    public void NameElement(int elementNum, String Name2) {
        this.data3d.ElementAt((int)elementNum).NameV = Name2;
    }

    public void setName(int elementNum, String Name2) {
        this.data3d.ElementAt((int)elementNum).NameV = Name2;
    }

    public void setUnit(int elementNum, String Name2) {
        this.data3d.ElementAt((int)elementNum).UnitV = Name2;
    }

    public void setOffsetScale(int elementNum, double offset, double scale) {
        this.data3d.ElementAt((int)elementNum).OffsetV = offset;
        this.data3d.ElementAt((int)elementNum).ScaleV = scale;
    }

    public void setMinMaxThresh(int elementNum, double MinVal, double MaxVal) {
        this.data3d.SetThresh(elementNum, MinVal, MaxVal);
    }

    public void SetAxisScalesAndUnits(int elementNum, int timeNum, double SV, double SX, double SY, double SZ, double SE, double ST, double OV, double OX, double OY, double OZ, double OE, double OT, String NameV, String[] Names, String UnitV, String[] Units) {
        this.data3d.ElementAt((int)elementNum, (int)timeNum).ScaleV = SV;
        this.data3d.ElementAt((int)elementNum, (int)timeNum).Scales[0] = SX;
        this.data3d.ElementAt((int)elementNum, (int)timeNum).Scales[1] = SY;
        this.data3d.ElementAt((int)elementNum, (int)timeNum).Scales[2] = SZ;
        this.data3d.ElementAt((int)elementNum, (int)timeNum).Scales[3] = SE;
        this.data3d.ElementAt((int)elementNum, (int)timeNum).Scales[4] = ST;
        this.data3d.ElementAt((int)elementNum, (int)timeNum).OffsetV = OV;
        this.data3d.ElementAt((int)elementNum, (int)timeNum).Offsets[0] = OX;
        this.data3d.ElementAt((int)elementNum, (int)timeNum).Offsets[1] = OY;
        this.data3d.ElementAt((int)elementNum, (int)timeNum).Offsets[2] = OZ;
        this.data3d.ElementAt((int)elementNum, (int)timeNum).Offsets[3] = OE;
        this.data3d.ElementAt((int)elementNum, (int)timeNum).Offsets[4] = OT;
        this.data3d.ElementAt((int)elementNum, (int)timeNum).Names = Names;
        this.data3d.ElementAt((int)elementNum, (int)timeNum).Units = Units;
        this.data3d.ElementAt((int)elementNum, (int)timeNum).NameV = NameV;
        this.data3d.ElementAt((int)elementNum, (int)timeNum).UnitV = UnitV;
    }

    public void SetAxisScalesAndUnits(double SV, double SX, double SY, double SZ, double SE, double ST, double OV, double OX, double OY, double OZ, double OE, double OT, String NameV, String[] Names, String UnitV, String[] Units) {
        for (int e = 0; e < this.data3d.Elements; ++e) {
            for (int t = 0; t < this.data3d.Times; ++t) {
                this.SetAxisScalesAndUnits(e, t, SV, SX, SY, SZ, SE, ST, OV, OX, OY, OZ, OE, OT, NameV, Names, UnitV, Units);
            }
        }
    }

    public void NameWindow(String Name2) {
        this.aviewer.setTitle(Name2);
    }

    public String ExportMarkers() {
        return this.data3d.MyMarkers.PrintList(this.data3d);
    }

    public double[][] ExportMarkerLists() {
        return this.data3d.MyMarkers.ExportMarkerLists(this.data3d);
    }

    public double[][] ExportMarkers(int list) {
        return this.data3d.MyMarkers.ExportMarkers(list, this.data3d);
    }

    public void ImportMarkerLists(float[][] lists) {
        this.data3d.MyMarkers.ImportMarkerLists(lists);
        this.data3d.InvalidateSlices();
        this.mypan.c1.UpdateAllNoCoord();
    }

    public void DeleteAllMarkerLists() {
        this.data3d.MyMarkers.DeleteAllMarkerLists();
    }

    public void ImportMarkers(float[][] positions, int NumPos) {
        this.ImportMarkers(positions);
    }

    public void ImportMarkers(float[][] positions) {
        this.data3d.NewMarkerList();
        this.data3d.MyMarkers.ImportPositions(positions);
        this.data3d.InvalidateSlices();
        this.mypan.c1.UpdateAllNoCoord();
    }

    public void setMarkerInitTrackDir(int TD, int SX, int SY, int SZ, boolean UC, int CX, int CY, int CZ) {
        this.data3d.setMarkerInitTrackDir(TD, SX, SY, SZ, UC, CX, CY, CZ);
    }

    public static View5D Prepare5DViewer(int SizeX, int SizeY, int SizeZ, int Elements, int Times, int DataType, int NumBytes, int NumBits) {
        int redEl = -1;
        int greenEl = -1;
        int blueEl = -1;
        double[] Scales = new double[5];
        for (int j = 0; j < 5; ++j) {
            Scales[j] = 1.0;
        }
        double[] Offsets = new double[5];
        for (int j = 0; j < 5; ++j) {
            Offsets[j] = 0.0;
        }
        double ScaleV = 1.0;
        double OffsetV = 0.0;
        int HistoX = 0;
        int HistoY = -1;
        int HistoZ = -1;
        if (Elements > 1) {
            HistoY = 1;
        }
        if (Elements > 1) {
            redEl = 0;
            greenEl = 1;
        }
        if (Elements > 2) {
            blueEl = 2;
        }
        if (Elements >= 5) {
            redEl = -1;
            greenEl = -1;
            blueEl = -1;
        }
        String[] Names = new String[5];
        String[] Units = new String[5];
        Names[0] = "X";
        Names[1] = "Y";
        Names[2] = "Z";
        Names[3] = "Elements";
        Names[4] = "Time";
        Units[0] = "pixels";
        Units[1] = "ypixels";
        Units[2] = "zpixels";
        Units[3] = "elements";
        Units[4] = "time";
        String NameV = "intensity";
        String UnitV = "a.u.";
        View5D anApplet = new View5D();
        My3DData data3d = new My3DData(anApplet, SizeX, SizeY, SizeZ, Elements, Times, redEl, greenEl, blueEl, HistoX, HistoY, HistoZ, DataType, NumBytes, NumBits, Scales, Offsets, ScaleV, OffsetV, Names, Units);
        for (int e = 0; e < Elements; ++e) {
            data3d.SetValueScale(e, ScaleV, OffsetV, NameV, UnitV);
        }
        anApplet.data3d = data3d;
        anApplet.Elements = Elements;
        anApplet.Times = Times;
        anApplet.SizeX = SizeX;
        anApplet.SizeY = SizeY;
        anApplet.SizeZ = SizeZ;
        anApplet.redEl = redEl;
        anApplet.greenEl = greenEl;
        anApplet.blueEl = blueEl;
        anApplet.initLayout(Times);
        data3d.elementsLinked = Elements > 5;
        if (Elements > 1 && Elements < 5 || redEl >= 0) {
            data3d.ToggleColor(true);
        } else {
            data3d.ToggleColor(false);
        }
        return anApplet;
    }

    int ParseInt(String s, boolean dowarn, int adefault) {
        int result;
        try {
            result = Integer.parseInt(this.getParameter(s));
        }
        catch (Exception e) {
            if (dowarn) {
                System.out.println("ParseInt: Caught Exceptionlooking for Parameter " + s + ":" + e.getMessage());
                e.printStackTrace();
            }
            result = adefault;
        }
        return result;
    }

    double ParseDouble(String s, boolean dowarn, double adefault) {
        double result;
        try {
            result = Double.valueOf(this.getParameter(s));
        }
        catch (Exception e) {
            if (dowarn) {
                System.out.println("ParseDouble: Caught Exception looking for Parameter " + s + ":" + e.getMessage());
                e.printStackTrace();
            }
            result = adefault;
        }
        return result;
    }

    String ParseString(String s, boolean dowarn, String adefault) {
        String result = null;
        try {
            result = this.getParameter(s);
        }
        catch (Exception e) {
            if (dowarn) {
                System.out.println("ParseString: Caught Exception looking for Parameter " + s + ":" + e.getMessage());
                e.printStackTrace();
            }
            result = adefault;
        }
        if (result == null) {
            result = adefault;
        }
        return result;
    }

    public String StringFromType(int TypeNr) {
        if (TypeNr >= 0 && TypeNr < AnElement.NumTypes) {
            return AnElement.TypeNames[TypeNr];
        }
        System.out.println("Error in StringFromType: Unknown datatype: " + TypeNr + "\n");
        return "";
    }

    public int TypeFromString(String AType) {
        for (int i = 0; i < AnElement.NumTypes; ++i) {
            if (!AType.equals(AnElement.TypeNames[i]) && !AType.equals(AnElement.UTypeNames[i])) continue;
            return i;
        }
        System.out.println("Error: Unknown datatype: " + AType + "\n");
        return -1;
    }

    public void setFontSize(int FontSize) {
        this.data3d.setFontSize(FontSize);
    }

    public void initLayout(int Times) {
        this.setLayout(new BorderLayout());
        this.mypan = new ImgPanel(this, this.data3d);
        this.panels.addElement(this.mypan);
        this.add("Center", this.mypan);
        this.myLabel = new TextArea("5D-viewer Java Applet by Rainer Heintzmann, [press '?' for help]", 1, 76, 3);
        this.add("North", this.myLabel);
        this.mypan.CheckScrollBar();
        this.setVisible(true);
    }

    @Override
    public void init() {
        if (System.getProperty("java.version").compareTo("1.4") < 0) {
            this.setLayout(new BorderLayout());
            this.add("North", new ImageErr());
            this.setVisible(true);
        } else {
            String MyMarkerOut;
            String DatType;
            int DataTypeN;
            this.filename = this.getParameter("file");
            if (this.filename == null) {
                this.filename = "xxx.raw";
            }
            this.SizeX = Integer.parseInt(this.getParameter("sizex"));
            this.SizeY = Integer.parseInt(this.getParameter("sizey"));
            this.SizeZ = this.ParseInt("sizez", true, 1);
            this.Times = this.ParseInt("times", false, 1);
            this.defaultColor0 = this.ParseInt("defcol0", false, -1);
            this.Elements = this.ParseInt("elements", true, 1);
            this.data3d.elementsLinked = this.Elements >= 5;
            if (this.Elements > 1) {
                this.redEl = 0;
                this.greenEl = 1;
            }
            if (this.Elements > 2) {
                this.blueEl = 2;
            }
            if (this.Elements >= 5) {
                this.redEl = -1;
                this.greenEl = -1;
                this.blueEl = -1;
            }
            this.redEl = this.ParseInt("red", false, this.redEl);
            this.greenEl = this.ParseInt("green", false, this.greenEl);
            this.blueEl = this.ParseInt("blue", false, this.blueEl);
            int DataType = AnElement.ByteType;
            int NumBytes = 1;
            int NumBits = 8;
            NumBytes = this.ParseInt("bytes", false, NumBytes);
            NumBits = this.ParseInt("bits", false, NumBits);
            if (NumBytes > 1) {
                DataType = NumBytes > 1 ? AnElement.IntegerType : AnElement.ShortType;
            } else if (NumBytes == -1) {
                DataType = AnElement.FloatType;
                NumBytes = 4;
                NumBits = 32;
            }
            if (NumBytes * 8 < NumBits) {
                NumBits = NumBytes * 8;
            }
            if ((DataTypeN = this.TypeFromString(DatType = this.ParseString("dtype", false, this.StringFromType(DataType)))) != DataType) {
                DataType = DataTypeN;
                if (DataType == AnElement.IntegerType && NumBytes < 1) {
                    NumBytes = 2;
                }
                if (DataType == AnElement.ByteType) {
                    NumBytes = 1;
                }
                if (DataType == AnElement.FloatType) {
                    NumBytes = 4;
                }
                if (DataType == AnElement.DoubleType) {
                    NumBytes = 8;
                }
                if (DataType == AnElement.ComplexType) {
                    NumBytes = 8;
                }
                if (DataType == AnElement.ShortType) {
                    NumBytes = 2;
                }
                if (DataType == AnElement.LongType) {
                    DataType = AnElement.IntegerType;
                    NumBytes = 4;
                }
            }
            double[] Scales = new double[5];
            for (int j = 0; j < 5; ++j) {
                Scales[j] = 1.0;
            }
            double[] Offsets = new double[5];
            for (int j = 0; j < 5; ++j) {
                Offsets[j] = 0.0;
            }
            double ScaleV = 1.0;
            double OffsetV = 0.0;
            Scales[0] = this.ParseDouble("scalex", false, 1.0);
            Scales[1] = this.ParseDouble("scaley", false, 1.0);
            Scales[2] = this.ParseDouble("scalez", false, 1.0);
            Scales[3] = this.ParseDouble("scalee", false, 1.0);
            Scales[4] = this.ParseDouble("scalet", false, 1.0);
            Offsets[0] = this.ParseDouble("offsetx", false, 0.0);
            Offsets[1] = this.ParseDouble("offsety", false, 0.0);
            Offsets[2] = this.ParseDouble("offsetz", false, 0.0);
            Offsets[3] = this.ParseDouble("offsete", false, 0.0);
            Offsets[4] = this.ParseDouble("offsett", false, 0.0);
            String[] Names = new String[5];
            String[] Units = new String[5];
            String NameV = "intensity";
            String UnitV = "a.u.";
            Names[0] = this.ParseString("namex", false, "X");
            Names[1] = this.ParseString("namey", false, "Y");
            Names[2] = this.ParseString("namez", false, "Z");
            Names[3] = this.ParseString("namee", false, "Elements");
            Names[4] = this.ParseString("namet", false, "Time");
            Units[0] = this.ParseString("unitsx", false, "pixels");
            Units[1] = this.ParseString("unitsy", false, "ypixels");
            Units[2] = this.ParseString("unitsz", false, "zpixels");
            Units[3] = this.ParseString("unitse", false, "elements");
            Units[4] = this.ParseString("unitst", false, "time");
            if (this.SizeX <= 0) {
                this.SizeX = 256;
            }
            if (this.SizeY <= 0) {
                this.SizeY = 256;
            }
            if (this.SizeZ <= 0) {
                this.SizeZ = 10;
            }
            int HistoX = 0;
            int HistoY = -1;
            int HistoZ = -1;
            if (this.Elements > 1) {
                HistoY = 1;
            }
            HistoX = this.ParseInt("histox", false, HistoX);
            HistoY = this.ParseInt("histoy", false, HistoY);
            HistoZ = this.ParseInt("histoz", false, HistoZ);
            this.data3d = new My3DData(this, this.SizeX, this.SizeY, this.SizeZ, this.Elements, this.Times, this.redEl, this.greenEl, this.blueEl, HistoX, HistoY, HistoZ, DataType, NumBytes, NumBits, Scales, Offsets, ScaleV, OffsetV, Names, Units);
            if (this.defaultColor0 > 0) {
                this.data3d.ToggleModel(0, this.defaultColor0);
            }
            for (int e = 0; e < this.Elements; ++e) {
                ScaleV = this.ParseDouble("scalev" + (e + 1), false, 1.0);
                OffsetV = this.ParseDouble("offsetv" + (e + 1), false, 0.0);
                NameV = this.ParseString("namev" + (e + 1), false, "intensity");
                UnitV = this.ParseString("unitsv" + (e + 1), false, "a.u.");
                this.data3d.SetValueScale(e, ScaleV, OffsetV, NameV, UnitV);
            }
            this.data3d.Load(DataType, NumBytes, NumBits, this.getDocumentBase() + this.filename);
            String MyMarkerIn = this.getParameter("markerInFile");
            if (MyMarkerIn != null) {
                this.data3d.markerInfilename = MyMarkerIn;
                System.out.println("... loading marker file " + this.data3d.markerInfilename);
                this.data3d.LoadMarkers();
            }
            if ((MyMarkerOut = this.getParameter("markerOutFile")) != null) {
                this.data3d.markerOutfilename = MyMarkerOut;
            }
            this.initLayout(this.Times);
            this.data3d.elementsLinked = this.Elements >= 5;
            if (this.Elements > 1 && this.Elements < 5 || this.redEl >= 0) {
                this.data3d.ToggleColor(true);
            } else {
                this.data3d.ToggleColor(false);
            }
        }
    }

    public void setElement(int e) {
        if (e < 0) {
            e = this.getNumElements() - 1;
        }
        this.data3d.setElement(e);
    }

    public void setTime(int t) {
        if (t < 0) {
            t = this.getNumTime() - 1;
        }
        this.data3d.setTime(t);
    }

    public void setPosition(int x, int y, int z, int e, int t) {
        this.setElement(e);
        this.setTime(t);
        for (int i = 0; i < this.panels.size(); ++i) {
            ImgPanel pan = this.panels.elementAt(i);
            pan.setPositions(new APoint(x, y, z, e, t));
            pan.c1.label.CoordsChanged();
            pan.c1.CalcPrev();
            pan.c1.label.CoordsChanged();
            pan.c1.UpdateAll();
        }
    }

    @Override
    public void start() {
        this.data3d.AdjustThresh();
        this.mypan.InitScaling();
    }

    @Override
    public void stop() {
    }

    @Override
    public void destroy() {
        this.data3d.cleanup();
    }

    public My3DData get_data() {
        return this.data3d;
    }

    public Bundle get_bundle_at(int ne) {
        return this.data3d.GetBundleAt(ne);
    }

    public void set_colormap_no(int nr, int elem) {
        this.data3d.ToggleModel(elem, nr);
        this.mypan.c1.UpdateAll();
    }

    public int get_active_element() {
        return this.data3d.ActiveElement;
    }

    public int get_active_time() {
        return this.data3d.ActiveTime;
    }

    public void add_colormap(int sz, byte[] reds, byte[] greens, byte[] blues, int type) {
        int lastLUT = this.data3d.AddLookUpTable(sz, reds, greens, blues, type);
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        String LUTName = "User defined " + nf.format(lastLUT - 15 + 1);
        this.mypan.label.PixDisplay.AddColorMenu(LUTName, lastLUT);
        this.data3d.SetColorModelNr(this.data3d.ActiveElement, lastLUT);
        if (!this.data3d.SetThresh(0.0, sz - 1)) {
            this.data3d.InvalidateSlices();
        }
        this.mypan.c1.UpdateAll();
    }

    @Override
    public String getAppletInfo() {
        return "A 5Dimage viewing tool.";
    }
}

